/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.security.cert;

import java.lang.invoke.MethodHandles;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.solr.security.cert.CertResolverPattern;
import org.apache.solr.security.cert.CertUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PathBasedCertResolverBase {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String PARAM_NAME = "name";
    private static final String PARAM_PATH = "path";
    private static final String PARAM_FILTER = "filter";
    private static final String PARAM_FILTER_CHECK_TYPE = "checkType";
    private static final String PARAM_FILTER_VALUES = "values";

    protected CertResolverPattern createCertResolverPattern(Map<String, Object> config, String defaultPath) {
        String path = ((String)config.getOrDefault(PARAM_PATH, defaultPath)).toLowerCase(Locale.ROOT);
        String name = ((String)config.getOrDefault(PARAM_NAME, path)).toLowerCase(Locale.ROOT);
        Map filter = config.getOrDefault(PARAM_FILTER, Collections.emptyMap());
        String checkType = filter.getOrDefault(PARAM_FILTER_CHECK_TYPE, CertResolverPattern.CheckType.WILDCARD.toString());
        List values = filter.getOrDefault(PARAM_FILTER_VALUES, Collections.emptyList());
        Set<String> lowerCaseValues = values.stream().map(value -> value.toLowerCase(Locale.ROOT)).collect(Collectors.toSet());
        return new CertResolverPattern(name, path, checkType, lowerCaseValues);
    }

    protected Map<String, Set<String>> getValuesFromPaths(X509Certificate certificate, List<CertResolverPattern> patterns) throws CertificateParsingException {
        HashMap<String, Set<String>> fieldValuesMap = new HashMap<String, Set<String>>();
        for (CertResolverPattern pattern : patterns) {
            String path = pattern.getPath();
            if (path.startsWith("subject.dn") || path.startsWith("issuer.dn")) {
                Optional<String> value2 = path.startsWith("subject.dn") ? CertUtil.extractFromSubjectDN(certificate, path) : CertUtil.extractFromIssuerDN(certificate, path);
                value2.ifPresent(val -> fieldValuesMap.computeIfAbsent(pattern.getName(), k -> new LinkedHashSet()).add(val));
                continue;
            }
            if (path.startsWith("san.")) {
                Optional<List<String>> sanValues = CertUtil.extractFromSAN(certificate, path, value -> CertResolverPattern.matchesPattern(value, pattern));
                sanValues.ifPresent(values -> fieldValuesMap.computeIfAbsent(pattern.getName(), k -> new LinkedHashSet()).addAll(values));
                continue;
            }
            throw new IllegalArgumentException("Invalid path in the certificate resolver pattern: " + path);
        }
        log.debug("Extracted field values: {}", fieldValuesMap);
        return fieldValuesMap;
    }
}

