/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.modern;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.image.TopicsImage;

public class TopicIds
implements Set<Uuid> {
    private final Set<String> topicNames;
    private final TopicsImage image;

    public TopicIds(Set<String> topicNames, TopicsImage image) {
        this.topicNames = Objects.requireNonNull(topicNames);
        this.image = Objects.requireNonNull(image);
    }

    @Override
    public int size() {
        return this.topicNames.size();
    }

    @Override
    public boolean isEmpty() {
        return this.topicNames.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof Uuid) {
            Uuid topicId = (Uuid)o;
            TopicImage topicImage = this.image.getTopic(topicId);
            if (topicImage == null) {
                return false;
            }
            return this.topicNames.contains(topicImage.name());
        }
        return false;
    }

    @Override
    public Iterator<Uuid> iterator() {
        return new TopicIdIterator(this.topicNames.iterator(), this.image);
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(Uuid o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TopicIds uuids = (TopicIds)o;
        if (!Objects.equals(this.topicNames, uuids.topicNames)) {
            return false;
        }
        return Objects.equals(this.image, uuids.image);
    }

    @Override
    public int hashCode() {
        int result = this.topicNames.hashCode();
        result = 31 * result + this.image.hashCode();
        return result;
    }

    public String toString() {
        return "TopicIds(topicNames=" + this.topicNames + ", image=" + this.image + ')';
    }

    private static class TopicIdIterator
    implements Iterator<Uuid> {
        final Iterator<String> iterator;
        final TopicsImage image;
        private Uuid next = null;

        private TopicIdIterator(Iterator<String> iterator, TopicsImage image) {
            this.iterator = Objects.requireNonNull(iterator);
            this.image = Objects.requireNonNull(image);
        }

        @Override
        public boolean hasNext() {
            if (this.next != null) {
                return true;
            }
            Uuid result = null;
            do {
                if (!this.iterator.hasNext()) {
                    return false;
                }
                String next = this.iterator.next();
                TopicImage topicImage = this.image.getTopic(next);
                if (topicImage == null) continue;
                result = topicImage.id();
            } while (result == null);
            this.next = result;
            return true;
        }

        @Override
        public Uuid next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Uuid result = this.next;
            this.next = null;
            return result;
        }
    }
}

