/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.metadata;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import kafka.server.KafkaConfig;
import kafka.server.metadata.ClientQuotaMetadataManager;
import kafka.utils.Logging;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.loader.LoaderManifest;
import org.apache.kafka.image.publisher.MetadataPublisher;
import org.apache.kafka.raft.LeaderAndEpoch;
import org.apache.kafka.server.fault.FaultHandler;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u000554A!\u0003\u0006\u0001#!A1\u0006\u0001B\u0001B\u0003%A\u0006\u0003\u00051\u0001\t\u0005\t\u0015!\u00032\u0011!A\u0004A!A!\u0002\u0013I\u0004\u0002\u0003#\u0001\u0005\u0003\u0005\u000b\u0011B#\t\u000b%\u0003A\u0011\u0001&\t\u000bA\u0003A\u0011I)\t\u000bI\u0003A\u0011I*\t\u000bI\u0003A\u0011\u00016\u00037\u0011Kh.Y7jG\u000ec\u0017.\u001a8u#V|G/\u0019)vE2L7\u000f[3s\u0015\tYA\"\u0001\u0005nKR\fG-\u0019;b\u0015\tia\"\u0001\u0004tKJ4XM\u001d\u0006\u0002\u001f\u0005)1.\u00194lC\u000e\u00011\u0003\u0002\u0001\u00131y\u0001\"a\u0005\f\u000e\u0003QQ\u0011!F\u0001\u0006g\u000e\fG.Y\u0005\u0003/Q\u0011a!\u00118z%\u00164\u0007CA\r\u001d\u001b\u0005Q\"BA\u000e\u000f\u0003\u0015)H/\u001b7t\u0013\ti\"DA\u0004M_\u001e<\u0017N\\4\u0011\u0005}IS\"\u0001\u0011\u000b\u0005\u0005\u0012\u0013!\u00039vE2L7\u000f[3s\u0015\t\u0019C%A\u0003j[\u0006<WM\u0003\u0002\u0010K)\u0011aeJ\u0001\u0007CB\f7\r[3\u000b\u0003!\n1a\u001c:h\u0013\tQ\u0003EA\tNKR\fG-\u0019;b!V\u0014G.[:iKJ\fAaY8oMB\u0011QFL\u0007\u0002\u0019%\u0011q\u0006\u0004\u0002\f\u0017\u000647.Y\"p]\u001aLw-\u0001\u0007gCVdG\u000fS1oI2,'\u000f\u0005\u00023m5\t1G\u0003\u00025k\u0005)a-Y;mi*\u0011Q\u0002J\u0005\u0003oM\u0012ABR1vYRD\u0015M\u001c3mKJ\f\u0001B\\8eKRK\b/\u001a\t\u0003u\u0005s!aO \u0011\u0005q\"R\"A\u001f\u000b\u0005y\u0002\u0012A\u0002\u001fs_>$h(\u0003\u0002A)\u00051\u0001K]3eK\u001aL!AQ\"\u0003\rM#(/\u001b8h\u0015\t\u0001E#\u0001\u000edY&,g\u000e^)v_R\fW*\u001a;bI\u0006$\u0018-T1oC\u001e,'\u000f\u0005\u0002G\u000f6\t!\"\u0003\u0002I\u0015\tQ2\t\\5f]R\fVo\u001c;b\u001b\u0016$\u0018\rZ1uC6\u000bg.Y4fe\u00061A(\u001b8jiz\"Ra\u0013'N\u001d>\u0003\"A\u0012\u0001\t\u000b-*\u0001\u0019\u0001\u0017\t\u000bA*\u0001\u0019A\u0019\t\u000ba*\u0001\u0019A\u001d\t\u000b\u0011+\u0001\u0019A#\u0002\t9\fW.\u001a\u000b\u0002s\u0005\u0001rN\\'fi\u0006$\u0017\r^1Va\u0012\fG/\u001a\u000b\u0005)^k&\r\u0005\u0002\u0014+&\u0011a\u000b\u0006\u0002\u0005+:LG\u000fC\u0003Y\u000f\u0001\u0007\u0011,A\u0003eK2$\u0018\r\u0005\u0002[76\t!%\u0003\u0002]E\tiQ*\u001a;bI\u0006$\u0018\rR3mi\u0006DQAX\u0004A\u0002}\u000b\u0001B\\3x\u00136\fw-\u001a\t\u00035\u0002L!!\u0019\u0012\u0003\u001b5+G/\u00193bi\u0006LU.Y4f\u0011\u0015\u0019w\u00011\u0001e\u0003!i\u0017M\\5gKN$\bCA3i\u001b\u00051'BA4#\u0003\u0019aw.\u00193fe&\u0011\u0011N\u001a\u0002\u000f\u0019>\fG-\u001a:NC:Lg-Z:u)\r!6\u000e\u001c\u0005\u00061\"\u0001\r!\u0017\u0005\u0006=\"\u0001\ra\u0018")
public class DynamicClientQuotaPublisher
implements Logging,
MetadataPublisher {
    private final KafkaConfig conf;
    private final FaultHandler faultHandler;
    private final String nodeType;
    private final ClientQuotaMetadataManager clientQuotaMetadataManager;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public void onControllerChange(LeaderAndEpoch x$1) {
        super.onControllerChange(x$1);
    }

    public void close() throws Exception {
        super.close();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public String name() {
        return new StringBuilder(32).append("DynamicClientQuotaPublisher ").append(this.nodeType).append(" id=").append(this.conf.nodeId()).toString();
    }

    public void onMetadataUpdate(MetadataDelta delta, MetadataImage newImage, LoaderManifest manifest) {
        this.onMetadataUpdate(delta, newImage);
    }

    public void onMetadataUpdate(MetadataDelta delta, MetadataImage newImage) {
        String deltaName = new StringBuilder(20).append("MetadataDelta up to ").append(newImage.highestOffsetAndEpoch().offset()).toString();
        try {
            Option$.MODULE$.apply((Object)delta.clientQuotasDelta()).foreach((Function1 & Serializable)clientQuotasDelta -> {
                this.clientQuotaMetadataManager.update(clientQuotasDelta);
                return BoxedUnit.UNIT;
            });
            return;
        }
        catch (Throwable t) {
            this.faultHandler.handleFault(new StringBuilder(70).append("Uncaught exception while ").append("publishing dynamic client quota changes from ").append(deltaName).toString(), t);
            return;
        }
    }

    public DynamicClientQuotaPublisher(KafkaConfig conf, FaultHandler faultHandler, String nodeType, ClientQuotaMetadataManager clientQuotaMetadataManager) {
        this.conf = conf;
        this.faultHandler = faultHandler;
        this.nodeType = nodeType;
        this.clientQuotaMetadataManager = clientQuotaMetadataManager;
        this.logIdent_$eq(new StringBuilder(3).append("[").append(this.name()).append("] ").toString());
    }
}

