/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.data.message;

import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import dev.langchain4j.data.message.Content;
import dev.langchain4j.data.message.ContentType;
import java.lang.reflect.Type;

class GsonContentAdapter
implements JsonDeserializer<Content>,
JsonSerializer<Content> {
    private static final Gson GSON = new Gson();
    private static final String CONTENT_TYPE = "type";

    GsonContentAdapter() {
    }

    public JsonElement serialize(Content content, Type ignored, JsonSerializationContext context) {
        JsonObject contentJsonObject = GSON.toJsonTree((Object)content).getAsJsonObject();
        contentJsonObject.addProperty(CONTENT_TYPE, content.type().toString());
        return contentJsonObject;
    }

    public Content deserialize(JsonElement contentJsonElement, Type ignored, JsonDeserializationContext context) {
        String contentTypeString = contentJsonElement.getAsJsonObject().get(CONTENT_TYPE).getAsString();
        ContentType contentType = ContentType.valueOf(contentTypeString);
        return (Content)GSON.fromJson(contentJsonElement, contentType.getContentClass());
    }
}

