/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.hdfs.index;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.lucene.index.CheckIndex;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.SuppressForbidden;
import org.apache.solr.common.util.EnvUtils;
import org.apache.solr.hdfs.store.HdfsDirectory;
import org.apache.solr.hdfs.util.HdfsUtil;

public class CheckHdfsIndex {
    @SuppressForbidden(reason="This is a CLI tool, allow to exit the JVM")
    public static void main(String[] args) throws IOException, InterruptedException {
        int exitCode = CheckHdfsIndex.doMain(args);
        System.exit(exitCode);
    }

    @SuppressForbidden(reason="System.out required: command line tool")
    protected static int doMain(String[] args) throws IOException, InterruptedException {
        HdfsDirectory directory;
        CheckIndex.Options opts;
        try {
            opts = CheckIndex.parseOptions((String[])args);
        }
        catch (IllegalArgumentException e) {
            System.out.println(e.getMessage());
            return 1;
        }
        if (!CheckIndex.assertsOn()) {
            System.out.println("\nNOTE: testing will be more thorough if you run java with '-ea:org.apache.lucene...', so assertions are enabled");
        }
        if (opts.getDirImpl() != null) {
            System.out.println("\nIgnoring specified -dir-impl, instead using " + HdfsDirectory.class.getSimpleName());
        }
        Path indexPath = new Path(opts.getIndexPath());
        System.out.println("\nOpening index @ " + indexPath + "\n");
        try {
            directory = new HdfsDirectory(indexPath, CheckHdfsIndex.getConf(indexPath));
        }
        catch (IOException e) {
            System.out.println("ERROR: could not open hdfs directory \"" + indexPath + "\"; exiting");
            e.printStackTrace(System.out);
            return 1;
        }
        try (HdfsDirectory dir = directory;){
            int n;
            try (CheckIndex checker = new CheckIndex((Directory)dir);){
                opts.setOut(System.out);
                n = checker.doCheck(opts);
            }
            return n;
        }
    }

    private static Configuration getConf(Path path) {
        Configuration conf = new Configuration();
        String confDir = EnvUtils.getProperty((String)"solr.hdfs.confdir");
        HdfsUtil.addHdfsResources(conf, confDir);
        String fsScheme = path.toUri().getScheme();
        if (fsScheme != null) {
            conf.setBoolean("fs." + fsScheme + ".impl.disable.cache", true);
        }
        return conf;
    }
}

