/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.data;

import brut.androlib.exceptions.AndrolibException;
import brut.androlib.exceptions.UndefinedResObjectException;
import brut.androlib.res.data.ResConfigFlags;
import brut.androlib.res.data.ResResSpec;
import brut.androlib.res.data.ResResource;
import java.util.LinkedHashMap;
import java.util.Map;

public class ResType {
    private final ResConfigFlags mFlags;
    private final Map<ResResSpec, ResResource> mResources;

    public ResType(ResConfigFlags flags) {
        this.mFlags = flags;
        this.mResources = new LinkedHashMap<ResResSpec, ResResource>();
    }

    public ResResource getResource(ResResSpec spec) throws AndrolibException {
        ResResource res = this.mResources.get(spec);
        if (res == null) {
            throw new UndefinedResObjectException(String.format("resource: spec=%s, config=%s", spec, this));
        }
        return res;
    }

    public ResConfigFlags getFlags() {
        return this.mFlags;
    }

    public void addResource(ResResource res) throws AndrolibException {
        this.addResource(res, false);
    }

    public void addResource(ResResource res, boolean overwrite) throws AndrolibException {
        ResResSpec spec = res.getResSpec();
        if (this.mResources.put(spec, res) != null && !overwrite) {
            throw new AndrolibException(String.format("Multiple resources: spec=%s, config=%s", spec, this));
        }
    }

    public String toString() {
        return this.mFlags.toString();
    }
}

