/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.dexlib2.immutable;

import com.android.tools.smali.dexlib2.iface.MultiDexContainer;
import com.android.tools.smali.dexlib2.immutable.ImmutableDexFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ImmutableMultiDexContainer
implements MultiDexContainer<ImmutableDexFile> {
    private final Map<String, ImmutableDexEntry> entries;

    public ImmutableMultiDexContainer(Map<String, ImmutableDexFile> entries) {
        HashMap<String, ImmutableDexEntry> map = new HashMap<String, ImmutableDexEntry>();
        for (Map.Entry<String, ImmutableDexFile> entry : entries.entrySet()) {
            ImmutableDexEntry dexEntry = new ImmutableDexEntry(entry.getKey(), entry.getValue());
            map.put(dexEntry.getEntryName(), dexEntry);
        }
        this.entries = Collections.unmodifiableMap(map);
    }

    @Override
    @Nonnull
    public List<String> getDexEntryNames() {
        return Collections.unmodifiableList(new ArrayList<String>(this.entries.keySet()));
    }

    @Nullable
    public ImmutableDexEntry getEntry(@Nonnull String entryName) {
        return this.entries.get(entryName);
    }

    public class ImmutableDexEntry
    implements MultiDexContainer.DexEntry<ImmutableDexFile> {
        private final String entryName;
        private final ImmutableDexFile dexFile;

        protected ImmutableDexEntry(String entryName, ImmutableDexFile dexFile) {
            this.entryName = entryName;
            this.dexFile = dexFile;
        }

        @Override
        @Nonnull
        public String getEntryName() {
            return this.entryName;
        }

        @Override
        @Nonnull
        public ImmutableDexFile getDexFile() {
            return this.dexFile;
        }

        @Override
        @Nonnull
        public MultiDexContainer<? extends ImmutableDexFile> getContainer() {
            return ImmutableMultiDexContainer.this;
        }
    }
}

