/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.data;

import java.util.logging.Logger;

public class ResConfigFlags {
    private static final Logger LOGGER = Logger.getLogger(ResConfigFlags.class.getName());
    public static final int SDK_BASE = 1;
    public static final int SDK_BASE_1_1 = 2;
    public static final int SDK_CUPCAKE = 3;
    public static final int SDK_DONUT = 4;
    public static final int SDK_ECLAIR = 5;
    public static final int SDK_ECLAIR_0_1 = 6;
    public static final int SDK_ECLAIR_MR1 = 7;
    public static final int SDK_FROYO = 8;
    public static final int SDK_GINGERBREAD = 9;
    public static final int SDK_GINGERBREAD_MR1 = 10;
    public static final int SDK_HONEYCOMB = 11;
    public static final int SDK_HONEYCOMB_MR1 = 12;
    public static final int SDK_HONEYCOMB_MR2 = 13;
    public static final int SDK_ICE_CREAM_SANDWICH = 14;
    public static final int SDK_ICE_CREAM_SANDWICH_MR1 = 15;
    public static final int SDK_JELLY_BEAN = 16;
    public static final int SDK_JELLY_BEAN_MR1 = 17;
    public static final int SDK_JELLY_BEAN_MR2 = 18;
    public static final int SDK_KITKAT = 19;
    public static final int SDK_LOLLIPOP = 21;
    public static final int SDK_LOLLIPOP_MR1 = 22;
    public static final int SDK_MNC = 23;
    public static final int SDK_NOUGAT = 24;
    public static final int SDK_NOUGAT_MR1 = 25;
    public static final int SDK_OREO = 26;
    public static final int SDK_OREO_MR1 = 27;
    public static final int SDK_P = 28;
    public static final int SDK_Q = 29;
    public static final int SDK_R = 30;
    public static final int SDK_S = 31;
    public static final int SDK_S_V2 = 32;
    public static final int SDK_TIRAMISU = 33;
    public static final int SDK_UPSIDEDOWN_CAKE = 34;
    public static final int SDK_VANILLA_ICE_CREAM = 35;
    public static final int SDK_BAKLAVA = 36;
    public static final int SDK_DEVELOPMENT = 10000;
    public static final int MNC_ZERO = 65535;
    public static final int ORIENTATION_ANY = 0;
    public static final int ORIENTATION_PORT = 1;
    public static final int ORIENTATION_LAND = 2;
    public static final int ORIENTATION_SQUARE = 3;
    public static final int TOUCHSCREEN_ANY = 0;
    public static final int TOUCHSCREEN_NOTOUCH = 1;
    public static final int TOUCHSCREEN_STYLUS = 2;
    public static final int TOUCHSCREEN_FINGER = 3;
    public static final int DENSITY_DEFAULT = 0;
    public static final int DENSITY_LOW = 120;
    public static final int DENSITY_MEDIUM = 160;
    public static final int DENSITY_TV = 213;
    public static final int DENSITY_HIGH = 240;
    public static final int DENSITY_XHIGH = 320;
    public static final int DENSITY_XXHIGH = 480;
    public static final int DENSITY_XXXHIGH = 640;
    public static final int DENSITY_ANY = 65534;
    public static final int DENSITY_NONE = 65535;
    public static final int KEYBOARD_ANY = 0;
    public static final int KEYBOARD_NOKEYS = 1;
    public static final int KEYBOARD_QWERTY = 2;
    public static final int KEYBOARD_12KEY = 3;
    public static final int NAVIGATION_ANY = 0;
    public static final int NAVIGATION_NONAV = 1;
    public static final int NAVIGATION_DPAD = 2;
    public static final int NAVIGATION_TRACKBALL = 3;
    public static final int NAVIGATION_WHEEL = 4;
    public static final int MASK_KEYSHIDDEN = 3;
    public static final int KEYSHIDDEN_ANY = 0;
    public static final int KEYSHIDDEN_NO = 1;
    public static final int KEYSHIDDEN_YES = 2;
    public static final int KEYSHIDDEN_SOFT = 3;
    public static final int SHIFT_NAVHIDDEN = 2;
    public static final int MASK_NAVHIDDEN = 12;
    public static final int NAVHIDDEN_ANY = 0;
    public static final int NAVHIDDEN_NO = 4;
    public static final int NAVHIDDEN_YES = 8;
    public static final int MASK_GRAMMATICAL_GENDER = 3;
    public static final int GRAMMATICAL_GENDER_ANY = 0;
    public static final int GRAMMATICAL_GENDER_NEUTER = 1;
    public static final int GRAMMATICAL_GENDER_FEMININE = 2;
    public static final int GRAMMATICAL_GENDER_MASCULINE = 3;
    public static final int MASK_SCREENSIZE = 15;
    public static final int SCREENSIZE_ANY = 0;
    public static final int SCREENSIZE_SMALL = 1;
    public static final int SCREENSIZE_NORMAL = 2;
    public static final int SCREENSIZE_LARGE = 3;
    public static final int SCREENSIZE_XLARGE = 4;
    public static final int SHIFT_SCREENLONG = 4;
    public static final int MASK_SCREENLONG = 48;
    public static final int SCREENLONG_ANY = 0;
    public static final int SCREENLONG_NO = 16;
    public static final int SCREENLONG_YES = 32;
    public static final int SHIFT_LAYOUTDIR = 6;
    public static final int MASK_LAYOUTDIR = 192;
    public static final int LAYOUTDIR_ANY = 0;
    public static final int LAYOUTDIR_LTR = 64;
    public static final int LAYOUTDIR_RTL = 128;
    public static final int MASK_UI_MODE_TYPE = 15;
    public static final int UI_MODE_TYPE_ANY = 0;
    public static final int UI_MODE_TYPE_NORMAL = 1;
    public static final int UI_MODE_TYPE_DESK = 2;
    public static final int UI_MODE_TYPE_CAR = 3;
    public static final int UI_MODE_TYPE_TELEVISION = 4;
    public static final int UI_MODE_TYPE_APPLIANCE = 5;
    public static final int UI_MODE_TYPE_WATCH = 6;
    public static final int UI_MODE_TYPE_VR_HEADSET = 7;
    public static final int UI_MODE_TYPE_GODZILLAUI = 11;
    public static final int UI_MODE_TYPE_SMALLUI = 12;
    public static final int UI_MODE_TYPE_MEDIUMUI = 13;
    public static final int UI_MODE_TYPE_LARGEUI = 14;
    public static final int UI_MODE_TYPE_HUGEUI = 15;
    public static final int SHIFT_UI_MODE_NIGHT = 4;
    public static final int MASK_UI_MODE_NIGHT = 48;
    public static final int UI_MODE_NIGHT_ANY = 0;
    public static final int UI_MODE_NIGHT_NO = 16;
    public static final int UI_MODE_NIGHT_YES = 32;
    public static final int MASK_SCREENROUND = 3;
    public static final int SCREENROUND_ANY = 0;
    public static final int SCREENROUND_NO = 1;
    public static final int SCREENROUND_YES = 2;
    public static final int MASK_COLOR_MODE_WIDECG = 3;
    public static final int COLOR_MODE_WIDECG_ANY = 0;
    public static final int COLOR_MODE_WIDECG_NO = 1;
    public static final int COLOR_MODE_WIDECG_YES = 2;
    public static final int SHIFT_COLOR_MODE_HDR = 2;
    public static final int MASK_COLOR_MODE_HDR = 12;
    public static final int COLOR_MODE_HDR_ANY = 0;
    public static final int COLOR_MODE_HDR_NO = 4;
    public static final int COLOR_MODE_HDR_YES = 8;
    private final int mMcc;
    private final int mMnc;
    private final String mLanguage;
    private final String mRegion;
    private final int mOrientation;
    private final int mTouchscreen;
    private final int mDensity;
    private final int mKeyboard;
    private final int mNavigation;
    private final int mInputFlags;
    private final int mGrammaticalInflection;
    private final int mScreenWidth;
    private final int mScreenHeight;
    private final int mSdkVersion;
    private final int mMinorVersion;
    private final int mScreenLayout;
    private final int mUiMode;
    private final int mSmallestScreenWidthDp;
    private final int mScreenWidthDp;
    private final int mScreenHeightDp;
    private final String mLocaleScript;
    private final String mLocaleVariant;
    private final int mScreenLayout2;
    private final int mColorMode;
    private final String mLocaleNumberingSystem;
    private final String mQualifiers;
    private boolean mIsInvalid;

    public ResConfigFlags() {
        this.mMcc = 0;
        this.mMnc = 0;
        this.mLanguage = "";
        this.mRegion = "";
        this.mOrientation = 0;
        this.mTouchscreen = 0;
        this.mDensity = 0;
        this.mKeyboard = 0;
        this.mNavigation = 0;
        this.mInputFlags = 0;
        this.mGrammaticalInflection = 0;
        this.mScreenWidth = 0;
        this.mScreenHeight = 0;
        this.mSdkVersion = 0;
        this.mMinorVersion = 0;
        this.mScreenLayout = 0;
        this.mUiMode = 0;
        this.mSmallestScreenWidthDp = 0;
        this.mScreenWidthDp = 0;
        this.mScreenHeightDp = 0;
        this.mLocaleScript = "";
        this.mLocaleVariant = "";
        this.mScreenLayout2 = 0;
        this.mColorMode = 0;
        this.mLocaleNumberingSystem = "";
        this.mQualifiers = "";
    }

    public ResConfigFlags(int mcc, int mnc, String language, String region, int orientation, int touchscreen, int density, int keyboard, int navigation, int inputFlags, int grammaticalInflection, int screenWidth, int screenHeight, int sdkVersion, int minorVersion, int screenLayout, int uiMode, int smallestScreenWidthDp, int screenWidthDp, int screenHeightDp, String localeScript, String localeVariant, int screenLayout2, int colorMode, String localeNumberingSystem) {
        this.mMcc = mcc;
        this.mMnc = mnc;
        this.mLanguage = language;
        this.mRegion = region;
        this.mOrientation = orientation;
        this.mTouchscreen = touchscreen;
        this.mDensity = density;
        this.mKeyboard = keyboard;
        this.mNavigation = navigation;
        this.mInputFlags = inputFlags;
        this.mGrammaticalInflection = grammaticalInflection;
        this.mScreenWidth = screenWidth;
        this.mScreenHeight = screenHeight;
        this.mSdkVersion = sdkVersion;
        this.mMinorVersion = minorVersion;
        this.mScreenLayout = screenLayout;
        this.mUiMode = uiMode;
        this.mSmallestScreenWidthDp = smallestScreenWidthDp;
        this.mScreenWidthDp = screenWidthDp;
        this.mScreenHeightDp = screenHeightDp;
        this.mLocaleScript = localeScript;
        this.mLocaleVariant = localeVariant;
        this.mScreenLayout2 = screenLayout2;
        this.mColorMode = colorMode;
        this.mLocaleNumberingSystem = localeNumberingSystem;
        this.mQualifiers = this.generateQualifiers();
    }

    private String generateQualifiers() {
        StringBuilder sb = new StringBuilder();
        if (this.mMcc != 0) {
            sb.append("-mcc").append(String.format("%03d", this.mMcc));
        }
        if (this.mMnc != 0) {
            sb.append("-mnc").append(String.format("%02d", this.mMnc == 65535 ? 0 : this.mMnc));
        }
        if (!this.mLanguage.isEmpty()) {
            if (this.mLocaleScript.isEmpty() && (this.mRegion.isEmpty() || this.mRegion.length() == 2) && this.mLocaleVariant.isEmpty()) {
                sb.append("-").append(this.mLanguage);
                if (!this.mRegion.isEmpty()) {
                    sb.append("-r").append(this.mRegion);
                }
            } else {
                sb.append("-b+");
                sb.append(this.mLanguage);
                if (!this.mLocaleScript.isEmpty()) {
                    sb.append("+").append(this.mLocaleScript);
                }
                if (!this.mRegion.isEmpty()) {
                    sb.append("+").append(this.mRegion);
                }
                if (!this.mLocaleVariant.isEmpty()) {
                    sb.append("+").append(this.mLocaleVariant);
                }
            }
        }
        switch (this.mGrammaticalInflection & 3) {
            case 0: {
                break;
            }
            case 1: {
                sb.append("-neuter");
                break;
            }
            case 2: {
                sb.append("-feminine");
                break;
            }
            case 3: {
                sb.append("-masculine");
                break;
            }
            default: {
                sb.append("-grammaticalGender=").append(this.mGrammaticalInflection & 3);
                this.mIsInvalid = true;
            }
        }
        switch (this.mScreenLayout & 0xC0) {
            case 0: {
                break;
            }
            case 64: {
                sb.append("-ldltr");
                break;
            }
            case 128: {
                sb.append("-ldrtl");
                break;
            }
            default: {
                sb.append("-layoutDir=").append(this.mScreenLayout & 0xC0);
                this.mIsInvalid = true;
            }
        }
        if (this.mSmallestScreenWidthDp != 0) {
            sb.append("-sw").append(this.mSmallestScreenWidthDp).append("dp");
        }
        if (this.mScreenWidthDp != 0) {
            sb.append("-w").append(this.mScreenWidthDp).append("dp");
        }
        if (this.mScreenHeightDp != 0) {
            sb.append("-h").append(this.mScreenHeightDp).append("dp");
        }
        switch (this.mScreenLayout & 0xF) {
            case 0: {
                break;
            }
            case 1: {
                sb.append("-small");
                break;
            }
            case 2: {
                sb.append("-normal");
                break;
            }
            case 3: {
                sb.append("-large");
                break;
            }
            case 4: {
                sb.append("-xlarge");
                break;
            }
            default: {
                sb.append("-screenSize=").append(this.mScreenLayout & 0xF);
                this.mIsInvalid = true;
            }
        }
        switch (this.mScreenLayout & 0x30) {
            case 0: {
                break;
            }
            case 16: {
                sb.append("-notlong");
                break;
            }
            case 32: {
                sb.append("-long");
                break;
            }
            default: {
                sb.append("-screenLong=").append(this.mScreenLayout & 0x30);
                this.mIsInvalid = true;
            }
        }
        switch (this.mScreenLayout2 & 3) {
            case 0: {
                break;
            }
            case 1: {
                sb.append("-notround");
                break;
            }
            case 2: {
                sb.append("-round");
                break;
            }
            default: {
                sb.append("-screenRound=").append(this.mScreenLayout2 & 3);
                this.mIsInvalid = true;
            }
        }
        switch (this.mColorMode & 3) {
            case 0: {
                break;
            }
            case 1: {
                sb.append("-nowidecg");
                break;
            }
            case 2: {
                sb.append("-widecg");
                break;
            }
            default: {
                sb.append("-colorModeWideCG=").append(this.mColorMode & 3);
                this.mIsInvalid = true;
            }
        }
        switch (this.mColorMode & 0xC) {
            case 0: {
                break;
            }
            case 4: {
                sb.append("-lowdr");
                break;
            }
            case 8: {
                sb.append("-highdr");
                break;
            }
            default: {
                sb.append("-colorModeHdr=").append(this.mColorMode & 0xC);
                this.mIsInvalid = true;
            }
        }
        switch (this.mOrientation) {
            case 0: {
                break;
            }
            case 1: {
                sb.append("-port");
                break;
            }
            case 2: {
                sb.append("-land");
                break;
            }
            case 3: {
                sb.append("-square");
                break;
            }
            default: {
                sb.append("-orientation=").append(this.mOrientation);
                this.mIsInvalid = true;
            }
        }
        switch (this.mUiMode & 0xF) {
            case 0: 
            case 1: {
                break;
            }
            case 2: {
                sb.append("-desk");
                break;
            }
            case 3: {
                sb.append("-car");
                break;
            }
            case 4: {
                sb.append("-television");
                break;
            }
            case 5: {
                sb.append("-appliance");
                break;
            }
            case 6: {
                sb.append("-watch");
                break;
            }
            case 7: {
                sb.append("-vrheadset");
                break;
            }
            case 11: {
                sb.append("-godzillaui");
                break;
            }
            case 12: {
                sb.append("-smallui");
                break;
            }
            case 13: {
                sb.append("-mediumui");
                break;
            }
            case 14: {
                sb.append("-largeui");
                break;
            }
            case 15: {
                sb.append("-hugeui");
                break;
            }
            default: {
                sb.append("-uiModeType=").append(this.mUiMode & 0xF);
                this.mIsInvalid = true;
            }
        }
        switch (this.mUiMode & 0x30) {
            case 0: {
                break;
            }
            case 16: {
                sb.append("-notnight");
                break;
            }
            case 32: {
                sb.append("-night");
                break;
            }
            default: {
                sb.append("-uiModeNight=").append(this.mUiMode & 0x30);
                this.mIsInvalid = true;
            }
        }
        switch (this.mDensity) {
            case 0: {
                break;
            }
            case 120: {
                sb.append("-ldpi");
                break;
            }
            case 160: {
                sb.append("-mdpi");
                break;
            }
            case 213: {
                sb.append("-tvdpi");
                break;
            }
            case 240: {
                sb.append("-hdpi");
                break;
            }
            case 320: {
                sb.append("-xhdpi");
                break;
            }
            case 480: {
                sb.append("-xxhdpi");
                break;
            }
            case 640: {
                sb.append("-xxxhdpi");
                break;
            }
            case 65534: {
                sb.append("-anydpi");
                break;
            }
            case 65535: {
                sb.append("-nodpi");
                break;
            }
            default: {
                sb.append('-').append(this.mDensity).append("dpi");
            }
        }
        switch (this.mTouchscreen) {
            case 0: {
                break;
            }
            case 1: {
                sb.append("-notouch");
                break;
            }
            case 2: {
                sb.append("-stylus");
                break;
            }
            case 3: {
                sb.append("-finger");
                break;
            }
            default: {
                sb.append("-touchscreen=").append(this.mTouchscreen);
                this.mIsInvalid = true;
            }
        }
        switch (this.mInputFlags & 3) {
            case 0: {
                break;
            }
            case 1: {
                sb.append("-keysexposed");
                break;
            }
            case 2: {
                sb.append("-keyshidden");
                break;
            }
            case 3: {
                sb.append("-keyssoft");
                break;
            }
            default: {
                sb.append("-keysHidden=").append(this.mInputFlags & 3);
                this.mIsInvalid = true;
            }
        }
        switch (this.mKeyboard) {
            case 0: {
                break;
            }
            case 1: {
                sb.append("-nokeys");
                break;
            }
            case 2: {
                sb.append("-qwerty");
                break;
            }
            case 3: {
                sb.append("-12key");
                break;
            }
            default: {
                sb.append("-keyboard=").append(this.mKeyboard);
                this.mIsInvalid = true;
            }
        }
        switch (this.mInputFlags & 0xC) {
            case 0: {
                break;
            }
            case 4: {
                sb.append("-navexposed");
                break;
            }
            case 8: {
                sb.append("-navhidden");
                break;
            }
            default: {
                sb.append("-navHidden=").append(this.mInputFlags & 0xC);
                this.mIsInvalid = true;
            }
        }
        switch (this.mNavigation) {
            case 0: {
                break;
            }
            case 1: {
                sb.append("-nonav");
                break;
            }
            case 2: {
                sb.append("-dpad");
                break;
            }
            case 3: {
                sb.append("-trackball");
                break;
            }
            case 4: {
                sb.append("-wheel");
                break;
            }
            default: {
                sb.append("-navigation=").append(this.mNavigation);
                this.mIsInvalid = true;
            }
        }
        if (this.mScreenWidth != 0 && this.mScreenHeight != 0) {
            sb.append('-').append(this.mScreenWidth).append('x').append(this.mScreenHeight);
        }
        if (this.mSdkVersion != 0 && this.mSdkVersion >= this.getNaturalSdkVersionRequirement()) {
            sb.append("-v").append(this.mSdkVersion);
        }
        return sb.toString();
    }

    private int getNaturalSdkVersionRequirement() {
        if ((this.mGrammaticalInflection & 3) != 0) {
            return 34;
        }
        if ((this.mUiMode & 0xF) == 7 || (this.mColorMode & 3) != 0 || (this.mColorMode & 0xC) != 0) {
            return 26;
        }
        if ((this.mScreenLayout2 & 3) != 0) {
            return 23;
        }
        if (this.mDensity == 65534) {
            return 21;
        }
        if (this.mSmallestScreenWidthDp != 0 || this.mScreenWidthDp != 0 || this.mScreenHeightDp != 0) {
            return 13;
        }
        if ((this.mUiMode & 0x3F) != 0) {
            return 8;
        }
        if ((this.mScreenLayout & 0x3F) != 0 || this.mDensity != 0) {
            return 4;
        }
        return 0;
    }

    public boolean isInvalid() {
        return this.mIsInvalid;
    }

    public String getQualifiers() {
        return this.mQualifiers;
    }

    public String toString() {
        return !this.mQualifiers.isEmpty() ? this.mQualifiers : "[DEFAULT]";
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ResConfigFlags) {
            ResConfigFlags other = (ResConfigFlags)obj;
            return this.mQualifiers.equals(other.mQualifiers);
        }
        return false;
    }

    public int hashCode() {
        return this.mQualifiers.hashCode();
    }
}

