/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.data.value;

import brut.androlib.exceptions.AndrolibException;
import brut.androlib.res.data.ResResource;
import brut.androlib.res.data.value.ResBagValue;
import brut.androlib.res.data.value.ResReferenceValue;
import brut.androlib.res.data.value.ResScalarValue;
import brut.androlib.res.xml.ResValuesXmlSerializable;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.xmlpull.v1.XmlSerializer;

public class ResArrayValue
extends ResBagValue
implements ResValuesXmlSerializable {
    private static final Set<String> ALLOWED_ARRAY_TYPES = Sets.newHashSet("string", "integer");
    private final ResScalarValue[] mItems;

    ResArrayValue(ResReferenceValue parent, Pair<Integer, ResScalarValue>[] items) {
        super(parent);
        this.mItems = new ResScalarValue[items.length];
        for (int i = 0; i < items.length; ++i) {
            this.mItems[i] = items[i].getRight();
        }
    }

    public ResArrayValue(ResReferenceValue parent, ResScalarValue[] items) {
        super(parent);
        this.mItems = items;
    }

    @Override
    public void serializeToResValuesXml(XmlSerializer serializer, ResResource res) throws AndrolibException, IOException {
        String type = this.getType();
        type = (type != null ? type + "-" : "") + "array";
        serializer.startTag(null, type);
        serializer.attribute(null, "name", res.getResSpec().getName());
        for (ResScalarValue item : this.mItems) {
            if (!item.hasMultipleNonPositionalSubstitutions()) continue;
            serializer.attribute(null, "formatted", "false");
            break;
        }
        for (ResScalarValue item : this.mItems) {
            serializer.startTag(null, "item");
            serializer.text(item.encodeAsResXmlNonEscapedItemValue());
            serializer.endTag(null, "item");
        }
        serializer.endTag(null, type);
    }

    public String getType() throws AndrolibException {
        if (this.mItems.length == 0) {
            return null;
        }
        String type = this.mItems[0].getType();
        for (ResScalarValue item : this.mItems) {
            if (item.encodeAsResXmlItemValue().startsWith("@string")) {
                return "string";
            }
            if (item.encodeAsResXmlItemValue().startsWith("@drawable")) {
                return null;
            }
            if (item.encodeAsResXmlItemValue().startsWith("@integer")) {
                return "integer";
            }
            if (!"string".equals(type) && !"integer".equals(type)) {
                return null;
            }
            if (type.equals(item.getType())) continue;
            return null;
        }
        if (!ALLOWED_ARRAY_TYPES.contains(type)) {
            return "string";
        }
        return type;
    }
}

