/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.dexlib2.analysis.reflection;

import com.android.tools.smali.dexlib2.analysis.reflection.ReflectionConstructor;
import com.android.tools.smali.dexlib2.analysis.reflection.ReflectionField;
import com.android.tools.smali.dexlib2.analysis.reflection.ReflectionMethod;
import com.android.tools.smali.dexlib2.analysis.reflection.util.ReflectionUtils;
import com.android.tools.smali.dexlib2.base.reference.BaseTypeReference;
import com.android.tools.smali.dexlib2.iface.Annotation;
import com.android.tools.smali.dexlib2.iface.ClassDef;
import com.android.tools.smali.dexlib2.iface.Method;
import com.android.tools.smali.util.AbstractIterator;
import com.android.tools.smali.util.ChainedIterable;
import com.android.tools.smali.util.IteratorUtils;
import com.android.tools.smali.util.TransformedIterable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ReflectionClassDef
extends BaseTypeReference
implements ClassDef {
    private final Class cls;
    private static final int DIRECT_MODIFIERS = 10;

    public ReflectionClassDef(Class cls) {
        this.cls = cls;
    }

    @Override
    public int getAccessFlags() {
        return this.cls.getModifiers();
    }

    @Override
    @Nullable
    public String getSuperclass() {
        if (Modifier.isInterface(this.cls.getModifiers())) {
            return "Ljava/lang/Object;";
        }
        Class superClass = this.cls.getSuperclass();
        if (superClass == null) {
            return null;
        }
        return ReflectionUtils.javaToDexName(superClass.getName());
    }

    @Override
    @Nonnull
    public List<String> getInterfaces() {
        return Arrays.asList(this.cls.getInterfaces()).stream().map(i -> i == null ? null : ReflectionUtils.javaToDexName(i.getName())).collect(Collectors.toList());
    }

    @Override
    @Nullable
    public String getSourceFile() {
        return null;
    }

    @Override
    @Nonnull
    public Set<? extends Annotation> getAnnotations() {
        return Collections.emptySet();
    }

    @Override
    @Nonnull
    public Iterable<? extends com.android.tools.smali.dexlib2.iface.Field> getStaticFields() {
        return new Iterable<com.android.tools.smali.dexlib2.iface.Field>(){

            @Override
            @Nonnull
            public Iterator<com.android.tools.smali.dexlib2.iface.Field> iterator() {
                AbstractIterator<Field> staticFields = IteratorUtils.filter(Arrays.asList(ReflectionClassDef.this.cls.getDeclaredFields()), new Predicate<Field>(){

                    @Override
                    public boolean test(@Nullable Field input) {
                        return input != null && Modifier.isStatic(input.getModifiers());
                    }
                });
                return new TransformedIterable.TransformedIterator<Field, com.android.tools.smali.dexlib2.iface.Field>((Iterator<Field>)staticFields, new Function<Field, com.android.tools.smali.dexlib2.iface.Field>(){

                    @Override
                    @Nullable
                    public com.android.tools.smali.dexlib2.iface.Field apply(@Nullable Field input) {
                        return new ReflectionField(input);
                    }
                });
            }
        };
    }

    @Override
    @Nonnull
    public Iterable<? extends com.android.tools.smali.dexlib2.iface.Field> getInstanceFields() {
        return new Iterable<com.android.tools.smali.dexlib2.iface.Field>(){

            @Override
            @Nonnull
            public Iterator<com.android.tools.smali.dexlib2.iface.Field> iterator() {
                AbstractIterator<Field> staticFields = IteratorUtils.filter(Arrays.asList(ReflectionClassDef.this.cls.getDeclaredFields()), new Predicate<Field>(){

                    @Override
                    public boolean test(@Nullable Field input) {
                        return input != null && !Modifier.isStatic(input.getModifiers());
                    }
                });
                return new TransformedIterable.TransformedIterator<Field, com.android.tools.smali.dexlib2.iface.Field>((Iterator<Field>)staticFields, new Function<Field, com.android.tools.smali.dexlib2.iface.Field>(){

                    @Override
                    @Nullable
                    public com.android.tools.smali.dexlib2.iface.Field apply(@Nullable Field input) {
                        return new ReflectionField(input);
                    }
                });
            }
        };
    }

    @Nonnull
    public Set<? extends com.android.tools.smali.dexlib2.iface.Field> getFields() {
        return new AbstractSet<com.android.tools.smali.dexlib2.iface.Field>(){

            @Override
            @Nonnull
            public Iterator<com.android.tools.smali.dexlib2.iface.Field> iterator() {
                return new TransformedIterable.TransformedIterator<Field, com.android.tools.smali.dexlib2.iface.Field>(Arrays.asList(ReflectionClassDef.this.cls.getDeclaredFields()), new Function<Field, com.android.tools.smali.dexlib2.iface.Field>(){

                    @Override
                    @Nullable
                    public com.android.tools.smali.dexlib2.iface.Field apply(@Nullable Field input) {
                        return new ReflectionField(input);
                    }
                });
            }

            @Override
            public int size() {
                return ReflectionClassDef.this.cls.getDeclaredFields().length;
            }
        };
    }

    @Override
    @Nonnull
    public Iterable<? extends Method> getDirectMethods() {
        return new Iterable<Method>(){

            @Override
            @Nonnull
            public Iterator<Method> iterator() {
                TransformedIterable.TransformedIterator<Constructor, Method> constructorIterator = new TransformedIterable.TransformedIterator<Constructor, Method>(Arrays.asList(ReflectionClassDef.this.cls.getDeclaredConstructors()).iterator(), new Function<Constructor, Method>(){

                    @Override
                    @Nullable
                    public Method apply(@Nullable Constructor input) {
                        return new ReflectionConstructor(input);
                    }
                });
                AbstractIterator<java.lang.reflect.Method> directMethods = IteratorUtils.filter(Arrays.asList(ReflectionClassDef.this.cls.getDeclaredMethods()), new Predicate<java.lang.reflect.Method>(){

                    @Override
                    public boolean test(@Nullable java.lang.reflect.Method input) {
                        return input != null && (input.getModifiers() & 0xA) != 0;
                    }
                });
                TransformedIterable.TransformedIterator<java.lang.reflect.Method, Method> methodIterator = new TransformedIterable.TransformedIterator<java.lang.reflect.Method, Method>((Iterator<java.lang.reflect.Method>)directMethods, new Function<java.lang.reflect.Method, Method>(){

                    @Override
                    @Nullable
                    public Method apply(@Nullable java.lang.reflect.Method input) {
                        return new ReflectionMethod(input);
                    }
                });
                return new ChainedIterable.ChainedIterator<Method>(constructorIterator, methodIterator);
            }
        };
    }

    @Override
    @Nonnull
    public Iterable<? extends Method> getVirtualMethods() {
        return new Iterable<Method>(){

            @Override
            @Nonnull
            public Iterator<Method> iterator() {
                AbstractIterator<java.lang.reflect.Method> directMethods = IteratorUtils.filter(Arrays.asList(ReflectionClassDef.this.cls.getDeclaredMethods()), new Predicate<java.lang.reflect.Method>(){

                    @Override
                    public boolean test(@Nullable java.lang.reflect.Method input) {
                        return input != null && (input.getModifiers() & 0xA) == 0;
                    }
                });
                return new TransformedIterable.TransformedIterator<java.lang.reflect.Method, Method>((Iterator<java.lang.reflect.Method>)directMethods, new Function<java.lang.reflect.Method, Method>(){

                    @Override
                    @Nullable
                    public Method apply(@Nullable java.lang.reflect.Method input) {
                        return new ReflectionMethod(input);
                    }
                });
            }
        };
    }

    @Nonnull
    public Set<? extends Method> getMethods() {
        return new AbstractSet<Method>(){

            @Override
            @Nonnull
            public Iterator<Method> iterator() {
                TransformedIterable.TransformedIterator<Constructor, Method> constructorIterator = new TransformedIterable.TransformedIterator<Constructor, Method>(Arrays.asList(ReflectionClassDef.this.cls.getDeclaredConstructors()), new Function<Constructor, Method>(){

                    @Override
                    @Nullable
                    public Method apply(@Nullable Constructor input) {
                        return new ReflectionConstructor(input);
                    }
                });
                TransformedIterable.TransformedIterator<java.lang.reflect.Method, Method> methodIterator = new TransformedIterable.TransformedIterator<java.lang.reflect.Method, Method>(Arrays.asList(ReflectionClassDef.this.cls.getDeclaredMethods()), new Function<java.lang.reflect.Method, Method>(){

                    @Override
                    @Nullable
                    public Method apply(@Nullable java.lang.reflect.Method input) {
                        return new ReflectionMethod(input);
                    }
                });
                return new ChainedIterable.ChainedIterator<Method>(constructorIterator, methodIterator);
            }

            @Override
            public int size() {
                return ReflectionClassDef.this.cls.getDeclaredMethods().length + ReflectionClassDef.this.cls.getDeclaredConstructors().length;
            }
        };
    }

    @Override
    @Nonnull
    public String getType() {
        return ReflectionUtils.javaToDexName(this.cls.getName());
    }
}

