/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;

public abstract class AbstractIterator<T>
implements Iterator<T>,
Iterable<T> {
    private static final int STATE_READY = 1;
    private static final int STATE_NOT_READY = 2;
    private static final int STATE_DONE = 3;
    private static final int STATE_FAILED = 4;
    private int state = 2;
    private T next;

    protected final T endOfData() {
        this.state = 3;
        return null;
    }

    @Override
    public final boolean hasNext() {
        switch (this.state) {
            case 3: {
                return false;
            }
            case 1: {
                return true;
            }
            case 4: {
                throw new IllegalStateException();
            }
        }
        return this.tryToComputeNext();
    }

    private boolean tryToComputeNext() {
        this.state = 4;
        this.next = this.computeNext();
        if (this.state != 3) {
            this.state = 1;
            return true;
        }
        return false;
    }

    @Override
    public final T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.state = 2;
        T result = this.next;
        this.next = null;
        return result;
    }

    @Override
    public final Iterator<T> iterator() {
        return this;
    }

    @Nullable
    protected abstract T computeNext();
}

