#! /opt/local/bin/perl
#
# Copyright (C) 2013-2022 Alexis Bienvenüe <paamc@passoire.fr>
#
# This file is part of Auto-Multiple-Choice
#
# Auto-Multiple-Choice is free software: you can redistribute it
# and/or modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation, either version 2 of
# the License, or (at your option) any later version.
#
# Auto-Multiple-Choice is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied warranty
# of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Auto-Multiple-Choice.  If not, see
# <http://www.gnu.org/licenses/>.

use warnings;
use 5.012;

use Getopt::Long;

use AMC::Basic;
use AMC::Annotate;
use AMC::Exec;

my $single_output  = '';
my $sort           = '';
my $filename_model = '(N)-(ID)';
my $force_ascii    = 0;

my $pdf_subject   = '';
my $pdf_corrected = '';
my $pdf_dir       = '';
my $cr_dir        = "";
my $project_dir   = '';
my $projects_dir  = '';

my $id_file = '';

my $darkness_threshold    = '';
my $darkness_threshold_up = '';

my $data_dir = '';

my $progress    = 1;
my $progress_id = '';

my $text_color             = 'red';
my $line_width             = 2;
my $font_name              = 'Linux Libertine O 12';
my @o_symbols              = ();
my $annotate_indicatives   = '';
my $position               = 'marges';
my $dist_to_box            = '1cm';
my $dist_margin            = '5mm';
my $dist_margin_globaltext = '3mm';

my $significant_digits = 4;

my $verdict                    = 'TOTAL : %S/%M => %s/%m';
my $verdict_allpages           = '';
my $verdict_question_cancelled = '"X"';
my $verdict_question           = "\"%" . "s/%" . "m\"";

my $rtl = '';

my $names_file      = '';
my $names_encoding  = 'utf-8';
my $association_key = '';
my $csv_build_name  = '';
my $anonymous       = '';
my $header_only     = '';
my $add_corrected   = '';

my $embedded_max_size     = "";
my $embedded_jpeg_quality = 80;
my $embedded_format       = "jpeg";

my $changes_only = '';

my $compose         = '';
my $latex_engine    = 'pdflatex';
my $src_file        = '';
my $filter          = '';
my $filtered_source = '';
my $n_copies        = 0;

# key is "to be ticked"-"ticked"
my %symboles = (
    '0-0' => {qw/type none/},
    '0-1' => {qw/type circle color red/},
    '1-0' => {qw/type mark color red/},
    '1-1' => {qw/type mark color blue/},
);

GetProjectOptions(
    ":cr:dir|cr=s"                             => \$cr_dir,
    ":project_dir|project=s"                   => \$project_dir,
    ":projects_dir|projects-dir=s"             => \$projects_dir,
    ":data:dir|data=s"                         => \$data_dir,
    ":doc_question:file|subject=s"             => \$pdf_subject,
    "pdf-dir=s"                                => \$pdf_dir,
    "darkness-threshold=s"                     => \$darkness_threshold,
    "darkness-threshold-up=s"                  => \$darkness_threshold_up,
    ":modele_regroupement|filename-model=s"    => \$filename_model,
    ":ascii_filenames:bool|force-ascii!"       => \$force_ascii,
    "single-output=s"                          => \$single_output,
    ":export_sort|sort=s"                      => \$sort,
    "id-file=s"                                => \$id_file,
    "progression=s"                            => \$progress,
    "progression-id=s"                         => \$progress_id,
    ":symboles_trait|line-width=s"             => \$line_width,
    ":annote_font_name|font-name=s"            => \$font_name,
    ":annote_color|text-color=s"               => \$text_color,
    ":symbols|symbols=s"                       => \@o_symbols,
    ":symboles_indicatives:bool|indicatives!"  => \$annotate_indicatives,
    ":annote_position|position=s"              => \$position,
    ":annote_ecart|dist-to-box=s"              => \$dist_to_box,
    "dist-margin=s"                            => \$dist_margin,
    "dist-margin-global=s"                     => \$dist_margin_globaltext,
    ":annote_chsign|n-digits=s"                => \$significant_digits,
    ":verdict|verdict=s"                       => \$verdict,
    "verdict-allpages!"                        => \$verdict_allpages,
    ":verdict_q|verdict-question=s"            => \$verdict_question,
    ":verdict_qc|verdict-question-cancelled=s" => \$verdict_question_cancelled,
    ":listeetudiants:file|names-file=s"        => \$names_file,
    ":liste:enc|names-encoding=s"              => \$names_encoding,
    "association-key=s"                        => \$association_key,
    ":csv_build_name|csv-build-name=s"         => \$csv_build_name,
    "anonymous=s"                              => \$anonymous,
    "header-only!"                             => \$header_only,
    ":annote_rtl:bool|rtl!"                    => \$rtl,
    "changes-only!"                            => \$changes_only,
    ":export_sort|sort=s"                      => \$sort,
    ":regroupement_compose:bool|compose!"      => \$compose,
    ":doc_indiv_solution:file|corrected=s"     => \$pdf_corrected,
    "n-copies=s"                               => \$n_copies,
    ":texsrc:file|src=s"                       => \$src_file,
    ":moteur_latex|with=s"                     => \$latex_engine,
    ":filter|filter=s"                         => \$filter,
    ":filtered_source:file|filtered-source=s"  => \$filtered_source,
    ":embedded_max_size|embedded-max-size=s"   => \$embedded_max_size,
    ":embedded_format|embedded-format=s"       => \$embedded_format,
    ":embedded_jpeg_quality|embedded-jpeg-quality=s" => \$embedded_jpeg_quality,
    ":add_corrected:bool|add-corrected!"             => \$add_corrected,
);

for ( split( /,/, join( ',', @o_symbols ) ) ) {
    if (/^([01]-[01]):(none|circle|mark|box)(?:[\/:]([\#a-z0-9]+))?$/) {
        $symboles{$1} = { type => $2, color => $3 };
    } else {
        die "Bad symbol syntax: $_";
    }
}

# try to set sensible values when these directories are not set by the
# user:

$projects_dir = $ENV{HOME} . '/' . __("MC-Projects") if ( !$projects_dir );
$project_dir   = $projects_dir . '/' . $project_dir if ( $project_dir !~ /\// );
$pdf_subject   = "DOC-sujet.pdf"                    if ( !$pdf_subject );
$pdf_subject   = $project_dir . '/' . $pdf_subject  if ( $pdf_subject !~ /\// );
$pdf_corrected = "DOC-indiv-solution.pdf"           if ( !$pdf_corrected );
$pdf_corrected = $project_dir . '/' . $pdf_corrected
  if ( $pdf_corrected !~ /\// );

$cr_dir   = $project_dir . "/cr"         if ( !$cr_dir );
$data_dir = $project_dir . "/data"       if ( !$data_dir );
$pdf_dir  = $cr_dir . "/corrections/pdf" if ( !$pdf_dir );

# single output should be a file name, not a path

$single_output =~ s:.*/::;

# We need a destination directory!

if ( !-d $pdf_dir ) {
    attention("No PDF directory: $pdf_dir");
    die "No PDF directory: $pdf_dir";
}

my $commandes = AMC::Exec::new('AMC-annotate');
$commandes->signalise();

# prepare the corrected answer sheet for all students. This file is
# used when option --add-corrected is used, to append the corrected
# answer sheet at the end.

if ( $add_corrected ) {
    if ( !-f $pdf_corrected ) {

        debug "Building individual corrected sheet...";
        print "Building individual corrected sheet...\n";

        $commandes->execute(
            "auto-multiple-choice",
            "prepare",
            pack_args(
                "--n-copies",          $n_copies,
                "--with",              $latex_engine,
                "--filter",            $filter,
                "--filtered-source",   $filtered_source,
                "--mode",              "k",
                "--out-corrige-indiv", $pdf_corrected,
                "--debug",             debug_file(),
                $src_file
            )
        );
    }
}

my $annotate = AMC::Annotate::new(
    data_dir                   => $data_dir,
    project_dir                => $project_dir,
    projects_dir               => $projects_dir,
    pdf_dir                    => $pdf_dir,
    single_output              => $single_output,
    filename_model             => $filename_model,
    force_ascii                => $force_ascii,
    pdf_subject                => $pdf_subject,
    names_file                 => $names_file,
    names_encoding             => $names_encoding,
    association_key            => $association_key,
    csv_build_name             => $csv_build_name,
    anonymous                  => $anonymous,
    significant_digits         => $significant_digits,
    darkness_threshold         => $darkness_threshold,
    darkness_threshold_up      => $darkness_threshold_up,
    id_file                    => $id_file,
    sort                       => $sort,
    annotate_indicatives       => $annotate_indicatives,
    header_only                => $header_only,
    position                   => $position,
    text_color                 => $text_color,
    line_width                 => $line_width,
    font_name                  => $font_name,
    dist_to_box                => $dist_to_box,
    dist_margin                => $dist_margin,
    dist_margin_globaltext     => $dist_margin_globaltext,
    symbols                    => \%symboles,
    verdict                    => $verdict,
    verdict_allpages           => $verdict_allpages,
    verdict_question           => $verdict_question,
    verdict_question_cancelled => $verdict_question_cancelled,
    progress                   => $progress,
    progress_id                => $progress_id,
    compose                    => $compose,
    pdf_corrected              => $pdf_corrected,
    changes_only               => $changes_only,
    embedded_max_size          => $embedded_max_size,
    embedded_format            => $embedded_format,
    embedded_jpeg_quality      => $embedded_jpeg_quality,
    rtl                        => $rtl,
    add_corrected              => $add_corrected,
);

$annotate->go();
$annotate->quit();

