/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.CompileContext;
import org.basex.query.InlineContext;
import org.basex.query.QueryException;
import org.basex.query.QueryFunction;
import org.basex.query.QueryString;
import org.basex.query.expr.Arith;
import org.basex.query.expr.CachedMap;
import org.basex.query.expr.Calc;
import org.basex.query.expr.Cast;
import org.basex.query.expr.ContextValue;
import org.basex.query.expr.DualIterMap;
import org.basex.query.expr.DualMap;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Filter;
import org.basex.query.expr.If;
import org.basex.query.expr.IterMap;
import org.basex.query.expr.List;
import org.basex.query.expr.Mapping;
import org.basex.query.expr.Pipeline;
import org.basex.query.expr.Preds;
import org.basex.query.expr.Range;
import org.basex.query.expr.path.Axis;
import org.basex.query.expr.path.AxisPath;
import org.basex.query.expr.path.NodeTest;
import org.basex.query.expr.path.Path;
import org.basex.query.expr.path.SingleIterPath;
import org.basex.query.expr.path.Step;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.func.fn.ContextFn;
import org.basex.query.func.fn.FnData;
import org.basex.query.func.fn.FnError;
import org.basex.query.func.fn.FnReplicate;
import org.basex.query.util.Flag;
import org.basex.query.util.list.ExprList;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Itr;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.RangeSeq;
import org.basex.query.value.seq.SingletonSeq;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Types;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjectMap;

public abstract class SimpleMap
extends Mapping {
    SimpleMap(InputInfo info, Expr ... exprs) {
        super(info, Types.ITEM_ZM, exprs);
    }

    @Override
    final boolean items() {
        return true;
    }

    public static Expr get(CompileContext cc, InputInfo info, Expr ... exprs) throws QueryException {
        int el = exprs.length;
        return el > 1 ? new CachedMap(info, exprs).optimize(cc) : (el > 0 ? exprs[0] : Empty.VALUE);
    }

    @Override
    public final Expr optimize(CompileContext cc) throws QueryException {
        boolean dual;
        Expr ex = this.flattenMaps(cc);
        if (ex == null) {
            ex = this.mergePaths(cc);
        }
        if (ex == null) {
            ex = this.dropOps(cc);
        }
        if (ex != null) {
            return ex;
        }
        Expr[] merged = this.merge(cc);
        if (merged != null) {
            return merged.length == 1 ? merged[0] : SimpleMap.get(cc, this.info, merged);
        }
        boolean value = true;
        boolean cached = false;
        boolean dualiter = dual = this.exprs.length == 2;
        int el = this.exprs.length;
        for (int e = 0; e < el; ++e) {
            Expr expr = this.exprs[e];
            SeqType st = expr.seqType();
            value = value && (st.one() || e == el - 1);
            cached = cached || e > 0 && expr.has(Flag.POS);
            dual = dual && (st.zeroOrOne() || e == 0);
        }
        return this.copyType(value ? new Pipeline(this.info, this.exprs) : (cached ? new CachedMap(this.info, this.exprs) : (dual ? new DualMap(this.info, this.exprs) : (dualiter ? new DualIterMap(this.info, this.exprs) : new IterMap(this.info, this.exprs)))));
    }

    public Expr remove(CompileContext cc, int e) throws QueryException {
        ExprList list = new ExprList(this.exprs);
        list.remove(e);
        return SimpleMap.get(cc, this.info, (Expr[])list.finish());
    }

    private Expr flattenMaps(CompileContext cc) throws QueryException {
        ExprList list = new ExprList();
        for (Expr expr : this.exprs) {
            if (expr instanceof SimpleMap && !(expr instanceof CachedMap)) {
                list.add(expr.args());
                cc.info("flatten nested %: %", expr, this::description);
                continue;
            }
            list.add(expr);
        }
        return list.size() != this.exprs.length ? SimpleMap.get(cc, this.info, (Expr[])list.finish()) : null;
    }

    @Override
    Expr merge(Expr expr, Expr next, CompileContext cc) throws QueryException {
        long size = expr.size();
        if (!expr.has(Flag.NDT) && !next.has(Flag.POS)) {
            Expr inlined;
            SingletonSeq ss;
            if (!next.has(Flag.CTX)) {
                Expr count = null;
                if (size != -1L) {
                    count = Itr.get(size);
                } else if (expr instanceof Range && expr.arg(0) == Itr.ONE && expr.arg(1).seqType().instanceOf(Types.INTEGER_O)) {
                    count = expr.arg(1);
                }
                if (count != null) {
                    return cc.replicate(next, count, this.info);
                }
            }
            if (next instanceof StandardFunc && !next.has(Flag.NDT)) {
                Expr[] args = next.args();
                if (Function.REPLICATE.is(next) && ((FnReplicate)next).singleEval(true) && args[0] instanceof ContextValue && !args[1].has(Flag.CTX)) {
                    if (Function.REPLICATE.is(expr) && ((FnReplicate)expr).singleEval(true)) {
                        Expr cnt = new Arith(this.info, expr.arg(1), args[1], Calc.MULTIPLY).optimize(cc);
                        return cc.function(Function.REPLICATE, this.info, expr.arg(0), cnt);
                    }
                    if (expr instanceof SingletonSeq && (ss = (SingletonSeq)expr).singleItem()) {
                        return cc.function(Function.REPLICATE, this.info, expr, args[1]);
                    }
                } else if (Function.ITEMS_AT.is(next) && !args[0].has(Flag.CTX) && args[1] instanceof ContextValue) {
                    if (expr instanceof RangeSeq) {
                        RangeSeq rs = (RangeSeq)expr;
                        Expr func = cc.function(Function._UTIL_RANGE, this.info, args[0], Itr.get(rs.min()), Itr.get(rs.max()));
                        return rs.ascending() ? func : cc.function(Function.REVERSE, this.info, func);
                    }
                    if (expr instanceof Range) {
                        return cc.function(Function._UTIL_RANGE, this.info, args[0], expr.arg(0), expr.arg(1));
                    }
                    if (expr.seqType().instanceOf(Types.INTEGER_ZM)) {
                        return cc.function(Function.ITEMS_AT, this.info, args[0], expr);
                    }
                } else {
                    if (Function.DATA.is(next) && (((FnData)next).contextAccess() || args[0] instanceof ContextValue)) {
                        return cc.function(Function.DATA, this.info, expr);
                    }
                    if (Function.STRING_TO_CODEPOINTS.is(expr) && Function.CODEPOINTS_TO_STRING.is(next) && args[0] instanceof ContextValue) {
                        return cc.function(Function.CHARACTERS, this.info, expr.args());
                    }
                }
            }
            if (expr instanceof RangeSeq) {
                RangeSeq rs = (RangeSeq)expr;
                if (next instanceof Arith) {
                    Expr expr2;
                    boolean minus;
                    Arith arith = (Arith)next;
                    boolean plus = arith.calc == Calc.ADD;
                    boolean bl = minus = arith.calc == Calc.SUBTRACT;
                    if ((plus || minus) && arith.arg(0) instanceof ContextValue && (expr2 = arith.arg(1)) instanceof Itr) {
                        Itr itr = (Itr)expr2;
                        long diff = itr.itr();
                        long start = rs.itemAt(0L).itr() + (plus ? diff : -diff);
                        return RangeSeq.get(start, rs.size(), rs.ascending());
                    }
                }
            }
            Expr input = expr;
            if (Function.REPLICATE.is(expr) && ((FnReplicate)expr).singleEval(true)) {
                input = expr.arg(0);
            } else if (expr instanceof SingletonSeq && (ss = (SingletonSeq)expr).singleItem()) {
                input = ss.itemAt(0L);
            }
            if (input.size() == 1L && (inlined = SimpleMap.inline(input, next, cc)) != null) {
                return expr == input ? inlined : cc.replicate(inlined, Itr.get(size), this.info);
            }
            ExprList unroll = cc.unroll(expr, false);
            if (unroll != null) {
                ExprList results = new ExprList(unroll.size());
                for (Expr ex : unroll) {
                    Expr nxt = (long)results.size() == size - 1L ? next : next.copy(cc, new IntObjectMap<Var>());
                    results.add(SimpleMap.get(cc, this.info, ex, nxt));
                }
                return List.get(cc, this.info, (Expr[])results.finish());
            }
        }
        if (expr.seqType().zeroOrOne()) {
            boolean inline = false;
            if (next instanceof Cast) {
                Cast cast = (Cast)next;
                inline = cast.expr instanceof ContextValue && cast.seqType.occ == Occ.ZERO_OR_ONE;
            } else if (next instanceof ContextFn) {
                ContextFn ctxFn = (ContextFn)next;
                inline = ctxFn.inlineable();
            }
            if (inline) {
                try {
                    return new InlineContext(null, expr, cc).inline(next);
                }
                catch (QueryException ex) {
                    return FnError.get(ex, next);
                }
            }
        }
        Preds preds = null;
        if (next instanceof Filter) {
            Filter filter = (Filter)next;
            if (filter.root instanceof ContextValue) {
                preds = filter;
            }
        } else if (next instanceof SingleIterPath) {
            SingleIterPath path = (SingleIterPath)next;
            Step step = path.step(0);
            if (step.axis == Axis.SELF && step.test == NodeTest.NODE) {
                preds = step;
            }
        }
        if (preds != null && !preds.mayBePositional()) {
            return Filter.get(cc, this.info, expr, preds.exprs);
        }
        if (next instanceof If) {
            If iff = (If)next;
            if (iff.exprs[1] == Empty.VALUE && !iff.exprs[0].has(Flag.POS) && !iff.cond.seqType().mayBeNumber()) {
                return SimpleMap.get(cc, this.info, Filter.get(cc, this.info, expr, iff.cond), iff.exprs[0]);
            }
        }
        return null;
    }

    private Expr mergePaths(CompileContext cc) throws QueryException {
        Expr expr;
        if (!this.exprs[0].ddo()) {
            return null;
        }
        Expr root = this.exprs[0];
        ExprList steps = (ExprList)new ExprList().add(new Expr[0]);
        if (root instanceof AxisPath) {
            AxisPath path = (AxisPath)root;
            root = path.root;
            steps.add(path.steps);
        }
        int el = this.exprs.length;
        int e = 0;
        while (++e < el && (expr = this.exprs[e]) instanceof AxisPath) {
            AxisPath path2 = (AxisPath)expr;
            if (path2.root != null || !path2.simple()) break;
            steps.add(path2.steps);
        }
        if (e == 1) {
            return null;
        }
        Expr path = Path.get(cc, this.info, root, (Expr[])steps.finish());
        if (e == el) {
            return path;
        }
        ExprList list = (ExprList)((Object)new ExprList(el - e + 1).add(path));
        while (e < el) {
            list.add(this.exprs[e]);
            ++e;
        }
        return SimpleMap.get(cc, this.info, (Expr[])list.finish());
    }

    private Expr dropOps(CompileContext cc) throws QueryException {
        int ls;
        ExprList list = new ExprList(this.exprs.length);
        long min = 1L;
        long max = 1L;
        for (Expr expr : this.exprs) {
            if (max == 0L) break;
            list.add(expr);
            long es = expr.size();
            if (es == 0L) {
                min = 0L;
                max = 0L;
                continue;
            }
            if (es > 0L) {
                min *= es;
                if (max == -1L) continue;
                max *= es;
                continue;
            }
            Occ o = expr.seqType().occ;
            if (o.min == 0L) {
                min = 0L;
            }
            if (o.max <= 1L) continue;
            max = -1L;
        }
        if ((ls = list.size()) != this.exprs.length) {
            cc.info("simplify %: %", this::description, this);
            return SimpleMap.get(cc, this.info, (Expr[])list.finish());
        }
        this.exprType.assign(this.exprs[ls - 1], new long[]{min, max});
        return this.size() == 0L && !this.has(Flag.NDT, Flag.HOF) ? cc.emptySeq(this) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Expr toPath(CompileContext.Simplify mode, CompileContext cc) throws QueryException {
        ExprList steps = new ExprList();
        int el = this.exprs.length;
        QueryFunction<Integer, Expr> simplify = e -> {
            Expr expr = this.exprs[e];
            return mode == CompileContext.Simplify.DISTINCT || e + 1 == el ? expr.simplifyFor(mode, cc) : expr;
        };
        Expr root = simplify.apply(0);
        cc.pushFocus(root, true);
        if (root instanceof AxisPath) {
            AxisPath path = (AxisPath)root;
            root = path.root;
            steps.add(path.steps);
        }
        try {
            for (int e2 = 1; e2 < el; ++e2) {
                Expr expr = simplify.apply(e2);
                if (!(expr instanceof AxisPath)) {
                    SimpleMap simpleMap = this;
                    return simpleMap;
                }
                AxisPath path = (AxisPath)expr;
                if (path.root != null) {
                    SimpleMap simpleMap = this;
                    return simpleMap;
                }
                steps.add(path.steps);
                cc.updateFocus(expr, true);
            }
        }
        finally {
            cc.removeFocus();
        }
        return Path.get(cc, this.info, root, (Expr[])steps.finish());
    }

    @Override
    public final Expr simplifyFor(CompileContext.Simplify mode, CompileContext cc) throws QueryException {
        Expr lst;
        Expr expr = this;
        int el = this.exprs.length;
        Expr last = this.exprs[el - 1];
        Expr prev = this.exprs[el - 2];
        if (mode.oneOf(CompileContext.Simplify.DATA, CompileContext.Simplify.NUMBER, CompileContext.Simplify.STRING, CompileContext.Simplify.COUNT, CompileContext.Simplify.DISTINCT) && (lst = cc.get(prev, true, () -> last.simplifyFor(mode, cc))) != last) {
            expr = SimpleMap.get(cc, this.info, (Expr[])((ExprList)((ExprList)new ExprList(el).add(this.exprs)).set(el - 1, lst)).finish());
        }
        if (expr == this && mode.oneOf(CompileContext.Simplify.EBV, CompileContext.Simplify.PREDICATE)) {
            expr = this.seqType().zeroOrOne() && prev.seqType().type instanceof NodeType && last instanceof Bln ? (last == Bln.FALSE ? Bln.FALSE : this.remove(cc, el - 1)) : this.toPath(mode, cc);
        }
        return cc.simplify(this, expr, mode);
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof SimpleMap && super.equals(obj);
    }

    @Override
    public String description() {
        return "simple map";
    }

    @Override
    public void toString(QueryString qs) {
        qs.tokens(this.exprs, " ! ");
    }
}

