/*
 * Decompiled with CFR 0.152.
 */
package de.bottlecaps.markup.blitz.grammar;

import de.bottlecaps.markup.blitz.grammar.Alt;
import de.bottlecaps.markup.blitz.grammar.Alts;
import de.bottlecaps.markup.blitz.grammar.Mark;
import de.bottlecaps.markup.blitz.grammar.Node;
import de.bottlecaps.markup.blitz.transform.Visitor;
import java.util.stream.Collectors;

public class Rule
extends Node {
    private final Mark mark;
    private final String alias;
    private final String name;
    private final Alts alts;

    public Rule(Mark mark, String alias, String name, Alts alts) {
        this.mark = mark;
        this.alias = alias;
        this.name = name;
        this.alts = alts;
    }

    public Mark getMark() {
        return this.mark;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getName() {
        return this.name;
    }

    public Alts getAlts() {
        return this.alts;
    }

    @Override
    public void accept(Visitor v) {
        v.visit(this);
    }

    public Rule copy() {
        return new Rule(this.mark, this.alias, this.name, this.alts.copy());
    }

    public String toString() {
        String padding2 = "               ";
        String prefix = String.valueOf((Object)this.mark) + this.name + (String)(this.alias != null ? ">" + this.alias : "") + ": ";
        int padding1Length = padding2.length() - prefix.length();
        String padding1 = padding2.substring(0, Math.max(0, padding1Length));
        if (padding1Length < 0) {
            prefix = prefix.stripTrailing() + "\n" + padding2;
        }
        return this.alts.getAlts().stream().map(Alt::toString).collect(Collectors.joining(";\n" + padding2, padding1 + prefix, "."));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.alias == null ? 0 : this.alias.hashCode());
        result = 31 * result + (this.alts == null ? 0 : this.alts.hashCode());
        result = 31 * result + (this.mark == null ? 0 : this.mark.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Rule)) {
            return false;
        }
        Rule other = (Rule)obj;
        if (this.alias == null ? other.alias != null : !this.alias.equals(other.alias)) {
            return false;
        }
        if (this.alts == null ? other.alts != null : !this.alts.equals(other.alts)) {
            return false;
        }
        if (this.mark != other.mark) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

