/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import org.eclipse.jgit.lib.BatchingProgressMonitor;

public class TextProgressMonitor
extends BatchingProgressMonitor {
    private final Writer out;
    private boolean write;

    public TextProgressMonitor() {
        this(new PrintWriter(new OutputStreamWriter((OutputStream)System.err, StandardCharsets.UTF_8)));
    }

    public TextProgressMonitor(Writer out) {
        this.out = out;
        this.write = true;
    }

    @Override
    protected void onUpdate(String taskName, int workCurr, Duration duration) {
        StringBuilder s2 = new StringBuilder();
        this.format(s2, taskName, workCurr, duration);
        this.send(s2);
    }

    @Override
    protected void onEndTask(String taskName, int workCurr, Duration duration) {
        StringBuilder s2 = new StringBuilder();
        this.format(s2, taskName, workCurr, duration);
        s2.append("\n");
        this.send(s2);
    }

    private void format(StringBuilder s2, String taskName, int workCurr, Duration duration) {
        s2.append("\r");
        s2.append(taskName);
        s2.append(": ");
        while (s2.length() < 25) {
            s2.append(' ');
        }
        s2.append(workCurr);
        this.appendDuration(s2, duration);
    }

    @Override
    protected void onUpdate(String taskName, int cmp, int totalWork, int pcnt, Duration duration) {
        StringBuilder s2 = new StringBuilder();
        this.format(s2, taskName, cmp, totalWork, pcnt, duration);
        this.send(s2);
    }

    @Override
    protected void onEndTask(String taskName, int cmp, int totalWork, int pcnt, Duration duration) {
        StringBuilder s2 = new StringBuilder();
        this.format(s2, taskName, cmp, totalWork, pcnt, duration);
        s2.append("\n");
        this.send(s2);
    }

    private void format(StringBuilder s2, String taskName, int cmp, int totalWork, int pcnt, Duration duration) {
        s2.append("\r");
        s2.append(taskName);
        s2.append(": ");
        while (s2.length() < 25) {
            s2.append(' ');
        }
        String endStr = String.valueOf(totalWork);
        Object curStr = String.valueOf(cmp);
        while (((String)curStr).length() < endStr.length()) {
            curStr = " " + (String)curStr;
        }
        if (pcnt < 100) {
            s2.append(' ');
        }
        if (pcnt < 10) {
            s2.append(' ');
        }
        s2.append(pcnt);
        s2.append("% (");
        s2.append((String)curStr);
        s2.append('/');
        s2.append(endStr);
        s2.append(')');
        this.appendDuration(s2, duration);
    }

    private void send(StringBuilder s2) {
        if (this.write) {
            try {
                this.out.write(s2.toString());
                this.out.flush();
            }
            catch (IOException err) {
                this.write = false;
            }
        }
    }
}

