# Chemkit library cmake configuration file
#
# the following variables are defined:
#   CHEMKIT_INCLUDE_DIRS - list of chemkit include directories
#   CHEMKIT_LIBRARIES  - list of enabled chemkit libraries

# get file paths
if(${CHEMKIT_IN_BUILD_TREE})
  # in build tree
  include("${Chemkit_BINARY_DIR}/ChemkitBuildTreeSettings.cmake")
else()
  # directory where the chemkit header files are installed
  set(CHEMKIT_INCLUDE_DIRS /opt/local/include)
endif()

# add dependencies include directories
set(CHEMKIT_INCLUDE_DIRS ${CHEMKIT_INCLUDE_DIRS} /opt/local/include/eigen3 /opt/local/libexec/boost/1.71/include)

# set CHEMKIT_USE_*_LIBRARY for each enabled component
foreach(COMPONENT ${Chemkit_FIND_COMPONENTS})
  string(TOUPPER ${COMPONENT} COMPONENT)
  set(CHEMKIT_USE_${COMPONENT}_LIBRARY TRUE)
endforeach()

# directory where the chemkit libraries are installed
set(CHEMKIT_LIBRARY_DIR /opt/local/lib)

# set CHEMKIT_LIBRARY variables
set(CHEMKIT_LIBRARY chemkit)
set(CHEMKIT_IO_LIBRARY chemkit-io)
set(CHEMKIT_MD_LIBRARY chemkit-md)
set(CHEMKIT_MD_IO_LIBRARY chemkit-md-io)
set(CHEMKIT_WEB_LIBRARY chemkit-web)
set(CHEMKIT_GRAPHICS_LIBRARY chemkit-graphics)
set(CHEMKIT_GUI_LIBRARY chemkit-gui)

# set the CHEMKIT_LIBRARIES variable
set(CHEMKIT_LIBRARIES ${CHEMKIT_LIBRARY})

if(${CHEMKIT_USE_IO_LIBRARY})
  set(CHEMKIT_LIBRARIES ${CHEMKIT_LIBRARIES} ${CHEMKIT_IO_LIBRARY})
endif()

if(${CHEMKIT_USE_MD_LIBRARY})
  set(CHEMKIT_LIBRARIES ${CHEMKIT_LIBRARIES} ${CHEMKIT_MD_LIBRARY})
endif()

if(${CHEMKIT_USE_MD-IO_LIBRARY})
  set(CHEMKIT_LIBRARIES ${CHEMKIT_LIBRARIES} ${CHEMKIT_MD_IO_LIBRARY})
endif()

if(${CHEMKIT_USE_WEB_LIBRARY})
  set(CHEMKIT_LIBRARIES ${CHEMKIT_LIBRARIES} ${CHEMKIT_WEB_LIBRARY})
endif()

if(${CHEMKIT_USE_GRAPHICS_LIBRARY})
  set(CHEMKIT_LIBRARIES ${CHEMKIT_LIBRARIES} ${CHEMKIT_GRAPHICS_LIBRARY})
endif()

if(${CHEMKIT_USE_GUI_LIBRARY})
  set(CHEMKIT_LIBRARIES ${CHEMKIT_LIBRARIES} ${CHEMKIT_GUI_LIBRARY})
endif()
