/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bind.tuple;

import com.sleepycat.bind.tuple.MarshalledTupleEntry;
import com.sleepycat.bind.tuple.TupleBinding;
import com.sleepycat.bind.tuple.TupleInput;
import com.sleepycat.bind.tuple.TupleOutput;
import com.sleepycat.util.RuntimeExceptionWrapper;

public class TupleMarshalledBinding
extends TupleBinding {
    private Class cls;

    public TupleMarshalledBinding(Class clazz) {
        this.cls = clazz;
        if (!MarshalledTupleEntry.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(clazz.toString() + " does not implement MarshalledTupleEntry");
        }
    }

    @Override
    public Object entryToObject(TupleInput tupleInput) {
        try {
            MarshalledTupleEntry marshalledTupleEntry = (MarshalledTupleEntry)this.cls.newInstance();
            marshalledTupleEntry.unmarshalEntry(tupleInput);
            return marshalledTupleEntry;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeExceptionWrapper(illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeExceptionWrapper(instantiationException);
        }
    }

    @Override
    public void objectToEntry(Object object, TupleOutput tupleOutput) {
        MarshalledTupleEntry marshalledTupleEntry = (MarshalledTupleEntry)object;
        marshalledTupleEntry.marshalEntry(tupleOutput);
    }
}

