/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.collections;

import com.sleepycat.bind.EntityBinding;
import com.sleepycat.bind.EntryBinding;
import com.sleepycat.bind.RecordNumberBinding;
import com.sleepycat.collections.BaseIterator;
import com.sleepycat.collections.BlockIterator;
import com.sleepycat.collections.DataCursor;
import com.sleepycat.collections.DataView;
import com.sleepycat.collections.PrimaryKeyAssigner;
import com.sleepycat.collections.StoredCollection;
import com.sleepycat.collections.StoredContainer;
import com.sleepycat.collections.StoredIterator;
import com.sleepycat.db.Database;
import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.OperationStatus;
import com.sleepycat.util.keyrange.KeyRangeException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class StoredList<E>
extends StoredCollection<E>
implements List<E> {
    private static final EntryBinding DEFAULT_KEY_BINDING = new IndexKeyBinding(1);
    private int baseIndex = 1;
    private boolean isSubList;

    public StoredList(Database database, EntryBinding<E> entryBinding, boolean bl) {
        super(new DataView(database, DEFAULT_KEY_BINDING, entryBinding, null, bl, null));
    }

    public StoredList(Database database, EntityBinding<E> entityBinding, boolean bl) {
        super(new DataView(database, DEFAULT_KEY_BINDING, null, entityBinding, bl, null));
    }

    public StoredList(Database database, EntryBinding<E> entryBinding, PrimaryKeyAssigner primaryKeyAssigner) {
        super(new DataView(database, DEFAULT_KEY_BINDING, entryBinding, null, true, primaryKeyAssigner));
    }

    public StoredList(Database database, EntityBinding<E> entityBinding, PrimaryKeyAssigner primaryKeyAssigner) {
        super(new DataView(database, DEFAULT_KEY_BINDING, null, entityBinding, true, primaryKeyAssigner));
    }

    private StoredList(DataView dataView, int n) {
        super(dataView);
        this.baseIndex = n;
        this.isSubList = true;
    }

    @Override
    public void add(int n, E e) {
        this.checkIterAddAllowed();
        DataCursor dataCursor = null;
        boolean bl = this.beginAutoCommit();
        try {
            dataCursor = new DataCursor(this.view, true);
            OperationStatus operationStatus = dataCursor.getSearchKey(n, null, false);
            if (operationStatus == OperationStatus.SUCCESS) {
                dataCursor.putBefore(e);
                this.closeCursor(dataCursor);
            } else {
                this.closeCursor(dataCursor);
                dataCursor = null;
                this.view.append(e, null, null);
            }
            this.commitAutoCommit(bl);
        }
        catch (Exception exception) {
            this.closeCursor(dataCursor);
            throw this.handleException(exception, bl);
        }
    }

    @Override
    public boolean add(E e) {
        this.checkIterAddAllowed();
        boolean bl = this.beginAutoCommit();
        try {
            this.view.append(e, null, null);
            this.commitAutoCommit(bl);
            return true;
        }
        catch (Exception exception) {
            throw this.handleException(exception, bl);
        }
    }

    public int append(E e) {
        boolean bl = this.beginAutoCommit();
        try {
            Object[] objectArray = new Object[1];
            this.view.append(e, objectArray, null);
            this.commitAutoCommit(bl);
            return ((Number)objectArray[0]).intValue();
        }
        catch (Exception exception) {
            throw this.handleException(exception, bl);
        }
    }

    @Override
    void checkIterAddAllowed() throws UnsupportedOperationException {
        if (this.isSubList) {
            throw new UnsupportedOperationException("cannot add to subList");
        }
        if (!this.view.keysRenumbered) {
            throw new UnsupportedOperationException("requires renumbered keys");
        }
    }

    @Override
    public boolean addAll(int n, Collection<? extends E> collection) {
        this.checkIterAddAllowed();
        DataCursor dataCursor = null;
        Iterator iterator = null;
        boolean bl = this.beginAutoCommit();
        try {
            iterator = this.storedOrExternalIterator(collection);
            if (!iterator.hasNext()) {
                return false;
            }
            dataCursor = new DataCursor(this.view, true);
            OperationStatus operationStatus = dataCursor.getSearchKey(n, null, false);
            if (operationStatus == OperationStatus.SUCCESS) {
                while (iterator.hasNext()) {
                    dataCursor.putBefore(iterator.next());
                }
                this.closeCursor(dataCursor);
            } else {
                this.closeCursor(dataCursor);
                dataCursor = null;
                while (iterator.hasNext()) {
                    this.view.append(iterator.next(), null, null);
                }
            }
            StoredIterator.close(iterator);
            this.commitAutoCommit(bl);
            return true;
        }
        catch (Exception exception) {
            this.closeCursor(dataCursor);
            StoredIterator.close(iterator);
            throw this.handleException(exception, bl);
        }
    }

    @Override
    public boolean contains(Object object) {
        return this.containsValue(object);
    }

    @Override
    public E get(int n) {
        return (E)this.getValue(n);
    }

    @Override
    public int indexOf(Object object) {
        return this.indexOf(object, true);
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.indexOf(object, false);
    }

    private int indexOf(Object object, boolean bl) {
        int n;
        DataCursor dataCursor = null;
        try {
            dataCursor = new DataCursor(this.view, false);
            OperationStatus operationStatus = dataCursor.findValue(object, bl);
            n = operationStatus == OperationStatus.SUCCESS ? dataCursor.getCurrentRecordNumber() - this.baseIndex : -1;
        }
        catch (Exception exception) {
            try {
                throw StoredContainer.convertException(exception);
            }
            catch (Throwable throwable) {
                this.closeCursor(dataCursor);
                throw throwable;
            }
        }
        this.closeCursor(dataCursor);
        return n;
    }

    @Override
    int getIndexOffset() {
        return this.baseIndex;
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.blockIterator();
    }

    @Override
    public ListIterator<E> listIterator(int n) {
        BlockIterator blockIterator = this.blockIterator();
        if (blockIterator.moveToIndex(n)) {
            return blockIterator;
        }
        throw new IndexOutOfBoundsException(String.valueOf(n));
    }

    @Override
    public E remove(int n) {
        try {
            Object[] objectArray = new Object[1];
            this.removeKey(n, objectArray);
            return (E)objectArray[0];
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IndexOutOfBoundsException(illegalArgumentException.getMessage());
        }
    }

    @Override
    public boolean remove(Object object) {
        return this.removeValue(object);
    }

    @Override
    public E set(int n, E e) {
        try {
            return (E)this.putKeyValue(n, e);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IndexOutOfBoundsException(illegalArgumentException.getMessage());
        }
    }

    @Override
    public List<E> subList(int n, int n2) {
        if (n < 0 || n > n2) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        try {
            int n3 = this.baseIndex + n;
            return new StoredList<E>(this.view.subView(n, true, n2, false, new IndexKeyBinding(n3)), n3);
        }
        catch (KeyRangeException keyRangeException) {
            throw new IndexOutOfBoundsException(keyRangeException.getMessage());
        }
        catch (Exception exception) {
            throw StoredContainer.convertException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object object) {
        if (!(object instanceof List)) {
            return false;
        }
        List list = (List)object;
        StoredIterator storedIterator = null;
        ListIterator listIterator = null;
        try {
            storedIterator = this.storedIterator();
            listIterator = this.storedOrExternalListIterator(list);
            while (storedIterator.hasNext()) {
                if (!listIterator.hasNext()) {
                    boolean bl = false;
                    return bl;
                }
                if (storedIterator.nextIndex() != listIterator.nextIndex()) {
                    boolean bl = false;
                    return bl;
                }
                Object e = storedIterator.next();
                Object e2 = listIterator.next();
                if (e == null) {
                    if (e2 == null) continue;
                    boolean bl = false;
                    return bl;
                }
                if (e.equals(e2)) continue;
                boolean bl = false;
                return bl;
            }
            if (listIterator.hasNext()) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (storedIterator != null) {
                storedIterator.close();
            }
            StoredIterator.close(listIterator);
        }
    }

    final ListIterator storedOrExternalListIterator(List list) {
        if (list instanceof StoredCollection) {
            return ((StoredCollection)((Object)list)).storedIterator();
        }
        return list.listIterator();
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    E makeIteratorData(BaseIterator baseIterator, DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, DatabaseEntry databaseEntry3) {
        return (E)this.view.makeValue(databaseEntry2, databaseEntry3);
    }

    @Override
    boolean hasValues() {
        return true;
    }

    private static class IndexKeyBinding
    extends RecordNumberBinding {
        private int baseIndex;

        private IndexKeyBinding(int n) {
            this.baseIndex = n;
        }

        @Override
        public Long entryToObject(DatabaseEntry databaseEntry) {
            return IndexKeyBinding.entryToRecordNumber(databaseEntry) - (long)this.baseIndex;
        }

        @Override
        public void objectToEntry(Object object, DatabaseEntry databaseEntry) {
            IndexKeyBinding.recordNumberToEntry(((Number)object).intValue() + this.baseIndex, databaseEntry);
        }
    }
}

