/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.ui.tools.maintenance;

import java.sql.SQLException;
import java.util.Collection;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchPartSite;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.db2.model.DB2Table;
import org.jkiss.dbeaver.ext.db2.ui.internal.DB2Messages;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.exec.JDBCResultSetMetaDataImpl;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.sql.dialogs.GenerateMultiSQLDialog;
import org.jkiss.dbeaver.ui.editors.sql.dialogs.SQLScriptProgressListener;
import org.jkiss.dbeaver.ui.editors.sql.dialogs.SQLScriptStatusDialog;
import org.jkiss.utils.CommonUtils;

public abstract class DB2BaseTableToolDialog
extends GenerateMultiSQLDialog<DB2Table> {
    public DB2BaseTableToolDialog(IWorkbenchPartSite partSite, String title, Collection<DB2Table> objects) {
        super(partSite, title, objects, true);
    }

    protected int getNumberExtraResultingColumns() {
        return 0;
    }

    protected SQLScriptProgressListener<DB2Table> getScriptListener() {
        final int nbExtraColumns = this.getNumberExtraResultingColumns();
        return new SQLScriptStatusDialog<DB2Table>(this.getTitle() + " " + DB2Messages.dialog_table_tools_progress, null){

            protected void createStatusColumns(Tree objectTree) {
                TreeColumn msgColumn = new TreeColumn(objectTree, 0);
                msgColumn.setText(DB2Messages.dialog_table_tools_result);
                int i = 0;
                while (i < nbExtraColumns) {
                    new TreeColumn(objectTree, 0);
                    ++i;
                }
            }

            public void processObjectResults(@NotNull DB2Table db2Table, @Nullable DBCStatement statement, @Nullable DBCResultSet resultSet) throws DBCException {
                if (resultSet == null) {
                    return;
                }
                JDBCResultSetMetaDataImpl rsMetaData = (JDBCResultSetMetaDataImpl)resultSet.getMeta();
                try {
                    TreeItem treeItem = this.getTreeItem((DBSObject)db2Table);
                    Font f = UIUtils.makeBoldFont((Font)treeItem.getFont());
                    if (treeItem != null) {
                        TreeItem subItem = null;
                        subItem = new TreeItem(treeItem, 0);
                        subItem.setFont(f);
                        int i = 0;
                        while (i < rsMetaData.getColumnCount()) {
                            subItem.setText(i, rsMetaData.getColumnName(i + 1));
                            subItem.setGrayed(true);
                            ++i;
                        }
                        while (resultSet.nextRow()) {
                            subItem = new TreeItem(treeItem, 0);
                            i = 0;
                            while (i < rsMetaData.getColumnCount()) {
                                subItem.setText(i, CommonUtils.toString((Object)resultSet.getAttributeValue(i)));
                                ++i;
                            }
                        }
                        treeItem.setExpanded(true);
                    }
                }
                catch (SQLException e) {
                    throw new DBCException(e.getMessage());
                }
            }
        };
    }
}

