/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.parser.rules;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.parser.rules.SQLDelimiterRule;
import org.jkiss.dbeaver.model.text.parser.TPCharacterScanner;
import org.jkiss.dbeaver.model.text.parser.TPRule;
import org.jkiss.dbeaver.model.text.parser.TPToken;
import org.jkiss.dbeaver.model.text.parser.TPTokenAbstract;

public class SQLWordRule
implements TPRule {
    private final SQLDelimiterRule delimRule;
    private final TPToken functionToken;
    private final TPToken defaultToken;
    private final Map<String, TPToken> words = new HashMap<String, TPToken>();
    private final Set<String> functions = new HashSet<String>();
    private final StringBuilder buffer = new StringBuilder();
    private final SQLDialect dialect;
    private char[][] delimiters;

    public SQLWordRule(SQLDelimiterRule delimRule, TPToken functionToken, TPToken defaultToken, @NotNull SQLDialect dialect) {
        this.delimRule = delimRule;
        this.functionToken = functionToken;
        this.defaultToken = defaultToken;
        this.dialect = dialect;
    }

    public boolean hasWord(String word) {
        return this.words.containsKey(word.toLowerCase());
    }

    public void addWord(String word, TPToken token) {
        this.words.put(word.toLowerCase(), token);
    }

    public boolean hasFunction(String function) {
        return this.functions.contains(function);
    }

    public void addFunction(String function) {
        this.functions.add(function.toLowerCase());
    }

    @Override
    public TPToken evaluate(TPCharacterScanner scanner) {
        int c = scanner.read();
        if (c != -1 && this.dialect.isWordStart(c)) {
            char prevC;
            this.buffer.setLength(0);
            this.delimiters = this.delimRule.getDelimiters();
            do {
                prevC = (char)c;
                this.buffer.append((char)c);
            } while ((c = scanner.read()) != -1 && this.isWordPart((char)c, prevC, scanner));
            scanner.unread();
            String buffer = this.buffer.toString().toLowerCase();
            TPToken token = this.words.get(buffer);
            if (this.functions.contains(buffer)) {
                int length = 0;
                while (c != -1 && Character.isWhitespace(c)) {
                    c = scanner.read();
                    ++length;
                }
                while (length > 0) {
                    scanner.unread();
                    --length;
                }
                if (c == 40 || token == null) {
                    return this.functionToken;
                }
            }
            if (token != null) {
                return token;
            }
            if (this.defaultToken.isUndefined()) {
                this.unreadBuffer(scanner);
            }
            return this.defaultToken;
        }
        scanner.unread();
        return TPTokenAbstract.UNDEFINED;
    }

    private boolean isWordPart(char c, char prevC, TPCharacterScanner scanner) {
        if (!this.dialect.isWordPart((int)c) && c != '$') {
            return false;
        }
        if (c == '$' && prevC == '$') {
            scanner.unread();
            this.buffer.setLength(this.buffer.length() - 1);
            return false;
        }
        char[][] cArray = this.delimiters;
        int n = this.delimiters.length;
        int n2 = 0;
        while (n2 < n) {
            char[] wordDelimiter = cArray[n2];
            if (!Character.isLetter(c) && c == wordDelimiter[0]) {
                if (wordDelimiter.length == 1) {
                    return false;
                }
                int charsRead = 0;
                boolean matches = true;
                int i = 1;
                while (i < wordDelimiter.length) {
                    int c2 = scanner.read();
                    ++charsRead;
                    if (c2 == -1) break;
                    if (c2 != wordDelimiter[i]) {
                        matches = false;
                        break;
                    }
                    ++i;
                }
                i = 0;
                while (i < charsRead) {
                    scanner.unread();
                    ++i;
                }
                if (matches) {
                    return false;
                }
            }
            ++n2;
        }
        return true;
    }

    private void unreadBuffer(TPCharacterScanner scanner) {
        int i = this.buffer.length() - 1;
        while (i >= 0) {
            scanner.unread();
            --i;
        }
    }
}

