/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model.impls.redshift;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreClass;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDialect;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableBase;
import org.jkiss.dbeaver.ext.postgresql.model.impls.PostgreServerExtensionBase;
import org.jkiss.dbeaver.ext.postgresql.model.impls.redshift.RedshiftExternalSchema;
import org.jkiss.dbeaver.ext.postgresql.model.impls.redshift.RedshiftSchema;
import org.jkiss.dbeaver.ext.postgresql.model.impls.redshift.RedshiftTable;
import org.jkiss.dbeaver.ext.postgresql.model.impls.redshift.RedshiftView;
import org.jkiss.dbeaver.model.DBPErrorAssistant;
import org.jkiss.dbeaver.model.DBPKeywordType;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLState;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.utils.CommonUtils;
import org.osgi.framework.Version;

public class PostgreServerRedshift
extends PostgreServerExtensionBase
implements DBPErrorAssistant {
    private static final Log log = Log.getLog(PostgreServerRedshift.class);
    public static final int RS_ERROR_CODE_CHANNEL_CLOSE = 500366;
    public static final int RS_ERROR_CODE_NOT_CONNECTED = 500150;
    public static final String RS_OBJECT_CLASS = "com.amazon.redshift.util.RedshiftObject";
    private Version redshiftVersion;
    private static final String[] REDSHIFT_OTHER_TYPES_FUNCTION = new String[]{"SYSDATE"};
    public static String[] REDSHIFT_EXTRA_KEYWORDS = new String[]{"AUTO", "BACKUP", "AZ64", "CASE_SENSITIVE", "CASE_INSENSITIVE", "COMPOUND", "INTERLEAVED", "COPY", "DATASHARE", "DISTSTYLE", "DISTKEY", "EVEN", "MODEL", "OWNER", "SORTKEY", "TEMP", "UNLOAD", "VACUUM", "YES", "AES128", "AES256", "ALLOWOVERWRITE", "BLANKSASNULL", "BYTEDICT", "BZIP2", "CREDENTIALS", "DEFLATE", "DEFRAG", "DELTA", "DELTA32K", "EMPTYASNULL", "ENCRYPT", "ENCRYPTION", "EXPLICIT", "GLOBALDICT256", "GLOBALDICT64K", "GZIP", "LUN", "LUNS", "LZO", "LZOP", "MINUS", "MOSTLY16", "MOSTLY32", "MOSTLY8", "OFFLINE", "OID", "PERMISSIONS", "PIVOT", "RAW", "READRATIO", "RECOVER", "REJECTLOG", "RESORT", "SNAPSHOT", "TAG", "TDES", "TEXT255", "TEXT32K", "TOP", "TRUNCATECOLUMNS", "UNPIVOT", "WALLET", "ACCEPTANYDATE", "ACCEPTINVCHARS", "BLANKSASNULL", "DATEFORMAT", "EMPTYASNULL", "EXPLICIT_IDS", "FILLRECORD", "IGNOREBLANKLINES", "IGNOREHEADER", "NULLAS", "REMOVEQUOTES", "ROUNDEC", "TIMEFORMAT", "TRIMBLANKS", "TRUNCATECOLUMNS", "COMPROWS", "COMPUPDATE", "IGNOREALLERRORS", "MAXERROR", "NOLOAD", "STATUPDATE"};
    public static String[] REDSHIFT_FUNCTIONS_CONDITIONAL = new String[]{"NVL", "NVL2"};

    public PostgreServerRedshift(PostgreDataSource dataSource) {
        super(dataSource);
    }

    private boolean isRedshiftVersionAtLeast(int major, int minor, int micro) {
        String serverVersion;
        if (this.redshiftVersion == null && !CommonUtils.isEmpty((String)(serverVersion = this.dataSource.getServerVersion()))) {
            try {
                String versionStr;
                Matcher matcher = Pattern.compile("Redshift ([0-9\\.]+)").matcher(serverVersion);
                if (matcher.find() && !CommonUtils.isEmpty((String)(versionStr = matcher.group(1)))) {
                    this.redshiftVersion = new Version(versionStr);
                }
            }
            catch (Exception e) {
                log.debug((Object)"Error getting Redshift version", (Throwable)e);
                this.redshiftVersion = new Version(1, 0, 0);
            }
        }
        if (this.redshiftVersion != null) {
            if (this.redshiftVersion.getMajor() > major) {
                return true;
            }
            if (this.redshiftVersion.getMajor() == major) {
                if (this.redshiftVersion.getMinor() > minor) {
                    return true;
                }
                if (this.redshiftVersion.getMinor() == minor) {
                    return this.redshiftVersion.getMicro() >= micro;
                }
            }
        }
        return false;
    }

    @Override
    public String getServerTypeName() {
        return "Redshift";
    }

    @Override
    public boolean supportsOids() {
        return false;
    }

    @Override
    public boolean supportsIndexes() {
        return false;
    }

    @Override
    public boolean supportsMaterializedViews() {
        return false;
    }

    @Override
    public boolean supportsPartitions() {
        return false;
    }

    @Override
    public boolean supportsInheritance() {
        return false;
    }

    @Override
    public boolean supportsTriggers() {
        return false;
    }

    @Override
    public boolean supportsRules() {
        return false;
    }

    @Override
    public boolean supportsExtensions() {
        return false;
    }

    @Override
    public boolean supportsEncodings() {
        return false;
    }

    @Override
    public boolean supportsTablespaces() {
        return false;
    }

    @Override
    public boolean supportsSequences() {
        return false;
    }

    @Override
    public boolean supportsRoles() {
        return ((Object)((Object)this.dataSource)).getClass() != PostgreDataSource.class;
    }

    @Override
    public boolean supportsCommentsOnRole() {
        return false;
    }

    @Override
    public boolean supportsLocks() {
        return false;
    }

    @Override
    public boolean supportsForeignServers() {
        return false;
    }

    @Override
    public boolean supportsClientInfo() {
        return false;
    }

    @Override
    public boolean supportsRelationSizeCalc() {
        return false;
    }

    /*
     * Exception decompiling
     */
    @Override
    public String readTableDDL(DBRProgressMonitor monitor, PostgreTableBase table) throws DBException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public PostgreTableBase createNewRelation(DBRProgressMonitor monitor, PostgreSchema schema, PostgreClass.RelKind kind, Object copyFrom) throws DBException {
        if (kind == PostgreClass.RelKind.r) {
            return new RedshiftTable(schema);
        }
        if (kind == PostgreClass.RelKind.v) {
            return new RedshiftView(schema);
        }
        return super.createNewRelation(monitor, schema, kind, copyFrom);
    }

    @Override
    public PostgreTableBase createRelationOfClass(PostgreSchema schema, PostgreClass.RelKind kind, JDBCResultSet dbResult) {
        if (kind == PostgreClass.RelKind.r) {
            return new RedshiftTable(schema, (ResultSet)dbResult);
        }
        if (kind == PostgreClass.RelKind.v) {
            return new RedshiftView(schema, (ResultSet)dbResult);
        }
        return super.createRelationOfClass(schema, kind, dbResult);
    }

    @Override
    public boolean supportsStoredProcedures() {
        return this.isRedshiftVersionAtLeast(1, 0, 6118);
    }

    @Override
    public String getProceduresSystemTable() {
        return this.supportsStoredProcedures() ? "pg_proc_info" : super.getProceduresSystemTable();
    }

    @Override
    public String getProceduresOidColumn() {
        return this.supportsStoredProcedures() ? "prooid" : super.getProceduresOidColumn();
    }

    @Override
    public boolean isAlterTableAtomic() {
        return true;
    }

    @Override
    public boolean supportSerialTypes() {
        return false;
    }

    @Override
    public boolean supportsEntityMetadataInResults() {
        return true;
    }

    @Override
    public PostgreDatabase.SchemaCache createSchemaCache(PostgreDatabase database) {
        return new RedshiftSchemaCache();
    }

    @NotNull
    public DBPErrorAssistant.ErrorType discoverErrorType(@NotNull Throwable error) {
        int errorCode = SQLState.getCodeFromException((Throwable)error);
        if (errorCode == 500366 || errorCode == 500150) {
            return DBPErrorAssistant.ErrorType.CONNECTION_LOST;
        }
        return null;
    }

    @Nullable
    public DBPErrorAssistant.ErrorPosition[] getErrorPosition(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext context, @NotNull String query, @NotNull Throwable error) {
        return null;
    }

    @Override
    public void configureDialect(PostgreDialect dialect) {
        dialect.addExtraKeywords(REDSHIFT_EXTRA_KEYWORDS);
        dialect.addKeywords(Arrays.asList(REDSHIFT_OTHER_TYPES_FUNCTION), DBPKeywordType.OTHER);
        dialect.addExtraFunctions(REDSHIFT_FUNCTIONS_CONDITIONAL);
    }

    @Override
    public void initDefaultSSLConfig(DBPConnectionConfiguration connectionInfo, Map<String, String> props) {
    }

    @Override
    public boolean supportsBackslashStringEscape() {
        return true;
    }

    @Override
    public int getParameterBindType(DBSTypedObject type, Object value) {
        if (value instanceof String) {
            return 12;
        }
        return super.getParameterBindType(type, value);
    }

    @Override
    public boolean supportsDatabaseSize() {
        return true;
    }

    @Override
    public boolean supportsFunctionDefRead() {
        return false;
    }

    @Override
    public boolean supportsExternalTypes() {
        return true;
    }

    @Override
    public int getTruncateToolModes() {
        return 0;
    }

    @Override
    public boolean supportsAcl() {
        return false;
    }

    @Override
    public boolean supportsCustomDataTypes() {
        return false;
    }

    @Override
    public boolean supportsAlterTableColumnWithUSING() {
        return false;
    }

    @Override
    public boolean supportsAlterTableForViewRename() {
        return true;
    }

    @Override
    public boolean supportsNativeClient() {
        return false;
    }

    @Override
    public boolean isPGObject(@NotNull Object object) {
        String className = object.getClass().getName();
        return className.equals(RS_OBJECT_CLASS);
    }

    private class RedshiftSchemaCache
    extends PostgreDatabase.SchemaCache {
        private final Map<String, String> esSchemaMap = new HashMap<String, String>();

        private RedshiftSchemaCache() {
        }

        @Override
        @NotNull
        public JDBCStatement prepareLookupStatement(@NotNull JDBCSession session, @NotNull PostgreDatabase database, @Nullable PostgreSchema object, @Nullable String objectName) throws SQLException {
            this.esSchemaMap.clear();
            try {
                Throwable throwable = null;
                Object var6_8 = null;
                try (JDBCPreparedStatement dbStat = session.prepareStatement("SELECT * FROM " + DBUtils.getQuotedIdentifier((DBSObject)database) + ".pg_catalog.svv_external_schemas");){
                    Throwable throwable2 = null;
                    Object var9_13 = null;
                    try (JDBCResultSet dbResult = dbStat.executeQuery();){
                        while (dbResult.next()) {
                            String esSchemaName = dbResult.getString("schemaname");
                            String esSchemaOptions = dbResult.getString("esoptions");
                            this.esSchemaMap.put(esSchemaName, esSchemaOptions);
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                log.debug((Object)"Error reading Redshift external schemas", e);
            }
            return super.prepareLookupStatement(session, database, object, objectName);
        }

        @Override
        protected PostgreSchema fetchObject(@NotNull JDBCSession session, @NotNull PostgreDatabase owner, @NotNull JDBCResultSet resultSet) throws SQLException, DBException {
            String name = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"nspname");
            String esOptions = this.esSchemaMap.get(name);
            if (esOptions != null) {
                return new RedshiftExternalSchema(owner, name, esOptions, (ResultSet)resultSet);
            }
            if (CommonUtils.isEmpty((String)name) || PostgreSchema.isUtilitySchema(name) && !owner.getDataSource().getContainer().getNavigatorSettings().isShowUtilityObjects()) {
                return null;
            }
            return new RedshiftSchema(owner, name, (ResultSet)resultSet);
        }

        public void clearCache() {
            super.clearCache();
            this.esSchemaMap.clear();
        }
    }
}

