/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.userauth.keyprovider;

import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import net.schmizz.sshj.common.KeyType;
import net.schmizz.sshj.userauth.keyprovider.KeyProvider;

public class KeyPairWrapper
implements KeyProvider {
    private final KeyPair kp;
    private final KeyType type;

    public KeyPairWrapper(KeyPair kp) {
        this.kp = kp;
        this.type = KeyType.fromKey(kp.getPublic());
    }

    public KeyPairWrapper(PublicKey publicKey, PrivateKey privateKey) {
        this(new KeyPair(publicKey, privateKey));
    }

    @Override
    public PrivateKey getPrivate() {
        return this.kp.getPrivate();
    }

    @Override
    public PublicKey getPublic() {
        return this.kp.getPublic();
    }

    @Override
    public KeyType getType() {
        return this.type;
    }
}

