/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.ui.handlers;

import java.util.Locale;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSDataManipulator;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.DBSWrapper;
import org.jkiss.dbeaver.registry.ApplicationPolicyProvider;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.tools.transfer.IDataTransferNode;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseTransferConsumer;
import org.jkiss.dbeaver.tools.transfer.registry.DataTransferNodeDescriptor;
import org.jkiss.dbeaver.tools.transfer.registry.DataTransferProcessorDescriptor;
import org.jkiss.dbeaver.tools.transfer.registry.DataTransferRegistry;
import org.jkiss.dbeaver.tools.transfer.stream.StreamEntityMapping;
import org.jkiss.dbeaver.tools.transfer.stream.StreamTransferProducer;
import org.jkiss.dbeaver.tools.transfer.ui.handlers.DataTransferHandler;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.internal.UIMessages;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class DataImportHandler
extends DataTransferHandler {
    private static final Log log = Log.getLog(DataImportHandler.class);

    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        if (ApplicationPolicyProvider.getInstance().isPolicyEnabled("policy.data.import.disabled")) {
            UIUtils.showMessageBox((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)UIMessages.dialog_policy_data_import_title, (String)UIMessages.dialog_policy_data_import_msg, (int)8);
            return null;
        }
        return super.execute(event);
    }

    @Override
    protected IDataTransferNode<?> adaptTransferNode(Object object) {
        DBSDataManipulator adapted = (DBSDataManipulator)RuntimeUtils.getObjectAdapter((Object)object, DBSDataManipulator.class);
        if (adapted != null) {
            return new DatabaseTransferConsumer(adapted);
        }
        IFile file = (IFile)RuntimeUtils.getObjectAdapter((Object)object, IFile.class);
        if (file != null) {
            return this.getNodeByFile(file);
        }
        DBSObjectContainer objectContainer = (DBSObjectContainer)RuntimeUtils.getObjectAdapter((Object)object, DBSObjectContainer.class);
        if (objectContainer == null) {
            if (object instanceof DBSWrapper) {
                object = ((DBSWrapper)object).getObject();
            }
            if (object instanceof DBPObject) {
                object = DBUtils.getPublicObject((DBSObject)((DBSObject)object));
            }
            if (object instanceof DBSObjectContainer) {
                objectContainer = (DBSObjectContainer)object;
            }
        }
        if (objectContainer != null) {
            if (DataImportHandler.isObjectContainerSupportsImport(objectContainer)) {
                return new DatabaseTransferConsumer(objectContainer);
            }
            DBWorkbench.getPlatformUI().showError("Wrong container", objectContainer.getName() + " doesn't support direct data import");
        }
        return null;
    }

    private IDataTransferNode getNodeByFile(IFile file) {
        DataTransferProcessorDescriptor processor = this.getProcessorByFile(file);
        if (processor != null) {
            return new StreamTransferProducer(new StreamEntityMapping(file.getFullPath().toFile().toPath()), processor);
        }
        return null;
    }

    private DataTransferProcessorDescriptor getProcessorByFile(IFile file) {
        String extension = file.getFileExtension();
        if (CommonUtils.isEmpty((String)extension)) {
            return null;
        }
        extension = extension.toLowerCase(Locale.ENGLISH);
        DataTransferNodeDescriptor producerDesc = DataTransferRegistry.getInstance().getNodeById("stream_producer");
        if (producerDesc != null) {
            DataTransferProcessorDescriptor[] dataTransferProcessorDescriptorArray = producerDesc.getProcessors();
            int n = dataTransferProcessorDescriptorArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object[] defExtensions;
                DataTransferProcessorDescriptor processor = dataTransferProcessorDescriptorArray[n2];
                DBPPropertyDescriptor extList = processor.getProperty("extension");
                if (extList != null && ArrayUtils.contains((Object[])(defExtensions = CommonUtils.split((String)CommonUtils.toString((Object)extList.getDefaultValue()), (String)",")), (Object)extension)) {
                    return processor;
                }
                ++n2;
            }
        }
        return null;
    }

    public static boolean isObjectContainerSupportsImport(DBSObjectContainer object) {
        try {
            Class childType = object.getPrimaryChildType(null);
            return DBSDataContainer.class.isAssignableFrom(childType);
        }
        catch (DBException e) {
            log.error((Object)e);
            return false;
        }
    }
}

