/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.sqlite.ui.data.manager;

import org.eclipse.jface.action.IContributionManager;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.ui.data.IValueController;
import org.jkiss.dbeaver.ui.data.IValueEditor;
import org.jkiss.dbeaver.ui.data.managers.ContentValueManager;
import org.jkiss.dbeaver.ui.data.managers.StringValueManager;

public class SQLiteValueManager
extends StringValueManager {
    private static boolean isBinary(@NotNull IValueController controller) {
        DBPDataKind dataKind = controller.getValueType().getDataKind();
        return dataKind == DBPDataKind.BINARY || dataKind == DBPDataKind.CONTENT;
    }

    public IValueEditor createEditor(@NotNull IValueController controller) throws DBException {
        if (SQLiteValueManager.isBinary(controller)) {
            return new ContentValueManager().createEditor(controller);
        }
        return super.createEditor(controller);
    }

    public void contributeActions(@NotNull IContributionManager manager, @NotNull IValueController controller, @Nullable IValueEditor activeEditor) throws DBCException {
        if (SQLiteValueManager.isBinary(controller)) {
            new ContentValueManager().contributeActions(manager, controller, activeEditor);
        } else {
            super.contributeActions(manager, controller, activeEditor);
        }
    }
}

