/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.ScalableFigure;
import org.eclipse.draw2d.ScaledGraphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;

public interface IScalablePane
extends ScalableFigure {
    public boolean useScaledGraphics();

    public boolean optimizeClip();

    default public Rectangle getScaledRect(Rectangle rect) {
        double scale = this.getScale();
        rect.scale(1.0 / scale);
        return rect;
    }

    public static final class IScalablePaneHelper {
        private static Graphics prepareScaledGraphics(Graphics graphics, IScalablePane figurePane) {
            Graphics graphicsToUse;
            Graphics graphics2 = graphicsToUse = figurePane.useScaledGraphics() ? new ScaledGraphics(graphics) : graphics;
            if (!figurePane.optimizeClip()) {
                graphicsToUse.clipRect(figurePane.getBounds().getShrinked(figurePane.getInsets()));
            }
            graphicsToUse.scale(figurePane.getScale());
            graphicsToUse.pushState();
            return graphicsToUse;
        }

        private static void cleanupScaledGraphics(Graphics graphics, Graphics graphicsUsed) {
            graphicsUsed.popState();
            if (graphicsUsed != graphics) {
                graphicsUsed.dispose();
            }
            graphics.restoreState();
        }

        static Rectangle getClientArea(IScalablePane figurePane, Function<Rectangle, Rectangle> superMethod, Rectangle rect) {
            return figurePane.getScaledRect(superMethod.apply(rect));
        }

        static Dimension getMinimumSize(IScalablePane figurePane, BiFunction<Integer, Integer, Dimension> superMethod, int wHint, int hHint) {
            Dimension d = superMethod.apply(IScalablePaneHelper.getScaledHint(figurePane, wHint), IScalablePaneHelper.getScaledHint(figurePane, hHint));
            int w = figurePane.getInsets().getWidth();
            int h = figurePane.getInsets().getHeight();
            return d.getExpanded(-w, -h).scale(figurePane.getScale()).expand(w, h);
        }

        static Dimension getPreferredSize(IScalablePane figurePane, BiFunction<Integer, Integer, Dimension> superMethod, int wHint, int hHint) {
            Dimension d = superMethod.apply(IScalablePaneHelper.getScaledHint(figurePane, wHint), IScalablePaneHelper.getScaledHint(figurePane, hHint));
            int w = figurePane.getInsets().getWidth();
            int h = figurePane.getInsets().getHeight();
            return d.getExpanded(-w, -h).scale(figurePane.getScale()).expand(w, h);
        }

        private static int getScaledHint(IScalablePane figurePane, int hint) {
            return hint != -1 ? (int)((double)hint / figurePane.getScale()) : -1;
        }

        static void paintClientArea(IScalablePane figurePane, Consumer<Graphics> superMethod, Graphics graphics) {
            if (figurePane.getChildren().isEmpty()) {
                return;
            }
            if (figurePane.getScale() == 1.0) {
                superMethod.accept(graphics);
            } else {
                Graphics graphicsToUse = IScalablePaneHelper.prepareScaledGraphics(graphics, figurePane);
                ((Figure)((Object)figurePane)).paintChildren(graphicsToUse);
                IScalablePaneHelper.cleanupScaledGraphics(graphics, graphicsToUse);
            }
        }

        static void translateToParent(IScalablePane figurePane, Translatable t) {
            t.performScale(figurePane.getScale());
        }

        static void translateFromParent(IScalablePane figurePane, Translatable t) {
            t.performScale(1.0 / figurePane.getScale());
        }

        private IScalablePaneHelper() {
            throw new UnsupportedOperationException("Helper class IScalablePaneHelper should not be instantiated");
        }
    }
}

