/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.vertica.model;

import java.sql.ResultSet;
import java.util.Date;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.GenericView;
import org.jkiss.dbeaver.ext.vertica.VerticaUtils;
import org.jkiss.dbeaver.ext.vertica.model.VerticaDataSource;
import org.jkiss.dbeaver.ext.vertica.model.VerticaSchema;
import org.jkiss.dbeaver.model.DBPObjectWithLazyDescription;
import org.jkiss.dbeaver.model.DBPSystemObject;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.IPropertyCacheValidator;
import org.jkiss.dbeaver.model.meta.LazyProperty;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyLength;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class VerticaView
extends GenericView
implements DBPSystemObject,
DBPObjectWithLazyDescription {
    private Date createTime;
    private boolean isTempTable;
    private boolean isSystemTable;
    private String description;

    public VerticaView(VerticaSchema container, String tableName, String tableType, JDBCResultSet dbResult) {
        super((GenericStructContainer)container, tableName, tableType, dbResult);
        if (dbResult != null) {
            this.createTime = JDBCUtils.safeGetDate((ResultSet)dbResult, (String)"create_time");
            this.isTempTable = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"is_temp_table");
            this.isSystemTable = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"is_system_table");
        }
    }

    @Property(viewable=true, order=3)
    public Date getCreateTime() {
        return this.createTime;
    }

    @Property(viewable=true, order=4)
    public boolean isTempTable() {
        return this.isTempTable;
    }

    public boolean isSystem() {
        return this.isSystemTable;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Property(viewable=true, editable=true, updatable=true, length=PropertyLength.MULTILINE, order=100)
    @LazyProperty(cacheValidator=CommentsValidator.class)
    @Nullable
    public String getDescription(@NotNull DBRProgressMonitor monitor) throws DBException {
        if (this.description == null) {
            if (!((VerticaDataSource)this.getDataSource()).avoidCommentsReading()) {
                VerticaUtils.readTableAndColumnsDescriptions(monitor, (GenericDataSource)this.getDataSource(), (GenericTableBase)this, true);
            }
            if (this.description == null) {
                this.description = "";
            }
        }
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public static class CommentsValidator
    implements IPropertyCacheValidator<VerticaView> {
        public boolean isPropertyCached(@NotNull VerticaView object, @NotNull Object propertyId) {
            return object.description != null;
        }
    }
}

