/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.greenplum.model;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.greenplum.model.GreenplumDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.osgi.framework.Version;

public class CloudberryDataSource
extends GreenplumDataSource {
    private static final Log log = Log.getLog(CloudberryDataSource.class);
    private Version cbVersion;

    public CloudberryDataSource(DBRProgressMonitor monitor, DBPDataSourceContainer container) throws DBException {
        super(monitor, container);
    }

    @Override
    public void initialize(@NotNull DBRProgressMonitor monitor) throws DBException {
        super.initialize(monitor);
        if (this.serverVersion != null) {
            Matcher matcher = Pattern.compile("(Cloudberry Database|Apache Cloudberry) ([0-9\\.]+)").matcher(this.serverVersion);
            if (matcher.find()) {
                this.cbVersion = new Version(matcher.group(2));
            }
            this.gpVersion = new Version(7, 0, 0);
        }
        if (this.cbVersion == null) {
            this.cbVersion = new Version(1, 0, 0);
        }
    }
}

