/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.themes;

import java.util.Arrays;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.themes.ColorDefinition;
import org.eclipse.ui.internal.themes.FontDefinition;
import org.eclipse.ui.internal.themes.IHierarchalThemeElementDefinition;
import org.eclipse.ui.internal.themes.IThemeRegistry;
import org.eclipse.ui.themes.ITheme;

public final class ThemeElementHelper {
    public static void populateDefinition(org.eclipse.e4.ui.css.swt.theme.ITheme cssTheme, ITheme theme, FontRegistry registry, FontDefinition definition, IPreferenceStore store) {
        String key = ThemeElementHelper.createPreferenceKey(cssTheme, theme, definition.getId());
        String value = store.getString(key);
        if (!"".equals(value)) {
            definition.appendState(1);
            definition.appendState(4);
            registry.put(definition.getId(), PreferenceConverter.basicGetFontData((String)value));
        }
    }

    public static void populateRegistry(ITheme theme, FontDefinition[] definitions, IPreferenceStore store) {
        FontDefinition[] copyOfDefinitions = null;
        FontDefinition[] defaults = null;
        if (!theme.getId().equals("org.eclipse.ui.defaultTheme")) {
            definitions = ThemeElementHelper.addDefaulted(definitions);
            if (store != null) {
                defaults = ThemeElementHelper.getDefaults(definitions);
            }
        }
        copyOfDefinitions = new FontDefinition[definitions.length];
        System.arraycopy(definitions, 0, copyOfDefinitions, 0, definitions.length);
        Arrays.sort(copyOfDefinitions, new IThemeRegistry.HierarchyComparator(definitions));
        FontDefinition[] fontDefinitionArray = copyOfDefinitions;
        int n = copyOfDefinitions.length;
        int n2 = 0;
        while (n2 < n) {
            FontDefinition definition = fontDefinitionArray[n2];
            ThemeElementHelper.installFont(definition, theme, store, true);
            ++n2;
        }
        if (defaults != null) {
            fontDefinitionArray = defaults;
            n = defaults.length;
            n2 = 0;
            while (n2 < n) {
                FontDefinition fontDef = fontDefinitionArray[n2];
                ThemeElementHelper.installFont(fontDef, theme, store, false);
                ++n2;
            }
        }
    }

    private static FontDefinition[] addDefaulted(FontDefinition[] definitions) {
        IThemeRegistry registry = WorkbenchPlugin.getDefault().getThemeRegistry();
        IHierarchalThemeElementDefinition[] allDefs = registry.getFonts();
        SortedSet set = ThemeElementHelper.addDefaulted(definitions, allDefs);
        return set.toArray(new FontDefinition[set.size()]);
    }

    private static void installFont(FontDefinition definition, ITheme theme, IPreferenceStore store, boolean setInRegistry) {
        FontData[] fontData;
        FontRegistry registry = theme.getFontRegistry();
        Display display = PlatformUI.getWorkbench().getDisplay();
        String id = definition.getId();
        String key = ThemeElementHelper.createPreferenceKey(theme, id);
        FontData[] prefFont = store != null ? PreferenceConverter.getFontDataArray((IPreferenceStore)store, (String)key) : null;
        FontData[] defaultFont = null;
        if (definition.getValue() != null) {
            defaultFont = definition.getValue();
        } else if (definition.getDefaultsTo() != null) {
            String defaultsToKey = ThemeElementHelper.createPreferenceKey(theme, definition.getDefaultsTo());
            FontData[] defaultFontData = PreferenceConverter.getDefaultFontDataArray((IPreferenceStore)store, (String)defaultsToKey);
            defaultFont = registry.filterData(defaultFontData, display);
        } else {
            fontData = JFaceResources.getFontRegistry().getFontData(display.getHighContrast() ? "org.eclipse.jface.defaultfont" : id);
            defaultFont = registry.bestDataArray(fontData, display);
        }
        if (setInRegistry) {
            if (prefFont == null || prefFont == PreferenceConverter.getFontDataArrayDefaultDefault()) {
                if (definition.getValue() != null) {
                    prefFont = definition.getValue();
                } else if (definition.getDefaultsTo() != null) {
                    fontData = registry.getFontData(definition.getDefaultsTo());
                    prefFont = registry.filterData(fontData, display);
                } else {
                    prefFont = defaultFont;
                }
            }
            if (!definition.isEditable()) {
                prefFont = defaultFont;
            }
            if (prefFont != null) {
                registry.put(id, prefFont);
            }
        }
        if (defaultFont != null && store != null) {
            PreferenceConverter.setDefault((IPreferenceStore)store, (String)key, (FontData[])defaultFont);
        }
    }

    public static void populateDefinition(org.eclipse.e4.ui.css.swt.theme.ITheme cssTheme, ITheme theme, ColorRegistry registry, ColorDefinition definition, IPreferenceStore store) {
        String key = ThemeElementHelper.createPreferenceKey(cssTheme, theme, definition.getId());
        String value = store.getString(key);
        if (!"".equals(value)) {
            definition.appendState(1);
            definition.appendState(4);
            registry.put(definition.getId(), StringConverter.asRGB((String)value));
        }
    }

    public static void populateRegistry(ITheme theme, ColorDefinition[] definitions, IPreferenceStore store) {
        ColorDefinition[] copyOfDefinitions = null;
        ColorDefinition[] defaults = null;
        if (!theme.getId().equals("org.eclipse.ui.defaultTheme")) {
            definitions = ThemeElementHelper.addDefaulted(definitions);
            if (store != null) {
                defaults = ThemeElementHelper.getDefaults(definitions);
            }
        }
        copyOfDefinitions = new ColorDefinition[definitions.length];
        System.arraycopy(definitions, 0, copyOfDefinitions, 0, definitions.length);
        Arrays.sort(copyOfDefinitions, new IThemeRegistry.HierarchyComparator(definitions));
        ColorDefinition[] colorDefinitionArray = copyOfDefinitions;
        int n = copyOfDefinitions.length;
        int n2 = 0;
        while (n2 < n) {
            ColorDefinition definition = colorDefinitionArray[n2];
            ThemeElementHelper.installColor(definition, theme, store, true);
            ++n2;
        }
        if (defaults != null) {
            colorDefinitionArray = defaults;
            n = defaults.length;
            n2 = 0;
            while (n2 < n) {
                ColorDefinition colorDef = colorDefinitionArray[n2];
                ThemeElementHelper.installColor(colorDef, theme, store, false);
                ++n2;
            }
        }
    }

    private static ColorDefinition[] getDefaults(ColorDefinition[] definitions) {
        IThemeRegistry registry = WorkbenchPlugin.getDefault().getThemeRegistry();
        ColorDefinition[] allDefs = registry.getColors();
        TreeSet<Object> set = new TreeSet<Object>(IThemeRegistry.ID_COMPARATOR);
        set.addAll(Arrays.asList(allDefs));
        set.removeAll(Arrays.asList(definitions));
        return set.toArray(new ColorDefinition[set.size()]);
    }

    private static FontDefinition[] getDefaults(FontDefinition[] definitions) {
        IThemeRegistry registry = WorkbenchPlugin.getDefault().getThemeRegistry();
        FontDefinition[] allDefs = registry.getFonts();
        TreeSet<Object> set = new TreeSet<Object>(IThemeRegistry.ID_COMPARATOR);
        set.addAll(Arrays.asList(allDefs));
        set.removeAll(Arrays.asList(definitions));
        return set.toArray(new FontDefinition[set.size()]);
    }

    private static ColorDefinition[] addDefaulted(ColorDefinition[] definitions) {
        IThemeRegistry registry = WorkbenchPlugin.getDefault().getThemeRegistry();
        IHierarchalThemeElementDefinition[] allDefs = registry.getColors();
        SortedSet set = ThemeElementHelper.addDefaulted(definitions, allDefs);
        return set.toArray(new ColorDefinition[set.size()]);
    }

    private static SortedSet addDefaulted(IHierarchalThemeElementDefinition[] definitions, IHierarchalThemeElementDefinition[] allDefs) {
        TreeSet<Object> set = new TreeSet<Object>(IThemeRegistry.ID_COMPARATOR);
        set.addAll(Arrays.asList(definitions));
        IHierarchalThemeElementDefinition[] copy = new IHierarchalThemeElementDefinition[allDefs.length];
        System.arraycopy(allDefs, 0, copy, 0, allDefs.length);
        Arrays.sort(allDefs, new IThemeRegistry.HierarchyComparator(copy));
        IHierarchalThemeElementDefinition[] iHierarchalThemeElementDefinitionArray = allDefs;
        int n = allDefs.length;
        int n2 = 0;
        while (n2 < n) {
            IHierarchalThemeElementDefinition def = iHierarchalThemeElementDefinitionArray[n2];
            if (def.getDefaultsTo() != null && set.contains(def.getDefaultsTo())) {
                set.add(def);
            }
            ++n2;
        }
        return set;
    }

    private static void installColor(ColorDefinition definition, ITheme theme, IPreferenceStore store, boolean setInRegistry) {
        RGB defaultColor;
        Assert.isNotNull((Object)store);
        ColorRegistry registry = theme.getColorRegistry();
        String id = definition.getId();
        String key = ThemeElementHelper.createPreferenceKey(theme, id);
        if (definition.getValue() != null) {
            defaultColor = definition.getValue();
        } else if (definition.getDefaultsTo() != null) {
            String defaultsToKey = ThemeElementHelper.createPreferenceKey(theme, definition.getDefaultsTo());
            defaultColor = PreferenceConverter.getDefaultColor((IPreferenceStore)store, (String)defaultsToKey);
        } else {
            defaultColor = PreferenceConverter.COLOR_DEFAULT_DEFAULT;
        }
        RGB prefColor = PreferenceConverter.getColor((IPreferenceStore)store, (String)key);
        if (prefColor == PreferenceConverter.COLOR_DEFAULT_DEFAULT || store.isDefault(key)) {
            if (definition.getValue() != null) {
                prefColor = definition.getValue();
            } else if (definition.getDefaultsTo() != null) {
                prefColor = registry.getRGB(definition.getDefaultsTo());
            }
        }
        if (prefColor == null || !definition.isEditable()) {
            prefColor = defaultColor;
        }
        if (store != null) {
            PreferenceConverter.setDefault((IPreferenceStore)store, (String)key, (RGB)defaultColor);
        }
        if (setInRegistry) {
            registry.put(id, prefColor);
        }
    }

    public static String createPreferenceKey(ITheme theme, String id) {
        String themeId = theme.getId();
        if (themeId.equals("org.eclipse.ui.defaultTheme")) {
            return id;
        }
        return themeId + "." + id;
    }

    public static String createPreferenceKey(org.eclipse.e4.ui.css.swt.theme.ITheme cssTheme, ITheme theme, String id) {
        String cssThemePrefix = cssTheme != null ? cssTheme.getId() + "." : "";
        return cssThemePrefix + ThemeElementHelper.createPreferenceKey(theme, id);
    }

    private ThemeElementHelper() {
    }
}

