/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.help.IContext;
import org.eclipse.help.IContextProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILazyTreeContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeAdapter;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.OpenAndLinkWithEditorHelper;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.StatusUtil;
import org.eclipse.ui.internal.views.markers.CachedMarkerBuilder;
import org.eclipse.ui.internal.views.markers.FiltersConfigurationDialog;
import org.eclipse.ui.internal.views.markers.MarkerCategory;
import org.eclipse.ui.internal.views.markers.MarkerColumnLabelProvider;
import org.eclipse.ui.internal.views.markers.MarkerContentGenerator;
import org.eclipse.ui.internal.views.markers.MarkerCopyHandler;
import org.eclipse.ui.internal.views.markers.MarkerEntry;
import org.eclipse.ui.internal.views.markers.MarkerFieldFilterGroup;
import org.eclipse.ui.internal.views.markers.MarkerResourceUtil;
import org.eclipse.ui.internal.views.markers.MarkerSupportInternalUtilities;
import org.eclipse.ui.internal.views.markers.MarkerSupportItem;
import org.eclipse.ui.internal.views.markers.MarkerViewerContentProvider;
import org.eclipse.ui.internal.views.markers.Markers;
import org.eclipse.ui.internal.views.markers.MarkersTreeViewer;
import org.eclipse.ui.internal.views.markers.UIUpdateJob;
import org.eclipse.ui.menus.IMenuService;
import org.eclipse.ui.operations.RedoActionHandler;
import org.eclipse.ui.operations.UndoActionHandler;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.ui.part.MarkerTransfer;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.views.WorkbenchViewerSetup;
import org.eclipse.ui.views.markers.MarkerField;
import org.eclipse.ui.views.markers.MarkerItem;
import org.eclipse.ui.views.markers.internal.ContentGeneratorDescriptor;
import org.eclipse.ui.views.markers.internal.MarkerGroup;
import org.eclipse.ui.views.markers.internal.MarkerMessages;
import org.eclipse.ui.views.markers.internal.MarkerSupportRegistry;

public class ExtendedMarkersView
extends ViewPart {
    public final Object MARKERSVIEW_UPDATE_JOB_FAMILY = new Object();
    static final String MARKER_FIELD = "MARKER_FIELD";
    private static int instanceCount = 1;
    private static final String TAG_GENERATOR = "markerContentGenerator";
    private static final String TAG_EXPANDED = "expanded";
    private static final String TAG_CATEGORY = "category";
    private static final String TAG_PART_NAME = "partName";
    private static final String TAG_COLUMN_WIDTHS = "columnWidths";
    private final IMarker[] noMarkers = new IMarker[0];
    private MarkerContentGenerator generator;
    private CachedMarkerBuilder builder;
    private Collection<String> categoriesToExpand;
    private UIUpdateJob uiUpdateJob;
    private MarkersTreeViewer viewer;
    private Action filterAction;
    private String customPartName;
    private boolean treePainted = false;
    private ISelectionListener pageSelectionListener;
    private IPartListener2 partListener;
    private Clipboard clipboard;
    private IMemento memento;
    private String[] defaultGeneratorIds = new String[0];
    private UndoActionHandler undoAction;
    private RedoActionHandler redoAction;
    private boolean isViewVisible = true;

    public ExtendedMarkersView(String contentGeneratorId) {
        this.defaultGeneratorIds = new String[]{contentGeneratorId};
    }

    private void addAllConcreteItems(MarkerSupportItem markerItem, Collection<MarkerSupportItem> allMarkers) {
        MarkerSupportItem[] children;
        if (markerItem.isConcrete()) {
            allMarkers.add(markerItem);
            return;
        }
        MarkerSupportItem[] markerSupportItemArray = children = markerItem.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            MarkerSupportItem element = markerSupportItemArray[n2];
            this.addAllConcreteItems(element, allMarkers);
            ++n2;
        }
    }

    void addExpandedCategory(MarkerCategory category) {
        this.getCategoriesToExpand().add(category.getName());
    }

    private void addMarkers(MarkerSupportItem markerItem, Collection<IMarker> allMarkers) {
        MarkerSupportItem[] children;
        if (markerItem.getMarker() != null) {
            allMarkers.add(markerItem.getMarker());
        }
        MarkerSupportItem[] markerSupportItemArray = children = markerItem.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            MarkerSupportItem element = markerSupportItemArray[n2];
            this.addMarkers(element, allMarkers);
            ++n2;
        }
    }

    private void createViewer(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.viewer = new MarkersTreeViewer(new Tree(parent, 66306));
        WorkbenchViewerSetup.setupViewer((ColumnViewer)this.viewer);
        this.viewer.getTree().setLinesVisible(true);
        this.viewer.setUseHashlookup(true);
        this.createColumns(new TreeColumn[0], new int[0]);
        this.viewer.setContentProvider(this.getContentProvider());
        this.viewer.getTree().addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                ExtendedMarkersView.this.treePainted = true;
                ExtendedMarkersView.this.viewer.getTree().removePaintListener((PaintListener)this);
            }
        });
    }

    private void createColumns(TreeColumn[] currentColumns, int[] widths) {
        Tree tree = this.viewer.getTree();
        TableLayout layout = new TableLayout();
        MarkerField[] fields = this.generator.getVisibleFields();
        int i = 0;
        while (i < fields.length) {
            MarkerField markerField = fields[i];
            TreeViewerColumn column = null;
            if (i < currentColumns.length) {
                column = new TreeViewerColumn((TreeViewer)this.viewer, currentColumns[i]);
            } else {
                column = new TreeViewerColumn((TreeViewer)this.viewer, 0);
                column.getColumn().setResizable(true);
                column.getColumn().setMoveable(true);
                column.getColumn().addSelectionListener(this.getHeaderListener());
            }
            column.getColumn().setData(MARKER_FIELD, (Object)markerField);
            column.setLabelProvider((CellLabelProvider)new MarkerColumnLabelProvider(markerField));
            column.getColumn().setText(markerField.getColumnHeaderText());
            column.getColumn().setToolTipText(markerField.getColumnTooltipText());
            column.getColumn().setImage(markerField.getColumnHeaderImage());
            EditingSupport support = markerField.getEditingSupport((ColumnViewer)this.viewer);
            if (support != null) {
                column.setEditingSupport(support);
            }
            if (this.builder.getPrimarySortField().equals(markerField)) {
                this.updateDirectionIndicator(column.getColumn(), markerField);
            }
            IMemento columnWidths = null;
            if (this.memento != null) {
                columnWidths = this.memento.getChild(TAG_COLUMN_WIDTHS);
            }
            int columnWidth = i < widths.length ? widths[i] : -1;
            columnWidth = this.getFieldWidth(markerField, columnWidth, false);
            if (columnWidths != null) {
                columnWidths.putInteger(markerField.getConfigurationElement().getAttribute("id"), columnWidth);
            }
            if (columnWidth < 0) {
                layout.addColumnData((ColumnLayoutData)new ColumnPixelData(markerField.getDefaultColumnWidth((Control)tree), true, true));
            } else {
                layout.addColumnData((ColumnLayoutData)new ColumnPixelData(columnWidth, true));
            }
            ++i;
        }
        if (currentColumns.length > fields.length) {
            i = fields.length;
            while (i < currentColumns.length) {
                currentColumns[i].dispose();
                ++i;
            }
        }
        this.viewer.getTree().setLayout((Layout)layout);
        tree.setLinesVisible(true);
        tree.setHeaderVisible(true);
        tree.requestLayout();
    }

    private void createFilterAction() {
        this.filterAction = new Action(MarkerMessages.configureFiltersCommand_title){

            public void run() {
                ExtendedMarkersView.this.openFiltersDialog();
            }
        };
        this.filterAction.setToolTipText(MarkerMessages.configureFiltersCommand_title);
        ImageDescriptor id = IDEWorkbenchPlugin.getIDEImageDescriptor("elcl16/filter_ps.svg");
        if (id != null) {
            this.filterAction.setImageDescriptor(id);
        }
    }

    int getFieldWidth(MarkerField markerField, int preferredWidth, boolean considerUIWidths) {
        Integer value;
        IMemento columnWidths;
        Tree tree = this.getViewer().getTree();
        if (considerUIWidths) {
            TreeColumn[] columns;
            TreeColumn[] treeColumnArray = columns = tree.getColumns();
            int n = columns.length;
            int n2 = 0;
            while (n2 < n) {
                TreeColumn column = treeColumnArray[n2];
                if (markerField.equals(column.getData(MARKER_FIELD))) {
                    return column.getWidth();
                }
                ++n2;
            }
        }
        if (preferredWidth < 0 && this.memento != null && (columnWidths = this.memento.getChild(TAG_COLUMN_WIDTHS)) != null && (value = columnWidths.getInteger(markerField.getConfigurationElement().getAttribute("id"))) != null && value >= 0) {
            preferredWidth = value;
        }
        if (preferredWidth <= 0) {
            GC gc = new GC((Drawable)tree);
            gc.setFont(tree.getFont());
            FontMetrics fontMetrics = gc.getFontMetrics();
            gc.dispose();
            preferredWidth = (int)Math.max((double)markerField.getDefaultColumnWidth((Control)tree), fontMetrics.getAverageCharacterWidth() * 5.0);
        }
        return preferredWidth;
    }

    public void createPartControl(Composite parent) {
        this.createViewer(parent);
        this.addDoubleClickListener();
        this.addPageAndPartSelectionListener();
        this.addLinkWithEditorSupport();
        this.addExpansionListener();
        this.addHelpListener();
        this.addSelectionListener();
        this.registerContextMenu();
        this.initDragAndDrop();
        this.initToolBar();
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        IUndoContext undoContext = this.getUndoContext();
        this.undoAction = new UndoActionHandler(this.getSite(), undoContext);
        this.undoAction.setActionDefinitionId("org.eclipse.ui.edit.undo");
        this.redoAction = new RedoActionHandler(this.getSite(), undoContext);
        this.redoAction.setActionDefinitionId("org.eclipse.ui.edit.redo");
        this.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.UNDO.getId(), (IAction)this.undoAction);
        this.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.REDO.getId(), (IAction)this.redoAction);
        this.startView();
    }

    private void startView() {
        this.viewer.setInput(this.builder.getMarkers());
        IContentProvider contentProvider = this.viewer.getContentProvider();
        Markers clone = this.createViewerInputClone();
        if (clone == null) {
            clone = this.builder.getMarkers().getClone();
        }
        contentProvider.inputChanged((Viewer)this.viewer, (Object)this.getViewerInput(), (Object)clone);
        this.builder.start();
    }

    private void addDoubleClickListener() {
        this.viewer.addDoubleClickListener(event -> {
            Object obj;
            ITreeSelection ss;
            ISelection selection = event.getSelection();
            if (selection instanceof ITreeSelection && (ss = (ITreeSelection)selection).size() == 1 && this.viewer.isExpandable(obj = ss.getFirstElement())) {
                this.viewer.setExpandedState(obj, !this.viewer.getExpandedState(obj));
            }
        });
    }

    private void addPageAndPartSelectionListener() {
        this.pageSelectionListener = new ViewerPageSelectionListener(this);
        this.getSite().getPage().addPostSelectionListener(this.pageSelectionListener);
        this.partListener = this.getPartListener();
        this.getSite().getPage().addPartListener(this.partListener);
        this.pageSelectionListener.selectionChanged(this.getSite().getPage().getActivePart(), this.getSite().getPage().getSelection());
    }

    private void addSelectionListener() {
        this.viewer.addSelectionChangedListener(event -> {
            ISelection selection = event.getSelection();
            if (selection instanceof IStructuredSelection) {
                this.updateStatusLine((IStructuredSelection)selection);
            }
        });
    }

    private void addHelpListener() {
        this.viewer.getControl().addHelpListener(e -> {
            IContextProvider provider = (IContextProvider)Adapters.adapt((Object)((Object)this), IContextProvider.class);
            if (provider == null) {
                return;
            }
            IContext context = provider.getContext((Object)this.viewer.getControl());
            PlatformUI.getWorkbench().getHelpSystem().displayHelp(context);
        });
    }

    private void addExpansionListener() {
        this.viewer.getTree().addTreeListener((TreeListener)new TreeAdapter(){

            public void treeCollapsed(TreeEvent e) {
                ExtendedMarkersView.this.removeExpandedCategory((MarkerCategory)e.item.getData());
            }

            public void treeExpanded(TreeEvent e) {
                ExtendedMarkersView.this.addExpandedCategory((MarkerCategory)e.item.getData());
            }
        });
    }

    private void addLinkWithEditorSupport() {
        new OpenAndLinkWithEditorHelper((StructuredViewer)this.viewer){

            protected void activate(ISelection selection) {
                int currentMode = OpenStrategy.getOpenMethod();
                try {
                    OpenStrategy.setOpenMethod((int)0);
                    ExtendedMarkersView.this.openSelectedMarkers();
                }
                finally {
                    OpenStrategy.setOpenMethod((int)currentMode);
                }
            }

            protected void linkToEditor(ISelection selection) {
            }

            protected void open(ISelection selection, boolean activate) {
                ExtendedMarkersView.this.openSelectedMarkers();
            }
        };
    }

    IMarker[] getOpenableMarkers() {
        HashSet<IMarker> result = new HashSet<IMarker>();
        for (Object o : this.viewer.getStructuredSelection()) {
            MarkerSupportItem next;
            if (!(o instanceof MarkerSupportItem) || !(next = (MarkerSupportItem)o).isConcrete()) continue;
            result.add(((MarkerEntry)next).getMarker());
        }
        if (result.isEmpty()) {
            return this.noMarkers;
        }
        IMarker[] markers = new IMarker[result.size()];
        result.toArray(markers);
        return markers;
    }

    void disableAllFilters() {
        this.generator.disableAllFilters();
    }

    public void dispose() {
        this.builder.cancelUpdate();
        this.cancelQueuedUpdates();
        this.builder.dispose();
        this.generator.dispose();
        if (instanceCount > 1) {
            --instanceCount;
        }
        if (this.clipboard != null) {
            this.clipboard.dispose();
        }
        this.getSite().getPage().removePostSelectionListener(this.pageSelectionListener);
        this.getSite().getPage().removePartListener(this.partListener);
        this.undoAction.dispose();
        this.redoAction.dispose();
        super.dispose();
    }

    MarkerSupportItem[] getAllConcreteItems() {
        MarkerSupportItem[] elements = this.getActiveViewerInputClone().getElements();
        ArrayList<MarkerSupportItem> allMarkers = new ArrayList<MarkerSupportItem>();
        MarkerSupportItem[] markerSupportItemArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            MarkerSupportItem element = markerSupportItemArray[n2];
            this.addAllConcreteItems(element, allMarkers);
            ++n2;
        }
        MarkerSupportItem[] markers = new MarkerSupportItem[allMarkers.size()];
        allMarkers.toArray(markers);
        return markers;
    }

    Collection<MarkerFieldFilterGroup> getAllFilters() {
        return this.generator.getAllFilters();
    }

    IMarker[] getAllMarkers() {
        MarkerSupportItem[] elements = this.getActiveViewerInputClone().getElements();
        ArrayList<IMarker> allMarkers = new ArrayList<IMarker>();
        MarkerSupportItem[] markerSupportItemArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            MarkerSupportItem element = markerSupportItemArray[n2];
            this.addMarkers(element, allMarkers);
            ++n2;
        }
        IMarker[] markers = new IMarker[allMarkers.size()];
        allMarkers.toArray(markers);
        return markers;
    }

    CachedMarkerBuilder getBuilder() {
        return this.builder;
    }

    Collection<String> getCategoriesToExpand() {
        if (this.categoriesToExpand == null) {
            IMemento expanded;
            this.categoriesToExpand = new HashSet<String>();
            if (this.memento != null && (expanded = this.memento.getChild(TAG_EXPANDED)) != null) {
                IMemento[] mementoCategories = expanded.getChildren(TAG_CATEGORY);
                MarkerCategory[] markerCategories = this.getActiveViewerInputClone().getCategories();
                if (markerCategories != null) {
                    MarkerCategory[] markerCategoryArray = markerCategories;
                    int n = markerCategories.length;
                    int n2 = 0;
                    while (n2 < n) {
                        MarkerCategory markerCategorie = markerCategoryArray[n2];
                        IMemento[] iMementoArray = mementoCategories;
                        int n3 = mementoCategories.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IMemento mementoCategorie = iMementoArray[n4];
                            if (markerCategorie.getName().equals(mementoCategorie.getID())) {
                                this.categoriesToExpand.add(markerCategorie.getName());
                            }
                            ++n4;
                        }
                        ++n2;
                    }
                }
            }
        }
        return this.categoriesToExpand;
    }

    MarkerGroup getCategoryGroup() {
        return this.builder.getCategoryGroup();
    }

    Clipboard getClipboard() {
        if (this.clipboard == null) {
            this.clipboard = new Clipboard(this.viewer.getControl().getDisplay());
        }
        return this.clipboard;
    }

    private IContentProvider getContentProvider() {
        return new MarkerViewerContentProvider(this);
    }

    private String getFieldId(TreeColumn treeColumn) {
        return ((MarkerField)treeColumn.getData(MARKER_FIELD)).getConfigurationElement().getAttribute("id");
    }

    String[] getGeneratorIds() {
        return this.defaultGeneratorIds;
    }

    private SelectionListener getHeaderListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeColumn column = (TreeColumn)e.widget;
                MarkerField field = (MarkerField)column.getData(ExtendedMarkersView.MARKER_FIELD);
                ExtendedMarkersView.this.setPrimarySortField(field, column);
            }
        };
    }

    private IPartListener2 getPartListener() {
        return new IPartListener2(){

            public void partActivated(IWorkbenchPartReference partRef) {
            }

            public void partBroughtToTop(IWorkbenchPartReference partRef) {
            }

            public void partClosed(IWorkbenchPartReference partRef) {
            }

            public void partDeactivated(IWorkbenchPartReference partRef) {
            }

            public void partHidden(IWorkbenchPartReference partRef) {
                if (!partRef.getId().equals(ExtendedMarkersView.this.getSite().getId())) {
                    return;
                }
                if (partRef.getPart(false) != ExtendedMarkersView.this) {
                    return;
                }
                ExtendedMarkersView.this.isViewVisible = false;
                Markers markers = ExtendedMarkersView.this.getActiveViewerInputClone();
                Integer[] counts = markers.getMarkerCounts();
                ExtendedMarkersView.this.setTitleToolTip(ExtendedMarkersView.this.getStatusMessage(markers, counts));
            }

            public void partInputChanged(IWorkbenchPartReference partRef) {
            }

            public void partOpened(IWorkbenchPartReference partRef) {
            }

            public void partVisible(IWorkbenchPartReference partRef) {
                if (!partRef.getId().equals(ExtendedMarkersView.this.getSite().getId())) {
                    return;
                }
                if (partRef.getPart(false) != ExtendedMarkersView.this) {
                    return;
                }
                ExtendedMarkersView.this.isViewVisible = true;
                boolean needUpdate = this.hasPendingChanges();
                if (needUpdate) {
                    ExtendedMarkersView.this.builder.getUpdateScheduler().scheduleUIUpdate(150L);
                } else {
                    ExtendedMarkersView.this.setTitleToolTip(null);
                }
            }

            private boolean hasPendingChanges() {
                boolean[] changeFlags;
                boolean[] blArray = changeFlags = ExtendedMarkersView.this.builder.readChangeFlags();
                int n = changeFlags.length;
                int n2 = 0;
                while (n2 < n) {
                    boolean b = blArray[n2];
                    if (b) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }
        };
    }

    public IMarker[] getSelectedMarkers() {
        ITreeSelection structured = this.viewer.getStructuredSelection();
        ArrayList<IMarker> result = new ArrayList<IMarker>(structured.size());
        MarkerCategory lastCategory = null;
        for (Object item : structured) {
            MarkerEntry[] children;
            if (!(item instanceof MarkerSupportItem)) continue;
            MarkerSupportItem next = (MarkerSupportItem)item;
            if (next.isConcrete()) {
                if (lastCategory != null && lastCategory == next.getParent()) continue;
                result.add(next.getMarker());
                continue;
            }
            lastCategory = (MarkerCategory)next;
            MarkerEntry[] markerEntryArray = children = (MarkerEntry[])lastCategory.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                MarkerEntry element = markerEntryArray[n2];
                result.add(element.getMarker());
                ++n2;
            }
        }
        return result.toArray(new IMarker[result.size()]);
    }

    public boolean getSortAscending() {
        return this.viewer.getTree().getSortDirection() == 128;
    }

    private String getStatusMessage(Markers markers, Integer[] counts) {
        String status = "";
        int totalCount = CachedMarkerBuilder.getTotalMarkerCount(markers);
        int filteredCount = 0;
        boolean markerLimitsEnabled = this.generator.isMarkerLimitsEnabled();
        int markerLimit = this.generator.getMarkerLimits();
        MarkerCategory[] categories = markers.getCategories();
        if (categories != null && this.builder.isShowingHierarchy()) {
            MarkerCategory[] markerCategoryArray = categories;
            int n = categories.length;
            int n2 = 0;
            while (n2 < n) {
                MarkerCategory categorie = markerCategoryArray[n2];
                int childCount = ((MarkerSupportItem)categorie).getChildrenCount();
                if (markerLimitsEnabled) {
                    childCount = Math.min(childCount, markerLimit);
                }
                filteredCount += childCount;
                ++n2;
            }
        } else {
            filteredCount = markerLimitsEnabled ? markerLimit : -1;
        }
        if (counts[0] == 0 && counts[1] == 0) {
            status = filteredCount < 0 || filteredCount >= totalCount ? NLS.bind((String)MarkerMessages.filter_itemsMessage, (Object)totalCount) : NLS.bind((String)MarkerMessages.filter_matchedMessage, (Object)filteredCount, (Object)totalCount);
            return status;
        }
        String message = MessageFormat.format(MarkerMessages.errorsAndWarningsSummaryBreakdown, counts[0], counts[1], counts[2] + counts[3]);
        if (filteredCount < 0 || filteredCount >= totalCount) {
            return message;
        }
        return NLS.bind((String)MarkerMessages.problem_filter_matchedMessage, (Object[])new Serializable[]{message, Integer.valueOf(filteredCount), Integer.valueOf(totalCount)});
    }

    Markers getViewerInput() {
        return (Markers)this.viewer.getInput();
    }

    Markers getActiveViewerInputClone() {
        return this.builder.getClonedMarkers();
    }

    Markers createViewerInputClone() {
        return this.builder.createMarkersClone();
    }

    MarkerField[] getVisibleFields() {
        return this.generator.getVisibleFields();
    }

    public void init(IViewSite site, IMemento m) throws PartInitException {
        super.init(site, m);
        ContentGeneratorDescriptor generatorDescriptor = null;
        if (m != null) {
            generatorDescriptor = MarkerSupportRegistry.getInstance().getContentGenDescriptor(m.getString(TAG_GENERATOR));
        }
        if (generatorDescriptor == null && this.defaultGeneratorIds.length > 0 && (generatorDescriptor = MarkerSupportRegistry.getInstance().getContentGenDescriptor(this.defaultGeneratorIds[0])) == null) {
            this.logInvalidGenerator(this.defaultGeneratorIds[0]);
        }
        if (generatorDescriptor == null) {
            generatorDescriptor = MarkerSupportRegistry.getInstance().getDefaultContentGenDescriptor();
        }
        this.builder = new CachedMarkerBuilder(this);
        this.generator = new MarkerContentGenerator(generatorDescriptor, this.builder, this.getViewsEffectiveId());
        this.generator.restoreState(m);
        IMenuService menuService = (IMenuService)site.getService(IMenuService.class);
        menuService.populateContributionManager((ContributionManager)site.getActionBars().getMenuManager(), "menu:org.eclipse.ui.ide.MarkersView");
        menuService.populateContributionManager((ContributionManager)site.getActionBars().getToolBarManager(), "toolbar:org.eclipse.ui.ide.MarkersView");
        this.builder.restoreState(m);
        IWorkbenchSiteProgressService service = (IWorkbenchSiteProgressService)Adapters.adapt((Object)site, IWorkbenchSiteProgressService.class);
        if (service != null) {
            this.builder.setProgressService(service);
        }
        this.memento = m;
        if (m == null || m.getString(TAG_PART_NAME) == null) {
            return;
        }
        this.initializeTitle(m.getString(TAG_PART_NAME));
    }

    String getViewsEffectiveId() {
        IViewSite site = (IViewSite)this.getSite();
        Object viewId = site.getId();
        if (site.getSecondaryId() != null) {
            viewId = (String)viewId + site.getSecondaryId();
        }
        return viewId;
    }

    String getViewsPrimaryId() {
        IViewSite site = (IViewSite)this.getSite();
        return site.getId();
    }

    String getViewsSecondaryId() {
        IViewSite site = (IViewSite)this.getSite();
        return site.getSecondaryId();
    }

    void initializeTitle(String name) {
        this.customPartName = name;
        this.setPartName(name);
    }

    boolean isEnabled(MarkerFieldFilterGroup group) {
        return this.generator.getEnabledFilters().contains(group);
    }

    boolean isPrimarySortField(MarkerField field) {
        return this.builder.getPrimarySortField().equals(field);
    }

    boolean isShowing(MarkerContentGenerator markerGenerator) {
        return markerGenerator != null ? markerGenerator.equals(this.generator) : false;
    }

    MarkerContentGenerator getGenerator() {
        return this.generator;
    }

    void logInvalidGenerator(String id) {
        StatusManager.getManager().handle((IStatus)new Status(2, "org.eclipse.ui.ide", NLS.bind((String)"Invalid markerContentGenerator {0} ", (Object)id)));
    }

    protected FiltersConfigurationDialog createFilterConfigurationDialog(MarkerContentGenerator gen) {
        FiltersConfigurationDialog dialog = new FiltersConfigurationDialog(this.getSite().getWorkbenchWindow().getShell(), gen);
        return dialog;
    }

    void openFiltersDialog() {
        FiltersConfigurationDialog dialog = this.createFilterConfigurationDialog(this.generator);
        if (dialog.open() == 0) {
            this.generator.updateFilters(dialog.getFilters(), dialog.andFilters());
        }
    }

    protected void openSelectedMarkers() {
        IMarker[] markers;
        IMarker[] iMarkerArray = markers = this.getOpenableMarkers();
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            IWorkbenchPage page = this.getSite().getPage();
            ExtendedMarkersView.openMarkerInEditor(marker, page);
            ++n2;
        }
    }

    public boolean isFilterEnabled() {
        return this.generator != null && this.generator.getEnabledFilters().size() > 0;
    }

    public boolean isMarkerLimitsEnabled() {
        return this.generator != null && this.generator.isMarkerLimitsEnabled();
    }

    void reexpandCategories() {
        if (!this.getCategoriesToExpand().isEmpty() && this.builder.isShowingHierarchy()) {
            MarkerSupportItem[] items = this.getActiveViewerInputClone().getElements();
            IContentProvider provider = this.viewer.getContentProvider();
            int i = 0;
            while (i < items.length) {
                String name = ((MarkerCategory)items[i]).getName();
                if (this.getCategoriesToExpand().contains(name)) {
                    if (provider instanceof ILazyTreeContentProvider) {
                        ((ILazyTreeContentProvider)provider).updateElement((Object)this.builder.getMarkers(), i);
                        this.viewer.setExpandedState(items[i], true);
                    } else if (!this.viewer.getExpandedState(items[i])) {
                        this.viewer.expandToLevel(items[i], 2);
                    }
                }
                ++i;
            }
        }
    }

    private void registerContextMenu() {
        MenuManager contextMenu = new MenuManager();
        contextMenu.setRemoveAllWhenShown(true);
        this.getSite().registerContextMenu(contextMenu, (ISelectionProvider)this.viewer);
        if (!this.getSite().getId().equals("org.eclipse.ui.ide.MarkersView")) {
            this.getSite().registerContextMenu("org.eclipse.ui.ide.MarkersView", contextMenu, (ISelectionProvider)this.viewer);
        }
        Control control = this.viewer.getControl();
        Menu menu = contextMenu.createContextMenu(control);
        control.setMenu(menu);
    }

    void removeExpandedCategory(MarkerCategory category) {
        this.getCategoriesToExpand().remove(category.getName());
    }

    public void saveState(IMemento m) {
        super.saveState(m);
        if (this.customPartName != null) {
            m.putString(TAG_PART_NAME, this.customPartName);
        }
        if (this.generator != null) {
            m.putString(TAG_GENERATOR, this.builder.getGenerator().getId());
        }
        if (!this.getCategoriesToExpand().isEmpty()) {
            IMemento expanded = m.createChild(TAG_EXPANDED);
            Iterator<String> categories = this.getCategoriesToExpand().iterator();
            while (categories.hasNext()) {
                expanded.createChild(TAG_CATEGORY, categories.next());
            }
        }
        IMemento columnEntry = m.createChild(TAG_COLUMN_WIDTHS);
        MarkerField[] fields = new MarkerField[this.viewer.getTree().getColumnCount()];
        int[] positions = this.viewer.getTree().getColumnOrder();
        int i = 0;
        while (i < fields.length) {
            TreeColumn column = this.viewer.getTree().getColumn(i);
            MarkerField markerField = (MarkerField)column.getData(MARKER_FIELD);
            int width = this.getFieldWidth(markerField, -1, this.treePainted);
            columnEntry.putInteger(this.getFieldId(column), width);
            fields[positions[i]] = markerField;
            ++i;
        }
        if (this.generator != null) {
            this.generator.saveState(m, fields);
        }
        this.builder.saveState(m);
    }

    void selectAll() {
        this.viewer.getTree().selectAll();
    }

    void setCategoryGroup(MarkerGroup group) {
        this.getCategoriesToExpand().clear();
        this.builder.setCategoryGroup(group);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    void setPrimarySortField(MarkerField field) {
        TreeColumn[] columns;
        TreeColumn[] treeColumnArray = columns = this.viewer.getTree().getColumns();
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            TreeColumn treeColumn = treeColumnArray[n2];
            if (treeColumn.getData(MARKER_FIELD).equals(field)) {
                this.setPrimarySortField(field, treeColumn);
                return;
            }
            ++n2;
        }
        StatusManager.getManager().handle(StatusUtil.newStatus(2, "Sorting by non visible field " + field.getName(), null));
    }

    private void setPrimarySortField(MarkerField field, TreeColumn column) {
        this.builder.setPrimarySortField(field);
        IWorkbenchSiteProgressService service = (IWorkbenchSiteProgressService)Adapters.adapt((Object)this.getViewSite(), IWorkbenchSiteProgressService.class);
        this.builder.refreshContents(service);
        this.updateDirectionIndicator(column, field);
    }

    void setSelection(StructuredSelection structuredSelection, boolean reveal) {
        ArrayList<MarkerItem> newSelection = new ArrayList<MarkerItem>(structuredSelection.size());
        for (Object next : structuredSelection) {
            MarkerItem marker;
            if (!(next instanceof IMarker) || (marker = this.builder.getMarkers().getMarkerItem((IMarker)next)) == null) continue;
            newSelection.add(marker);
        }
        StructuredSelection structured = new StructuredSelection(newSelection);
        this.viewer.setSelection((ISelection)structured, reveal);
        this.updateStatusLine((IStructuredSelection)structured);
    }

    void toggleFilter(MarkerFieldFilterGroup group) {
        this.generator.toggleFilter(group);
    }

    void toggleSortDirection() {
        this.setPrimarySortField(this.builder.getPrimarySortField());
    }

    void updateDirectionIndicator(TreeColumn column, MarkerField field) {
        this.viewer.getTree().setSortColumn(column);
        if (this.builder.getSortDirection(field) == 1) {
            this.viewer.getTree().setSortDirection(128);
        } else {
            this.viewer.getTree().setSortDirection(1024);
        }
    }

    void updateStatusLine(IStructuredSelection newSelection) {
        String message = null;
        if (newSelection == null || newSelection.isEmpty()) {
            message = "";
        } else if (newSelection.size() == 1) {
            Object object = newSelection.getFirstElement();
            if (object instanceof MarkerSupportItem) {
                MarkerSupportItem element = (MarkerSupportItem)object;
                message = element.getDescription();
            }
        } else {
            Iterator elements = newSelection.iterator();
            ArrayList<MarkerSupportItem> result = new ArrayList<MarkerSupportItem>();
            while (elements.hasNext()) {
                MarkerSupportItem next;
                Object e = elements.next();
                if (!(e instanceof MarkerSupportItem) || !(next = (MarkerSupportItem)e).isConcrete()) continue;
                result.add(next);
            }
            MarkerEntry[] entries = new MarkerEntry[result.size()];
            result.toArray(entries);
            message = this.getStatusSummary(entries);
        }
        this.getViewSite().getActionBars().getStatusLineManager().setMessage(message);
    }

    private String getStatusSummary(MarkerEntry[] entries) {
        Integer[] counts = Markers.getMarkerCounts(entries);
        if (counts[0] == 0 && counts[1] == 0) {
            return MessageFormat.format(MarkerMessages.marker_statusSelectedCount, entries.length);
        }
        return MessageFormat.format(MarkerMessages.marker_statusSummarySelected, entries.length, MessageFormat.format(MarkerMessages.errorsAndWarningsSummaryBreakdown, counts[0], counts[1], counts[2] + counts[3]));
    }

    void updateTitle() {
        Markers markers = this.getActiveViewerInputClone();
        Integer[] counts = markers.getMarkerCounts();
        String statusMessage = this.getStatusMessage(markers, counts);
        this.setContentDescription(statusMessage);
        if (this.isVisible()) {
            this.setTitleToolTip(null);
        } else {
            this.setTitleToolTip(statusMessage);
        }
        this.updateTitleImage(counts);
    }

    void updateTitleImage(Integer[] counts) {
    }

    private void initDragAndDrop() {
        int operations = 1;
        Transfer[] transferTypes = new Transfer[]{MarkerTransfer.getInstance(), TextTransfer.getInstance()};
        DragSourceAdapter listener = new DragSourceAdapter(){

            public void dragSetData(DragSourceEvent event) {
                ExtendedMarkersView.this.performDragSetData(event);
            }

            public void dragFinished(DragSourceEvent event) {
            }
        };
        this.viewer.addDragSupport(operations, transferTypes, (DragSourceListener)listener);
    }

    private void initToolBar() {
        IActionBars bars = this.getViewSite().getActionBars();
        IToolBarManager tm = bars.getToolBarManager();
        this.createFilterAction();
        tm.add((IContributionItem)new Separator("FilterGroup"));
        tm.add((IAction)this.filterAction);
    }

    private void performDragSetData(DragSourceEvent event) {
        IMarker[] markers;
        if (MarkerTransfer.getInstance().isSupportedType(event.dataType)) {
            event.data = this.getSelectedMarkers();
            return;
        }
        if (TextTransfer.getInstance().isSupportedType(event.dataType) && (markers = this.getSelectedMarkers()) != null) {
            event.data = MarkerCopyHandler.createMarkerReport(this, markers);
        }
    }

    Object[] getHiddenFields() {
        return this.generator.getHiddenFields();
    }

    void setVisibleFields(Collection<MarkerField> visible, int[] widths) {
        this.generator.setVisibleFields(visible);
        this.createColumns(this.viewer.getTree().getColumns(), widths);
        this.scheduleUpdate(0L);
    }

    TreeViewer getViewer() {
        return this.viewer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancelQueuedUpdates() {
        Object object = this.builder.getUpdateScheduler().getSchedulingLock();
        synchronized (object) {
            if (this.uiUpdateJob != null) {
                this.uiUpdateJob.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    UIUpdateJob scheduleUpdate(long delay) {
        Object object = this.builder.getUpdateScheduler().getSchedulingLock();
        synchronized (object) {
            IWorkbenchSiteProgressService progressService;
            if (this.uiUpdateJob == null) {
                this.uiUpdateJob = new UIUpdateJob(this);
                this.uiUpdateJob.setSystem(true);
            }
            if ((progressService = this.builder.getProgressService()) != null) {
                progressService.schedule((Job)this.uiUpdateJob, delay);
            } else {
                this.uiUpdateJob.schedule(delay);
            }
            return this.uiUpdateJob;
        }
    }

    long getLastUIRefreshTime() {
        if (this.uiUpdateJob != null) {
            return this.uiUpdateJob.getLastUpdateTime();
        }
        return -1L;
    }

    boolean isUIUpdating() {
        return this.uiUpdateJob != null ? this.uiUpdateJob.isUpdating() : false;
    }

    static String newSecondaryID(IViewPart part) {
        while (part.getSite().getPage().findViewReference(part.getSite().getId(), String.valueOf(instanceCount)) != null) {
            ++instanceCount;
        }
        return String.valueOf(instanceCount);
    }

    public static void openMarkerInEditor(IMarker marker, IWorkbenchPage page) {
        IEditorInput input;
        IFile file;
        IEditorPart editor = page.getActiveEditor();
        if (editor != null && (file = ResourceUtil.getFile(input = editor.getEditorInput())) != null && marker.getResource().equals((Object)file) && OpenStrategy.activateOnOpen()) {
            page.activate((IWorkbenchPart)editor);
        }
        if (marker != null && marker.getResource() instanceof IFile) {
            try {
                if (IDE.openEditor(page, marker, OpenStrategy.activateOnOpen()) != null) {
                    return;
                }
            }
            catch (PartInitException e) {
                MarkerSupportInternalUtilities.showViewError((Exception)((Object)e));
            }
        }
        ExtendedMarkersView.showIn(marker, page, page.getPerspective().getDefaultShowIn());
    }

    private static boolean showIn(IMarker marker, IWorkbenchPage page, String targetPartId) {
        ISetSelectionTarget target;
        StructuredSelection selection;
        block6: {
            IViewPart view;
            block5: {
                if (targetPartId == null || WorkbenchPlugin.getDefault().getViewRegistry().find(targetPartId) == null) {
                    return false;
                }
                selection = new StructuredSelection((Object)marker.getResource());
                try {
                    view = page.showView(targetPartId);
                    if (view != null) break block5;
                    return false;
                }
                catch (PartInitException e) {
                    MarkerSupportInternalUtilities.showViewError((Exception)((Object)e));
                    return false;
                }
            }
            target = (ISetSelectionTarget)Adapters.adapt((Object)view, ISetSelectionTarget.class);
            if (target != null) break block6;
            return false;
        }
        target.selectReveal((ISelection)selection);
        ((WorkbenchPage)page).performedShowIn(targetPartId);
        return true;
    }

    protected boolean isProjectNestingActive(IWorkbenchPart part) {
        return false;
    }

    protected IUndoContext getUndoContext() {
        return (IUndoContext)Adapters.adapt((Object)ResourcesPlugin.getWorkspace(), IUndoContext.class);
    }

    protected String getDeleteOperationName(IMarker[] markers) {
        Assert.isLegal((markers.length > 0 ? 1 : 0) != 0);
        return markers.length == 1 ? MarkerMessages.deleteMarker_operationName : MarkerMessages.deleteMarkers_operationName;
    }

    boolean isVisible() {
        return this.isViewVisible;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == MarkersTreeViewer.class) {
            return adapter.cast((Object)this.viewer);
        }
        return (T)super.getAdapter(adapter);
    }

    private class ViewerPageSelectionListener
    implements ISelectionListener {
        private final ExtendedMarkersView view;

        ViewerPageSelectionListener(ExtendedMarkersView view) {
            this.view = view;
        }

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            if (part == ExtendedMarkersView.this) {
                return;
            }
            ArrayList<Object> objectsToAdapt = new ArrayList<Object>();
            if (part instanceof IEditorPart) {
                IEditorPart editor = (IEditorPart)part;
                objectsToAdapt.add(editor.getEditorInput());
            } else if (selection instanceof IStructuredSelection) {
                for (Object object : (IStructuredSelection)selection) {
                    objectsToAdapt.add(object);
                }
            }
            LinkedHashSet<Object> selectedElements = new LinkedHashSet<Object>();
            for (Object e : objectsToAdapt) {
                Object resElement = MarkerResourceUtil.adapt2ResourceElement(e);
                if (resElement == null) continue;
                selectedElements.add(resElement);
            }
            if (ExtendedMarkersView.this.isProjectNestingActive(part)) {
                List<IProject> list = selectedElements.stream().filter(IProject.class::isInstance).map(IProject.class::cast).toList();
                if (!list.isEmpty()) {
                    selectedElements.addAll(MarkerResourceUtil.getNestedChildProjects(list));
                }
            }
            MarkerContentGenerator markerContentGenerator = this.view.getGenerator();
            markerContentGenerator.updateSelectedResource(selectedElements.toArray(), part == null);
        }
    }
}

