/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.ui.views;

import java.util.Locale;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.ext.mysql.ui.internal.MySQLUIMessages;
import org.jkiss.dbeaver.ext.mysql.ui.views.MySQLConnectionPageAdvanced;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.connection.DBPDriverConfigurationType;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.IDialogPageProvider;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageAbstract;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageWithAuth;
import org.jkiss.dbeaver.ui.dialogs.connection.DriverPropertiesDialogPage;
import org.jkiss.dbeaver.ui.internal.UIConnectionMessages;
import org.jkiss.utils.CommonUtils;

public class MySQLConnectionPage
extends ConnectionPageWithAuth
implements IDialogPageProvider {
    private Text urlText;
    private Text hostText;
    private Text portText;
    private Text dbText;
    private Button showAllDatabases;
    private boolean activated = false;
    private final Image LOGO_MYSQL = this.createImage("icons/mysql_logo.png");
    private final Image LOGO_MARIADB = this.createImage("icons/mariadb_logo.png");
    private boolean needsPort;

    public void dispose() {
        super.dispose();
        UIUtils.dispose((Resource)this.LOGO_MYSQL);
        UIUtils.dispose((Resource)this.LOGO_MARIADB);
    }

    public Image getImage() {
        DBPDriver driver = this.getSite().getDriver();
        DBPImage logoImage = driver.getLogoImage();
        if (logoImage != null) {
            return DBeaverIcons.getImage((DBPImage)logoImage);
        }
        if (driver.getId().equalsIgnoreCase("mariaDB")) {
            return this.LOGO_MARIADB;
        }
        return this.LOGO_MYSQL;
    }

    public void createControl(Composite composite) {
        ModifyListener textListener = e -> {
            if (this.activated) {
                this.updateUrl();
                this.site.updateButtons();
            }
        };
        Composite addrGroup = new Composite(composite, 0);
        addrGroup.setLayout((Layout)new GridLayout(1, false));
        GridData gd = new GridData(1808);
        addrGroup.setLayoutData((Object)gd);
        Composite serverGroup = UIUtils.createTitledComposite((Composite)addrGroup, (String)UIConnectionMessages.dialog_connection_server_label, (int)4, (int)768);
        SelectionAdapter typeSwitcher = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MySQLConnectionPage.this.setupConnectionModeSelection(MySQLConnectionPage.this.urlText, MySQLConnectionPage.this.typeURLRadio.getSelection(), GROUP_CONNECTION_ARR);
                MySQLConnectionPage.this.updateUrl();
            }
        };
        this.createConnectionModeSwitcher(serverGroup, (SelectionListener)typeSwitcher);
        UIUtils.createControlLabel((Composite)serverGroup, (String)UIConnectionMessages.dialog_connection_url_label);
        this.urlText = new Text(serverGroup, 2048);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 355;
        this.urlText.setLayoutData((Object)gd);
        this.urlText.addModifyListener(e -> this.site.updateButtons());
        DBPDriver driver = this.getSite().getDriver();
        this.needsPort = CommonUtils.getBoolean((Object)driver.getDriverParameter("needsPort"), (boolean)true);
        Label hostLabel = UIUtils.createControlLabel((Composite)serverGroup, (String)(this.needsPort ? MySQLUIMessages.dialog_connection_host : MySQLUIMessages.dialog_connection_instance));
        this.hostText = new Text(serverGroup, 2048);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        this.hostText.setLayoutData((Object)gd);
        UIUtils.setDefaultTextControlWidthHint((Control)this.hostText);
        this.hostText.addModifyListener(textListener);
        this.addControlToGroup("connection", new Control[]{hostLabel, this.hostText});
        if (this.needsPort) {
            Label portLabel = UIUtils.createControlLabel((Composite)serverGroup, (String)MySQLUIMessages.dialog_connection_port);
            this.portText = new Text(serverGroup, 2048);
            gd = new GridData(2);
            gd.widthHint = UIUtils.getFontHeight((Control)this.portText) * 10;
            this.portText.addVerifyListener(UIUtils.getIntegerVerifyListener((Locale)Locale.getDefault()));
            this.portText.addModifyListener(textListener);
            this.addControlToGroup("connection", new Control[]{portLabel, this.portText});
        } else {
            gd.horizontalSpan = 3;
        }
        Label dbLabel = UIUtils.createControlLabel((Composite)serverGroup, (String)MySQLUIMessages.dialog_connection_database);
        this.dbText = new Text(serverGroup, 2048);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        this.dbText.setLayoutData((Object)gd);
        UIUtils.setDefaultTextControlWidthHint((Control)this.dbText);
        this.dbText.addModifyListener(textListener);
        this.addControlToGroup("connection", new Control[]{dbLabel, this.dbText});
        this.showAllDatabases = UIUtils.createCheckbox((Composite)serverGroup, (String)MySQLUIMessages.dialog_connection_show_all_databases, (String)MySQLUIMessages.dialog_connection_show_all_databases_tip, (boolean)false, (int)2);
        this.createAuthPanel(addrGroup, 1);
        this.createDriverPanel(addrGroup);
        this.setControl((Control)addrGroup);
    }

    private void updateUrl() {
        DBPDataSourceContainer dataSourceContainer = this.site.getActiveDataSource();
        this.saveSettings(dataSourceContainer);
        if (this.typeURLRadio != null && this.typeURLRadio.getSelection()) {
            this.urlText.setText(dataSourceContainer.getConnectionConfiguration().getUrl());
        } else {
            this.urlText.setText(dataSourceContainer.getDriver().getConnectionURL(this.site.getActiveDataSource().getConnectionConfiguration()));
        }
    }

    public boolean isComplete() {
        if (this.isCustomURL()) {
            return !CommonUtils.isEmpty((String)this.urlText.getText());
        }
        return super.isComplete() && this.hostText != null && !CommonUtils.isEmpty((String)this.hostText.getText()) && (!this.needsPort || !CommonUtils.isEmpty((String)this.portText.getText()));
    }

    public void loadSettings() {
        boolean useURL;
        DBPConnectionConfiguration connectionInfo = this.site.getActiveDataSource().getConnectionConfiguration();
        super.loadSettings();
        if (this.hostText != null) {
            if (!CommonUtils.isEmpty((String)connectionInfo.getHostName())) {
                this.hostText.setText(connectionInfo.getHostName());
            } else {
                this.hostText.setText(CommonUtils.toString((Object)this.site.getDriver().getDefaultHost(), (String)"localhost"));
            }
        }
        if (this.portText != null) {
            if (!CommonUtils.isEmpty((String)connectionInfo.getHostPort())) {
                this.portText.setText(connectionInfo.getHostPort());
            } else if (this.site.getDriver().getDefaultPort() != null) {
                this.portText.setText(this.site.getDriver().getDefaultPort());
            } else {
                this.portText.setText("");
            }
        }
        if (this.dbText != null) {
            this.dbText.setText(CommonUtils.toString((Object)connectionInfo.getDatabaseName(), (String)CommonUtils.notEmpty((String)this.site.getDriver().getDefaultDatabase())));
        }
        if (this.showAllDatabases != null) {
            this.showAllDatabases.setSelection(CommonUtils.getBoolean((String)connectionInfo.getProviderProperty("@dbeaver-show-all-dbs@"), (boolean)true));
        }
        boolean bl = useURL = connectionInfo.getConfigurationType() == DBPDriverConfigurationType.URL;
        if (useURL) {
            this.urlText.setText(connectionInfo.getUrl());
        }
        this.setupConnectionModeSelection(this.urlText, useURL, GROUP_CONNECTION_ARR);
        this.updateUrl();
        this.activated = true;
    }

    public void saveSettings(DBPDataSourceContainer dataSource) {
        DBPConnectionConfiguration connectionInfo = dataSource.getConnectionConfiguration();
        if (this.typeURLRadio != null) {
            connectionInfo.setConfigurationType(this.typeURLRadio.getSelection() ? DBPDriverConfigurationType.URL : DBPDriverConfigurationType.MANUAL);
        }
        if (this.hostText != null) {
            connectionInfo.setHostName(this.hostText.getText().trim());
        }
        if (this.portText != null) {
            connectionInfo.setHostPort(this.portText.getText().trim());
        }
        if (this.dbText != null) {
            connectionInfo.setDatabaseName(this.dbText.getText().trim());
        }
        if (this.showAllDatabases != null) {
            connectionInfo.setProviderProperty("@dbeaver-show-all-dbs@", String.valueOf(this.showAllDatabases.getSelection()));
        }
        if (this.typeURLRadio != null && this.typeURLRadio.getSelection()) {
            connectionInfo.setUrl(this.urlText.getText());
        }
        super.saveSettings(dataSource);
    }

    public IDialogPage[] getDialogPages(boolean extrasOnly, boolean forceCreate) {
        return new IDialogPage[]{new MySQLConnectionPageAdvanced(), new DriverPropertiesDialogPage((ConnectionPageAbstract)this)};
    }
}

