/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.actions;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.jface.dialogs.IPageChangeProvider;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPContextProvider;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceContainerProvider;
import org.jkiss.dbeaver.model.DBPDataSourceProvider;
import org.jkiss.dbeaver.model.DBPDataSourceProviderSynchronizable;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCSavepoint;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.exec.DBCTransactionManager;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.qm.QMExecutionHandler;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.IPluginService;
import org.jkiss.dbeaver.runtime.qm.DefaultExecutionHandler;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.ISmartTransactionManager;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.EditorUtils;
import org.jkiss.dbeaver.ui.editors.IStatefulEditor;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class DataSourcePropertyTester
extends PropertyTester {
    protected static final Log log = Log.getLog(DataSourcePropertyTester.class);
    public static final String NAMESPACE = "org.jkiss.dbeaver.core.datasource";
    public static final String PROP_CONNECTED = "connected";
    public static final String PROP_CONNECTING = "connecting";
    public static final String PROP_TRANSACTIONAL = "transactional";
    public static final String PROP_SYNCHRONIZABLE = "synchronizable";
    public static final String PROP_SUPPORTS_TRANSACTIONS = "supportsTransactions";
    public static final String PROP_TRANSACTION_ACTIVE = "transactionActive";
    public static final String PROP_EDITABLE = "editable";
    public static final String PROP_PROJECT_RESOURCE_EDITABLE = "projectResourceEditable";
    public static final String PROP_PROJECT_RESOURCE_VIEWABLE = "projectResourceViewable";

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        try {
            void contextProvider;
            while (receiver instanceof DBNDatabaseNode) {
                DBNDatabaseNode node = (DBNDatabaseNode)receiver;
                if (receiver instanceof DBNDataSource) break;
                receiver = node.getParentNode();
            }
            if (!(receiver instanceof DBPContextProvider)) {
                return false;
            }
            DBPContextProvider dBPContextProvider = (DBPContextProvider)receiver;
            DBCExecutionContext context = contextProvider.getExecutionContext();
            switch (property) {
                case "connected": {
                    DBPDataSourceContainerProvider containerProvider;
                    DBPDataSourceContainer container;
                    boolean isConnected = context != null ? context.getDataSource().getContainer().isConnected() : (receiver instanceof DBPDataSourceContainerProvider ? (container = (containerProvider = (DBPDataSourceContainerProvider)receiver).getDataSourceContainer()) != null && container.isConnected() : false);
                    boolean checkConnected = Boolean.TRUE.equals(expectedValue);
                    return checkConnected == isConnected;
                }
                case "connecting": {
                    if (!(receiver instanceof DBPDataSourceContainerProvider)) {
                        return false;
                    }
                    DBPDataSourceContainerProvider containerProvider = (DBPDataSourceContainerProvider)receiver;
                    DBPDataSourceContainer container = containerProvider.getDataSourceContainer();
                    return container != null && container.isConnecting();
                }
                case "transactional": {
                    if (context == null) {
                        return false;
                    }
                    if (!context.isConnected()) {
                        return Boolean.FALSE.equals(expectedValue);
                    }
                    DBCTransactionManager txnManager = DBUtils.getTransactionManager((DBCExecutionContext)context);
                    try {
                        return txnManager != null && Boolean.valueOf(!txnManager.isAutoCommit()).equals(expectedValue);
                    }
                    catch (DBCException e) {
                        log.debug((Object)"Error checking auto-commit state", (Throwable)e);
                        return false;
                    }
                }
                case "synchronizable": {
                    if (context == null || !context.isConnected()) {
                        return false;
                    }
                    DBPDataSourceContainer container = context.getDataSource().getContainer();
                    DBPDataSourceProvider provider = container.getDriver().getDataSourceProvider();
                    DBPDataSourceProviderSynchronizable providerSynchronizable = (DBPDataSourceProviderSynchronizable)GeneralUtils.adapt((Object)provider, DBPDataSourceProviderSynchronizable.class);
                    return providerSynchronizable != null && providerSynchronizable.isSynchronizationEnabled(container);
                }
                case "supportsTransactions": {
                    if (context == null || !context.isConnected()) {
                        return false;
                    }
                    DBCTransactionManager txnManager = DBUtils.getTransactionManager((DBCExecutionContext)context);
                    return txnManager != null && txnManager.isSupportsTransactions();
                }
                case "transactionActive": {
                    if (context != null && context.isConnected()) {
                        IPageChangeProvider pcp;
                        Object selectedPage;
                        if (receiver instanceof IPageChangeProvider && !((selectedPage = (pcp = (IPageChangeProvider)receiver).getSelectedPage()) instanceof ISmartTransactionManager)) {
                            return Boolean.FALSE.equals(expectedValue);
                        }
                        DBCTransactionManager txnManager = DBUtils.getTransactionManager((DBCExecutionContext)context);
                        return txnManager != null && !txnManager.isAutoCommit();
                    }
                    return Boolean.FALSE.equals(expectedValue);
                }
                case "editable": {
                    DBPProject resourceProject = DataSourcePropertyTester.getProject(receiver);
                    return resourceProject == null || resourceProject.hasRealmPermission("project-datasource-edit");
                }
                case "projectResourceEditable": {
                    DBPProject resourceProject = DataSourcePropertyTester.getProject(receiver);
                    return resourceProject == null || resourceProject.hasRealmPermission("project-resource-edit");
                }
                case "projectResourceViewable": {
                    DBPProject resourceProject = DataSourcePropertyTester.getProject(receiver);
                    return resourceProject == null || resourceProject.hasRealmPermission("project-resource-view");
                }
            }
            return false;
        }
        catch (Exception e) {
            log.debug((Object)("Error testing property " + property + ": " + e.getMessage()));
            return false;
        }
    }

    @Nullable
    private static DBPProject getProject(Object receiver) {
        DBPProject dBPProject;
        if (receiver instanceof IEditorPart) {
            IEditorPart editorPart = (IEditorPart)receiver;
            dBPProject = EditorUtils.getFileProject(editorPart.getEditorInput());
        } else {
            dBPProject = null;
        }
        return dBPProject;
    }

    public static void firePropertyChange(String propName) {
        ActionUtils.evaluatePropertyState((String)("org.jkiss.dbeaver.core.datasource." + propName));
    }

    private static void updateEditorsDirtyFlag() {
        IEditorReference[] editors;
        IWorkbenchWindow workbenchWindow = UIUtils.findActiveWorkbenchWindow();
        if (workbenchWindow == null) {
            return;
        }
        IEditorReference[] iEditorReferenceArray = editors = workbenchWindow.getActivePage().getEditorReferences();
        int n = editors.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference ref = iEditorReferenceArray[n2];
            IEditorPart editor = ref.getEditor(false);
            if (editor instanceof IStatefulEditor) {
                UIUtils.asyncExec(((IStatefulEditor)editor)::updateDirtyFlag);
            }
            ++n2;
        }
    }

    private static class QMEventsHandler
    extends DefaultExecutionHandler {
        private QMEventsHandler() {
        }

        @NotNull
        public String getHandlerName() {
            return DataSourcePropertyTester.class.getName();
        }

        public synchronized void handleTransactionAutocommit(@NotNull DBCExecutionContext context, boolean autoCommit) {
            this.updateUI(() -> {
                DataSourcePropertyTester.firePropertyChange(DataSourcePropertyTester.PROP_TRANSACTIONAL);
                DataSourcePropertyTester.firePropertyChange(DataSourcePropertyTester.PROP_TRANSACTION_ACTIVE);
                ActionUtils.fireCommandRefresh((String[])new String[]{"org.jkiss.dbeaver.core.txn.autocommit"});
            });
        }

        public synchronized void handleTransactionCommit(@NotNull DBCExecutionContext context) {
            this.updateUI(() -> {
                DataSourcePropertyTester.firePropertyChange(DataSourcePropertyTester.PROP_TRANSACTION_ACTIVE);
                DataSourcePropertyTester.updateEditorsDirtyFlag();
            });
        }

        public synchronized void handleTransactionRollback(@NotNull DBCExecutionContext context, DBCSavepoint savepoint) {
            this.updateUI(() -> {
                DataSourcePropertyTester.firePropertyChange(DataSourcePropertyTester.PROP_TRANSACTION_ACTIVE);
                DataSourcePropertyTester.updateEditorsDirtyFlag();
            });
        }

        public synchronized void handleStatementExecuteBegin(@NotNull DBCStatement statement) {
            this.updateUI(() -> DataSourcePropertyTester.firePropertyChange(DataSourcePropertyTester.PROP_TRANSACTION_ACTIVE));
        }

        private void updateUI(Runnable runnable) {
            UIUtils.asyncExec((Runnable)runnable);
        }
    }

    public static class QMService
    implements IPluginService {
        private QMEventsHandler qmHandler;

        public void activateService() {
            if (DBWorkbench.getPlatform().getApplication().isHeadlessMode()) {
                return;
            }
            this.qmHandler = new QMEventsHandler();
            QMUtils.registerHandler((QMExecutionHandler)this.qmHandler);
        }

        public void deactivateService() {
            if (this.qmHandler != null) {
                QMUtils.unregisterHandler((QMExecutionHandler)this.qmHandler);
            }
        }
    }
}

