/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql;

import java.text.BreakIterator;
import java.text.CharacterIterator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.texteditor.TextNavigationAction;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorBase;
import org.jkiss.dbeaver.ui.editors.sql.syntax.SQLDocumentCharacterIterator;
import org.jkiss.dbeaver.ui.editors.sql.syntax.SQLWordBreakIterator;

public class SQLEditorCustomActions {
    protected static final Log log = Log.getLog(SQLEditorCustomActions.class);

    public static void registerCustomActions(SQLEditorBase editor) {
        StyledText textWidget = editor.getViewer().getTextWidget();
        editor.setAction("org.eclipse.ui.edit.text.goto.wordPrevious", (IAction)new NavigatePreviousSubWordAction(editor));
        textWidget.setKeyBinding(17039363, 0);
        editor.setAction("org.eclipse.ui.edit.text.goto.wordNext", (IAction)new NavigateNextSubWordAction(editor));
        textWidget.setKeyBinding(0x1040004, 0);
        editor.setAction("org.eclipse.ui.edit.text.select.wordPrevious", (IAction)new SelectPreviousSubWordAction(editor));
        textWidget.setKeyBinding(17170435, 0);
        editor.setAction("org.eclipse.ui.edit.text.select.wordNext", (IAction)new SelectNextSubWordAction(editor));
        textWidget.setKeyBinding(17170436, 0);
    }

    protected static abstract class BaseTextNavigateAction
    extends TextNavigationAction {
        protected final SQLEditorBase editor;

        public BaseTextNavigateAction(SQLEditorBase editor, String actionDefinitionId, int action) {
            super(editor.getViewer().getTextWidget(), action);
            this.editor = editor;
            this.setActionDefinitionId(actionDefinitionId);
        }

        protected ISourceViewer getSourceViewer() {
            return this.editor.getViewer();
        }

        protected int widgetOffset2ModelOffset(int widgetOffset) {
            ISourceViewer viewer = this.getSourceViewer();
            if (viewer instanceof ITextViewerExtension5) {
                ITextViewerExtension5 extension = (ITextViewerExtension5)viewer;
                return extension.widgetOffset2ModelOffset(widgetOffset);
            }
            return widgetOffset + viewer.getVisibleRegion().getOffset();
        }

        protected int modelOffset2WidgetOffset(int modelOffset) {
            ISourceViewer viewer = this.getSourceViewer();
            if (viewer instanceof ITextViewerExtension5) {
                ITextViewerExtension5 extension = (ITextViewerExtension5)viewer;
                return extension.modelOffset2WidgetOffset(modelOffset);
            }
            return modelOffset - viewer.getVisibleRegion().getOffset();
        }
    }

    protected static class NavigateNextSubWordAction
    extends NextSubWordAction {
        public NavigateNextSubWordAction(SQLEditorBase editor) {
            super(editor, "org.eclipse.ui.edit.text.goto.wordNext", 0x1040004);
        }

        @Override
        protected void setCaretPosition(int position) {
            this.getTextWidget().setCaretOffset(this.modelOffset2WidgetOffset(position));
        }
    }

    protected static class NavigatePreviousSubWordAction
    extends PreviousSubWordAction {
        public NavigatePreviousSubWordAction(SQLEditorBase editor) {
            super(editor, "org.eclipse.ui.edit.text.goto.wordPrevious", 17039363);
        }

        @Override
        protected void setCaretPosition(int position) {
            this.getTextWidget().setCaretOffset(this.modelOffset2WidgetOffset(position));
        }
    }

    protected static abstract class NextSubWordAction
    extends BaseTextNavigateAction {
        protected SQLWordIterator wordIterator = new SQLWordIterator();

        protected NextSubWordAction(SQLEditorBase editor, String actionDefinitionId, int code) {
            super(editor, actionDefinitionId, code);
        }

        public void run() {
            DBPPreferenceStore store = this.editor.getActivePreferenceStore();
            if (!store.getBoolean("SQLEditor.smartWordIterator")) {
                super.run();
                return;
            }
            ISourceViewer viewer = this.getSourceViewer();
            IDocument document = viewer.getDocument();
            try {
                this.wordIterator.setText(new SQLDocumentCharacterIterator(document));
                int position = this.widgetOffset2ModelOffset(viewer.getTextWidget().getCaretOffset());
                if (position == -1) {
                    return;
                }
                int next = this.findNextPosition(position);
                if (this.editor.isBlockSelectionModeEnabled() && document.getLineOfOffset(next) != document.getLineOfOffset(position)) {
                    super.run();
                } else if (next != -1) {
                    this.setCaretPosition(next);
                    this.getTextWidget().showSelection();
                    this.fireSelectionChanged();
                }
            }
            catch (BadLocationException e) {
                log.debug((Object)e);
            }
        }

        protected int findNextPosition(int position) {
            ISourceViewer viewer = this.getSourceViewer();
            int widget = -1;
            int next = position;
            while (next != -1 && widget == -1) {
                if (next != -1) {
                    widget = this.modelOffset2WidgetOffset(next);
                }
                next = this.wordIterator.following(next);
            }
            IDocument document = viewer.getDocument();
            LinkedModeModel model = LinkedModeModel.getModel((IDocument)document, (int)position);
            if (model != null && next != -1) {
                LinkedPosition linkedPosition = model.findPosition(new LinkedPosition(document, position, 0));
                if (linkedPosition != null) {
                    int linkedPositionEnd = linkedPosition.getOffset() + linkedPosition.getLength();
                    if (position != linkedPositionEnd && linkedPositionEnd < next) {
                        next = linkedPositionEnd;
                    }
                } else {
                    int nextLinkedPositionOffset;
                    LinkedPosition nextLinkedPosition = model.findPosition(new LinkedPosition(document, next, 0));
                    if (nextLinkedPosition != null && position != (nextLinkedPositionOffset = nextLinkedPosition.getOffset()) && nextLinkedPositionOffset < next) {
                        next = nextLinkedPositionOffset;
                    }
                }
            }
            return next;
        }

        protected abstract void setCaretPosition(int var1);
    }

    protected static abstract class PreviousSubWordAction
    extends BaseTextNavigateAction {
        protected SQLWordIterator wordIterator = new SQLWordIterator();

        protected PreviousSubWordAction(SQLEditorBase editor, String actionDefinitionId, int code) {
            super(editor, actionDefinitionId, code);
        }

        public void run() {
            DBPPreferenceStore store = this.editor.getActivePreferenceStore();
            if (!store.getBoolean("SQLEditor.smartWordIterator")) {
                super.run();
                return;
            }
            ISourceViewer viewer = this.getSourceViewer();
            IDocument document = viewer.getDocument();
            try {
                this.wordIterator.setText(new SQLDocumentCharacterIterator(document));
                int position = this.widgetOffset2ModelOffset(viewer.getTextWidget().getCaretOffset());
                if (position == -1) {
                    return;
                }
                int previous = this.findPreviousPosition(position);
                if (this.editor.isBlockSelectionModeEnabled() && document.getLineOfOffset(previous) != document.getLineOfOffset(position)) {
                    super.run();
                } else if (previous != -1) {
                    this.setCaretPosition(previous);
                    this.getTextWidget().showSelection();
                    this.fireSelectionChanged();
                }
            }
            catch (BadLocationException e) {
                log.debug((Object)e);
            }
        }

        protected int findPreviousPosition(int position) {
            ISourceViewer viewer = this.getSourceViewer();
            int widget = -1;
            int previous = position;
            while (previous != -1 && widget == -1) {
                if ((previous = this.wordIterator.preceding(previous)) == -1) continue;
                widget = this.modelOffset2WidgetOffset(previous);
            }
            IDocument document = viewer.getDocument();
            LinkedModeModel model = LinkedModeModel.getModel((IDocument)document, (int)position);
            if (model != null && previous != -1) {
                LinkedPosition linkedPosition = model.findPosition(new LinkedPosition(document, position, 0));
                if (linkedPosition != null) {
                    int linkedPositionOffset = linkedPosition.getOffset();
                    if (position != linkedPositionOffset && previous < linkedPositionOffset) {
                        previous = linkedPositionOffset;
                    }
                } else {
                    int previousLinkedPositionEnd;
                    LinkedPosition previousLinkedPosition = model.findPosition(new LinkedPosition(document, previous, 0));
                    if (previousLinkedPosition != null && position != (previousLinkedPositionEnd = previousLinkedPosition.getOffset() + previousLinkedPosition.getLength()) && previous < previousLinkedPositionEnd) {
                        previous = previousLinkedPositionEnd;
                    }
                }
            }
            return previous;
        }

        protected abstract void setCaretPosition(int var1);
    }

    public static class SQLWordIterator
    extends BreakIterator {
        private final SQLWordBreakIterator sqlIterator = new SQLWordBreakIterator();
        private int index;

        public SQLWordIterator() {
            this.first();
        }

        @Override
        public int first() {
            this.index = this.sqlIterator.first();
            return this.index;
        }

        @Override
        public int last() {
            this.index = this.sqlIterator.last();
            return this.index;
        }

        @Override
        public int next(int n) {
            int next = 0;
            while (--n > 0 && next != -1) {
                next = this.next();
            }
            return next;
        }

        @Override
        public int next() {
            this.index = this.following(this.index);
            return this.index;
        }

        @Override
        public int previous() {
            this.index = this.preceding(this.index);
            return this.index;
        }

        @Override
        public int preceding(int offset) {
            int second;
            int first = this.sqlIterator.preceding(offset);
            if (this.isWhitespace(first, offset) && (second = this.sqlIterator.preceding(first)) != -1 && !this.isDelimiter(second, first)) {
                return second;
            }
            return first;
        }

        @Override
        public int following(int offset) {
            int second;
            int first = this.sqlIterator.following(offset);
            if (this.eatFollowingWhitespace(offset, first) && this.isWhitespace(first, second = this.sqlIterator.following(first))) {
                return second;
            }
            return first;
        }

        private boolean eatFollowingWhitespace(int offset, int exclusiveEnd) {
            if (exclusiveEnd != -1 && offset != -1) {
                if (this.isWhitespace(offset, exclusiveEnd)) {
                    return false;
                }
                return !this.isDelimiter(offset, exclusiveEnd);
            }
            return false;
        }

        private boolean isDelimiter(int offset, int exclusiveEnd) {
            if (exclusiveEnd != -1 && offset != -1) {
                CharSequence seq = this.sqlIterator.getTextValue();
                while (offset < exclusiveEnd) {
                    char ch = seq.charAt(offset);
                    if (ch != '\n' && ch != '\r') {
                        return false;
                    }
                    ++offset;
                }
                return true;
            }
            return false;
        }

        private boolean isWhitespace(int offset, int exclusiveEnd) {
            if (exclusiveEnd != -1 && offset != -1) {
                CharSequence seq = this.sqlIterator.getTextValue();
                while (offset < exclusiveEnd) {
                    char ch = seq.charAt(offset);
                    if (!Character.isWhitespace(ch)) {
                        return false;
                    }
                    if (ch == '\n' || ch == '\r') {
                        return false;
                    }
                    ++offset;
                }
                return true;
            }
            return false;
        }

        @Override
        public int current() {
            return this.index;
        }

        @Override
        public CharacterIterator getText() {
            return this.sqlIterator.getText();
        }

        public void setText(CharSequence newText) {
            this.sqlIterator.setText(newText);
            this.first();
        }

        @Override
        public void setText(CharacterIterator newText) {
            this.sqlIterator.setText(newText);
            this.first();
        }

        @Override
        public void setText(String newText) {
            this.setText((CharSequence)newText);
        }
    }

    protected static class SelectNextSubWordAction
    extends NextSubWordAction {
        public SelectNextSubWordAction(SQLEditorBase editor) {
            super(editor, "org.eclipse.ui.edit.text.select.wordNext", 17170436);
        }

        @Override
        protected void setCaretPosition(int position) {
            ISourceViewer viewer = this.getSourceViewer();
            StyledText text = viewer.getTextWidget();
            if (text != null && !text.isDisposed()) {
                Point selection = text.getSelection();
                int caret = text.getCaretOffset();
                int offset = this.modelOffset2WidgetOffset(position);
                if (caret == selection.x) {
                    text.setSelectionRange(selection.y, offset - selection.y);
                } else {
                    text.setSelectionRange(selection.x, offset - selection.x);
                }
            }
        }
    }

    protected static class SelectPreviousSubWordAction
    extends PreviousSubWordAction {
        public SelectPreviousSubWordAction(SQLEditorBase editor) {
            super(editor, "org.eclipse.ui.edit.text.select.wordPrevious", 17170435);
        }

        @Override
        protected void setCaretPosition(int position) {
            ISourceViewer viewer = this.getSourceViewer();
            StyledText text = viewer.getTextWidget();
            if (text != null && !text.isDisposed()) {
                Point selection = text.getSelection();
                int caret = text.getCaretOffset();
                int offset = this.modelOffset2WidgetOffset(position);
                if (caret == selection.x) {
                    text.setSelectionRange(selection.y, offset - selection.y);
                } else {
                    text.setSelectionRange(selection.x, offset - selection.x);
                }
            }
        }
    }
}

