/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreAccessMethod;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreAttribute;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreIndex;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreOperatorClass;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableBase;
import org.jkiss.dbeaver.model.impl.struct.AbstractTableIndexColumn;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class PostgreIndexColumn
extends AbstractTableIndexColumn {
    private PostgreIndex index;
    private PostgreAttribute tableColumn;
    private String expression;
    private int ordinalPosition;
    private boolean ascending;
    private long opClass;
    private boolean nullable;

    public PostgreIndexColumn(PostgreIndex index, PostgreAttribute tableColumn, String expression, int ordinalPosition, boolean ascending, long opClass, boolean nullable) {
        this.index = index;
        this.tableColumn = tableColumn;
        this.expression = expression;
        this.ordinalPosition = ordinalPosition;
        this.ascending = ascending;
        this.opClass = opClass;
        this.nullable = nullable;
    }

    public PostgreIndexColumn(DBRProgressMonitor monitor, PostgreIndex index, PostgreIndexColumn srcColumn) throws DBException {
        this.index = index;
        PostgreAttribute srcTableColumn = srcColumn.getTableColumn();
        this.tableColumn = srcTableColumn == null ? null : ((PostgreTableBase)index.getTable()).getAttribute(monitor, srcTableColumn.getName());
        this.expression = srcColumn.expression;
        this.ordinalPosition = srcColumn.ordinalPosition;
        this.ascending = srcColumn.ascending;
        this.opClass = srcColumn.opClass;
        this.nullable = srcColumn.nullable;
    }

    @NotNull
    public PostgreIndex getIndex() {
        return this.index;
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.tableColumn == null ? this.expression : this.tableColumn.getName();
    }

    @Property(viewable=true, order=1)
    @Nullable
    public PostgreAttribute getTableColumn() {
        return this.tableColumn;
    }

    @Property(viewable=false, order=2)
    public int getOrdinalPosition() {
        return this.ordinalPosition;
    }

    @Property(viewable=true, order=3)
    public boolean isAscending() {
        return this.ascending;
    }

    @Property(viewable=true, order=4)
    public boolean isNullable() {
        return this.nullable;
    }

    @Property(viewable=true, order=6)
    public PostgreOperatorClass getOperatorClass(DBRProgressMonitor monitor) throws DBException {
        if (this.opClass <= 0L) {
            return null;
        }
        PostgreAccessMethod accessMethod = this.index.getAccessMethod(monitor);
        if (accessMethod == null) {
            return null;
        }
        return accessMethod.getOperatorClass(monitor, this.opClass);
    }

    @Nullable
    public String getDescription() {
        return this.tableColumn == null ? null : this.tableColumn.getDescription();
    }

    public PostgreIndex getParentObject() {
        return this.index;
    }

    @NotNull
    public PostgreDataSource getDataSource() {
        return this.index.getDataSource();
    }

    public String toString() {
        return this.tableColumn == null ? "NULL" : this.tableColumn.toString();
    }
}

