/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.ui.refactoring.history;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptorProxy;
import org.eclipse.ltk.core.refactoring.history.RefactoringHistory;
import org.eclipse.ltk.internal.core.refactoring.history.RefactoringHistoryImplementation;
import org.eclipse.ltk.internal.ui.refactoring.history.RefactoringHistoryCollection;
import org.eclipse.ltk.internal.ui.refactoring.history.RefactoringHistoryDate;
import org.eclipse.ltk.internal.ui.refactoring.history.RefactoringHistoryEntry;
import org.eclipse.ltk.internal.ui.refactoring.history.RefactoringHistoryNode;
import org.eclipse.ltk.internal.ui.refactoring.history.RefactoringHistoryProject;
import org.eclipse.ltk.ui.refactoring.history.RefactoringHistoryContentProvider;
import org.eclipse.ltk.ui.refactoring.history.RefactoringHistoryControlConfiguration;

public final class BrowseRefactoringHistoryContentProvider
extends RefactoringHistoryContentProvider {
    private static final Object[] NO_ELEMENTS = new Object[0];
    private static final String WORKSPACE_PROJECT = ".workspace";
    private final RefactoringHistoryControlConfiguration fControlConfiguration;
    private Map<String, RefactoringHistoryContentProvider> fProjectContentProviders = null;
    private Map<String, RefactoringHistory> fProjectRefactoringHistories = null;
    private RefactoringHistory fRefactoringHistory = null;
    private boolean fSortProjects = true;

    public BrowseRefactoringHistoryContentProvider(RefactoringHistoryControlConfiguration configuration) {
        super(configuration);
        Assert.isNotNull((Object)configuration);
        this.fControlConfiguration = configuration;
    }

    @Override
    public Object[] getChildren(Object element) {
        if (this.fSortProjects && element instanceof RefactoringHistoryNode) {
            RefactoringHistoryNode node = (RefactoringHistoryNode)element;
            if (node instanceof RefactoringHistoryProject) {
                return this.getRefactoringHistoryEntries((RefactoringHistoryProject)node);
            }
            RefactoringHistoryContentProvider provider = this.getRefactoringHistoryContentProvider(node);
            if (provider != null) {
                return provider.getChildren(element);
            }
            return NO_ELEMENTS;
        }
        return super.getChildren(element);
    }

    @Override
    public Object[] getElements(Object element) {
        if (this.fSortProjects && element instanceof RefactoringHistory) {
            return this.getRootElements();
        }
        return super.getElements(element);
    }

    @Override
    public Object getParent(Object element) {
        if (this.fSortProjects && element instanceof RefactoringHistoryNode) {
            RefactoringHistoryContentProvider provider = this.getRefactoringHistoryContentProvider((RefactoringHistoryNode)element);
            if (provider != null) {
                return provider.getParent(element);
            }
            return null;
        }
        return super.getParent(element);
    }

    private Map<String, RefactoringHistory> getRefactoringHistories() {
        if (this.fProjectRefactoringHistories == null) {
            this.fProjectRefactoringHistories = new HashMap<String, RefactoringHistory>();
            HashMap<String, HashSet<RefactoringDescriptorProxy>> projectRefactoringHistories = new HashMap<String, HashSet<RefactoringDescriptorProxy>>();
            if (this.fRefactoringHistory != null && !this.fRefactoringHistory.isEmpty()) {
                RefactoringDescriptorProxy[] refactoringDescriptorProxyArray = this.fRefactoringHistory.getDescriptors();
                int n = refactoringDescriptorProxyArray.length;
                int n2 = 0;
                while (n2 < n) {
                    HashSet<RefactoringDescriptorProxy> collection;
                    RefactoringDescriptorProxy proxy = refactoringDescriptorProxyArray[n2];
                    String current = proxy.getProject();
                    if (current == null || current.length() == 0) {
                        current = WORKSPACE_PROJECT;
                    }
                    if ((collection = (HashSet<RefactoringDescriptorProxy>)projectRefactoringHistories.get(current)) == null) {
                        collection = new HashSet<RefactoringDescriptorProxy>();
                        projectRefactoringHistories.put(current, collection);
                    }
                    collection.add(proxy);
                    ++n2;
                }
                for (String current : new ArrayList(projectRefactoringHistories.keySet())) {
                    Collection collection = (Collection)projectRefactoringHistories.get(current);
                    if (collection == null) continue;
                    this.fProjectRefactoringHistories.put(current, (RefactoringHistory)new RefactoringHistoryImplementation(collection.toArray(new RefactoringDescriptorProxy[collection.size()])));
                }
            }
        }
        return this.fProjectRefactoringHistories;
    }

    private RefactoringHistory getRefactoringHistory(String project) {
        this.getRefactoringHistories();
        return this.fProjectRefactoringHistories.get(project);
    }

    private RefactoringHistoryContentProvider getRefactoringHistoryContentProvider(RefactoringHistoryNode node) {
        RefactoringHistoryContentProvider provider;
        RefactoringHistory history;
        Assert.isNotNull((Object)node);
        RefactoringHistoryNode root = this.getRootNode(node);
        String projectName = null;
        if (root instanceof RefactoringHistoryProject) {
            projectName = ((RefactoringHistoryProject)root).getProject();
        } else if (!(node instanceof RefactoringHistoryEntry)) {
            projectName = WORKSPACE_PROJECT;
        }
        if (projectName != null && (history = this.getRefactoringHistory(projectName)) != null && (provider = this.getRefactoringHistoryContentProvider(projectName)) != null) {
            provider.inputChanged(null, null, history);
            return provider;
        }
        return null;
    }

    private RefactoringHistoryContentProvider getRefactoringHistoryContentProvider(String project) {
        RefactoringHistoryContentProvider provider;
        if (this.fProjectContentProviders == null) {
            this.fProjectContentProviders = new HashMap<String, RefactoringHistoryContentProvider>();
        }
        if ((provider = this.fProjectContentProviders.get(project)) == null) {
            provider = this.fControlConfiguration.getContentProvider();
            this.fProjectContentProviders.put(project, provider);
        }
        return provider;
    }

    private Object[] getRefactoringHistoryEntries(RefactoringHistoryProject project) {
        String name = project.getProject();
        RefactoringHistory history = this.getRefactoringHistory(name);
        if (history != null) {
            if (this.fControlConfiguration.isTimeDisplayed()) {
                RefactoringHistoryContentProvider provider = this.getRefactoringHistoryContentProvider(project);
                if (provider != null) {
                    provider.inputChanged(null, null, history);
                    Object[] elements = provider.getRootElements();
                    if (!WORKSPACE_PROJECT.equals(name)) {
                        int index = 0;
                        while (index < elements.length) {
                            if (elements[index] instanceof RefactoringHistoryDate) {
                                RefactoringHistoryDate date = (RefactoringHistoryDate)elements[index];
                                elements[index] = new RefactoringHistoryDate(project, date.getTimeStamp(), date.getKind());
                            }
                            ++index;
                        }
                    }
                    return elements;
                }
            } else {
                RefactoringDescriptorProxy[] proxies = history.getDescriptors();
                Object[] entries = new RefactoringHistoryEntry[proxies.length];
                int index = 0;
                while (index < proxies.length) {
                    entries[index] = new RefactoringHistoryEntry(project, proxies[index]);
                    ++index;
                }
                return entries;
            }
        }
        return NO_ELEMENTS;
    }

    @Override
    public Object[] getRootElements() {
        if (this.fSortProjects) {
            ArrayList<Object> list = new ArrayList<Object>(32);
            for (String project : this.getRefactoringHistories().keySet()) {
                if (project.equals(WORKSPACE_PROJECT)) {
                    RefactoringHistory history = this.getRefactoringHistory(project);
                    if (history == null) continue;
                    if (this.fControlConfiguration.isTimeDisplayed()) {
                        RefactoringHistoryContentProvider provider = this.getRefactoringHistoryContentProvider(project);
                        if (provider == null) continue;
                        provider.inputChanged(null, null, history);
                        list.addAll(Arrays.asList(provider.getRootElements()));
                        continue;
                    }
                    RefactoringDescriptorProxy[] proxies = history.getDescriptors();
                    RefactoringHistoryEntry[] entries = new RefactoringHistoryEntry[proxies.length];
                    int index = 0;
                    while (index < proxies.length) {
                        entries[index] = new RefactoringHistoryEntry(null, proxies[index]);
                        ++index;
                    }
                    list.addAll(Arrays.asList(entries));
                    continue;
                }
                list.add(new RefactoringHistoryProject(project));
            }
            return list.toArray();
        }
        if (this.fControlConfiguration.isTimeDisplayed()) {
            return super.getRootElements();
        }
        return new Object[]{new RefactoringHistoryCollection()};
    }

    private RefactoringHistoryNode getRootNode(RefactoringHistoryNode node) {
        RefactoringHistoryNode current = node;
        RefactoringHistoryNode parent = current.getParent();
        while (parent != null) {
            current = parent;
            parent = current.getParent();
        }
        return current;
    }

    @Override
    public void inputChanged(Viewer viewer, Object predecessor, Object successor) {
        super.inputChanged(viewer, predecessor, successor);
        if (predecessor == successor) {
            return;
        }
        this.fRefactoringHistory = successor instanceof RefactoringHistory ? (RefactoringHistory)successor : null;
        this.fProjectRefactoringHistories = null;
        this.fProjectContentProviders = null;
    }

    public boolean isSortProjects() {
        return this.fSortProjects;
    }

    public void setSortProjects(boolean sort) {
        if (sort != this.fSortProjects) {
            this.fProjectRefactoringHistories = null;
            this.fProjectContentProviders = null;
        }
        this.fSortProjects = sort;
    }
}

