/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.util;

import com.dropbox.core.util.LangUtil;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.Arrays;
import java.util.Collection;

public class StringUtil {
    public static final Charset UTF8 = Charset.forName("UTF-8");
    private static final char[] HexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    public static final String Base64Digits = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
    public static final String UrlSafeBase64Digits = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_";

    public static char hexDigit(int i) {
        return HexDigits[i];
    }

    public static String utf8ToString(byte[] utf8Data) throws CharacterCodingException {
        return StringUtil.utf8ToString(utf8Data, 0, utf8Data.length);
    }

    public static String utf8ToString(byte[] utf8Data, int offset, int length) throws CharacterCodingException {
        CharsetDecoder decoder = UTF8.newDecoder();
        CharBuffer result = decoder.decode(ByteBuffer.wrap(utf8Data, offset, length));
        return result.toString();
    }

    public static byte[] stringToUtf8(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw LangUtil.mkAssert("UTF-8 should always be supported", ex);
        }
    }

    public static String javaQuotedLiteral(String value) {
        StringBuilder b = new StringBuilder(value.length() * 2);
        b.append('\"');
        block8: for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '\"': {
                    b.append("\\\"");
                    continue block8;
                }
                case '\\': {
                    b.append("\\\\");
                    continue block8;
                }
                case '\n': {
                    b.append("\\n");
                    continue block8;
                }
                case '\r': {
                    b.append("\\t");
                    continue block8;
                }
                case '\t': {
                    b.append("\\r");
                    continue block8;
                }
                case '\u0000': {
                    b.append("\\000");
                    continue block8;
                }
                default: {
                    if (c >= ' ' && c <= '~') {
                        b.append(c);
                        continue block8;
                    }
                    int h1 = c >> 12 & 0xF;
                    int h2 = c >> 8 & 0xF;
                    int h3 = c >> 4 & 0xF;
                    int h4 = c & 0xF;
                    b.append("\\u");
                    b.append(StringUtil.hexDigit(h1));
                    b.append(StringUtil.hexDigit(h2));
                    b.append(StringUtil.hexDigit(h3));
                    b.append(StringUtil.hexDigit(h4));
                }
            }
        }
        b.append('\"');
        return b.toString();
    }

    public static String javaQuotedLiterals(String[] value) {
        return StringUtil.javaQuotedLiterals(Arrays.asList(value));
    }

    public static String javaQuotedLiterals(Iterable<String> value) {
        StringBuilder b = new StringBuilder();
        String sep = "";
        for (String element : value) {
            b.append(sep);
            sep = ", ";
            b.append(StringUtil.javaQuotedLiteral(element));
        }
        return b.toString();
    }

    public static String jq(String value) {
        return StringUtil.javaQuotedLiteral(value);
    }

    public static String jq(String[] value) {
        return StringUtil.javaQuotedLiterals(value);
    }

    public static String jq(Iterable<String> value) {
        return StringUtil.javaQuotedLiterals(value);
    }

    public static String binaryToHex(byte[] data) {
        return StringUtil.binaryToHex(data, 0, data.length);
    }

    public static String binaryToHex(byte[] data, int offset, int length) {
        assert (offset < data.length && offset >= 0) : offset + ", " + data.length;
        int end = offset + length;
        assert (end <= data.length && end >= 0) : offset + ", " + length + ", " + data.length;
        char[] chars = new char[length * 2];
        int j = 0;
        for (int i = offset; i < end; ++i) {
            byte b = data[i];
            chars[j++] = StringUtil.hexDigit(b >>> 4 & 0xF);
            chars[j++] = StringUtil.hexDigit(b & 0xF);
        }
        return new String(chars);
    }

    public static boolean secureStringEquals(String a, String b) {
        if (a.length() != b.length()) {
            return false;
        }
        int result = 0;
        for (int i = 0; i < a.length(); ++i) {
            char ca = a.charAt(i);
            char cb = b.charAt(i);
            result |= ca ^ cb;
        }
        return result == 0;
    }

    public static String base64Encode(byte[] data) {
        return StringUtil.base64EncodeGeneric(Base64Digits, data);
    }

    public static String urlSafeBase64Encode(byte[] data) {
        return StringUtil.base64EncodeGeneric(UrlSafeBase64Digits, data);
    }

    public static String base64EncodeGeneric(String digits, byte[] data) {
        int d3;
        int d2;
        int d1;
        if (data == null) {
            throw new IllegalArgumentException("'data' can't be null");
        }
        if (digits == null) {
            throw new IllegalArgumentException("'digits' can't be null");
        }
        if (digits.length() != 64) {
            throw new IllegalArgumentException("'digits' must be 64 characters long: " + StringUtil.jq(digits));
        }
        int numGroupsOfThreeInputBytes = (data.length + 2) / 3;
        int numOutputChars = numGroupsOfThreeInputBytes * 4;
        StringBuilder buf = new StringBuilder(numOutputChars);
        int i = 0;
        while (i + 3 <= data.length) {
            int b1 = data[i++] & 0xFF;
            int b2 = data[i++] & 0xFF;
            int b3 = data[i++] & 0xFF;
            d1 = b1 >>> 2;
            d2 = (b1 & 3) << 4 | b2 >>> 4;
            d3 = (b2 & 0xF) << 2 | b3 >>> 6;
            int d4 = b3 & 0x3F;
            buf.append(digits.charAt(d1));
            buf.append(digits.charAt(d2));
            buf.append(digits.charAt(d3));
            buf.append(digits.charAt(d4));
        }
        int remaining = data.length - i;
        if (remaining != 0) {
            int b1;
            if (remaining == 1) {
                b1 = data[i++] & 0xFF;
                int d12 = b1 >>> 2;
                int d22 = (b1 & 3) << 4;
                buf.append(digits.charAt(d12));
                buf.append(digits.charAt(d22));
                buf.append("==");
            } else if (remaining == 2) {
                b1 = data[i++] & 0xFF;
                int b2 = data[i++] & 0xFF;
                d1 = b1 >>> 2;
                d2 = (b1 & 3) << 4 | b2 >>> 4;
                d3 = (b2 & 0xF) << 2;
                buf.append(digits.charAt(d1));
                buf.append(digits.charAt(d2));
                buf.append(digits.charAt(d3));
                buf.append('=');
            } else {
                throw new AssertionError((Object)("data.length: " + data.length + ", i: " + i));
            }
        }
        return buf.toString();
    }

    public static String join(Collection<String> strings, String delimiter) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (String s : strings) {
            if (i > 0) {
                sb.append(delimiter);
            }
            sb.append(s);
            ++i;
        }
        return sb.toString();
    }

    static {
        assert (Base64Digits.length() == 64) : "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".length();
        assert (UrlSafeBase64Digits.length() == 64) : "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_".length();
    }
}

