/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.spectra;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.io.ChecksumCompute;
import ch.cyberduck.core.io.ChecksumComputeFactory;
import ch.cyberduck.core.io.HashAlgorithm;
import ch.cyberduck.core.s3.S3DisabledMultipartService;
import ch.cyberduck.core.s3.S3MultipartService;
import ch.cyberduck.core.s3.S3PathContainerService;
import ch.cyberduck.core.s3.S3Session;
import ch.cyberduck.core.s3.S3WriteFeature;
import ch.cyberduck.core.shared.DefaultAttributesFinderFeature;
import ch.cyberduck.core.shared.DefaultFindFeature;
import ch.cyberduck.core.spectra.SpectraSession;
import ch.cyberduck.core.transfer.TransferStatus;
import org.apache.commons.lang3.StringUtils;
import org.jets3t.service.model.S3Object;
import org.jets3t.service.utils.ServiceUtils;

public class SpectraWriteFeature
extends S3WriteFeature {
    private final PathContainerService containerService = new S3PathContainerService();

    public SpectraWriteFeature(SpectraSession session) {
        this(session, (Find)new DefaultFindFeature((Session)session), (AttributesFinder)new DefaultAttributesFinderFeature((Session)session));
    }

    public SpectraWriteFeature(SpectraSession session, Find finder, AttributesFinder attributes) {
        super((S3Session)session, (S3MultipartService)new S3DisabledMultipartService(), finder, attributes);
    }

    protected S3Object getDetails(Path file, TransferStatus status) {
        Checksum checksum;
        S3Object object = new S3Object(this.containerService.getKey(file));
        String mime = status.getMime();
        if (StringUtils.isNotBlank((CharSequence)mime)) {
            object.setContentType(mime);
        }
        if (Checksum.NONE != (checksum = status.getChecksum())) {
            switch (checksum.algorithm) {
                case md5: {
                    object.addMetadata("Content-MD5", ServiceUtils.toBase64((byte[])ServiceUtils.fromHex((String)checksum.hash)));
                }
            }
        }
        return object;
    }

    public ChecksumCompute checksum(Path file, TransferStatus status) {
        return ChecksumComputeFactory.get((HashAlgorithm)HashAlgorithm.md5);
    }
}

