/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.client.multipart;

import com.joyent.manta.client.crypto.EncryptingEntityHelper;
import com.joyent.manta.client.crypto.EncryptionContext;
import com.joyent.manta.client.multipart.EncryptionState;
import com.joyent.manta.client.multipart.EncryptionStateSnapshot;
import com.joyent.manta.client.multipart.MultipartOutputStream;
import com.joyent.manta.exception.MantaMemoizationException;
import com.joyent.manta.exception.MantaReflectionException;
import com.joyent.manta.util.CipherCloner;
import com.joyent.manta.util.Cloner;
import com.joyent.manta.util.HmacCloner;
import com.joyent.manta.util.HmacOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.UUID;
import javax.crypto.Cipher;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.bouncycastle.crypto.macs.HMac;

final class EncryptionStateRecorder {
    private static final Field FIELD_ENCRYPTIONCONTEXT_CIPHER = FieldUtils.getField(EncryptionContext.class, (String)"cipher", (boolean)true);
    private static final Field FIELD_ENCRYPTIONSTATE_CIPHERSTREAM = FieldUtils.getField(EncryptionState.class, (String)"cipherStream", (boolean)true);
    private static final Field FIELD_ENCRYPTIONSTATE_LASTPARTAUTHWRITTEN = FieldUtils.getField(EncryptionState.class, (String)"lastPartAuthWritten", (boolean)true);
    private static final Cloner<HMac> CLONER_HMAC = new HmacCloner();
    private static final Cloner<Cipher> CLONER_CIPHER = new CipherCloner();

    private EncryptionStateRecorder() {
    }

    private static HmacOutputStream ensureHmacWrapsCipherStream(OutputStream cipherStream) {
        if (!cipherStream.getClass().equals(HmacOutputStream.class)) {
            String message = "Cipher lacks authentication but OutputStream is not HmacOutputStream";
            throw new IllegalStateException("Cipher lacks authentication but OutputStream is not HmacOutputStream");
        }
        return (HmacOutputStream)cipherStream;
    }

    static EncryptionStateSnapshot record(EncryptionState encryptionState, UUID uploadId) {
        HMac hmac;
        if (!encryptionState.getEncryptionContext().getCipherDetails().isAEADCipher()) {
            OutputStream cipherStream = encryptionState.getCipherStream();
            HmacOutputStream digestStream = EncryptionStateRecorder.ensureHmacWrapsCipherStream(cipherStream);
            hmac = CLONER_HMAC.createClone(digestStream.getHmac());
        } else {
            hmac = null;
        }
        Cipher cipher = CLONER_CIPHER.createClone(encryptionState.getEncryptionContext().getCipher());
        int bufferSize = encryptionState.getEncryptionContext().getCipherDetails().getBlockSizeInBytes();
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(bufferSize);
        try {
            IOUtils.copy((InputStream)new ByteArrayInputStream(encryptionState.getMultipartStream().getBuf().toByteArray()), (OutputStream)buffer);
        }
        catch (IOException e) {
            throw new MantaMemoizationException("Failed to back up buffer while memoizing encryption state", e);
        }
        MultipartOutputStream multipartStream = new MultipartOutputStream(bufferSize, buffer);
        OutputStream cipherStream = EncryptingEntityHelper.makeCipherOutputForStream(multipartStream, encryptionState.getEncryptionContext().getCipherDetails(), cipher, hmac);
        return new EncryptionStateSnapshot(uploadId, encryptionState.getLastPartNumber(), encryptionState.isLastPartAuthWritten(), cipher, cipherStream, multipartStream);
    }

    static void rewind(EncryptionState encryptionState, EncryptionStateSnapshot snapshot) {
        Validate.isTrue((encryptionState.getLastPartNumber() == snapshot.getLastPartNumber() ? 1 : 0) != 0, (String)"Snapshot part number must equal encryption state part number", (Object[])new Object[0]);
        try {
            FieldUtils.writeField((Field)FIELD_ENCRYPTIONCONTEXT_CIPHER, (Object)encryptionState.getEncryptionContext(), (Object)snapshot.getCipher());
            FieldUtils.writeField((Field)FIELD_ENCRYPTIONSTATE_CIPHERSTREAM, (Object)encryptionState, (Object)snapshot.getCipherStream());
            FieldUtils.writeField((Field)FIELD_ENCRYPTIONSTATE_LASTPARTAUTHWRITTEN, (Object)encryptionState, (Object)snapshot.getLastPartAuthWritten());
        }
        catch (IllegalAccessException e) {
            String message = String.format("Failed to overwrite cipher while rewinding encryption state for upload [%s] part [%s]", snapshot.getUploadId(), snapshot.getLastPartNumber());
            throw new MantaReflectionException(message, e);
        }
        encryptionState.setMultipartStream(snapshot.getMultipartStream());
    }
}

