/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.openstack.swift.io;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.input.ProxyInputStream;

public class SubInputStream
extends ProxyInputStream {
    private long bytesRemaining;
    private long bytesProduced;
    private boolean closeSource;
    private boolean endSourceReached;

    public SubInputStream(InputStream inp, long maxLength, boolean closeSource) {
        super(inp);
        this.bytesRemaining = maxLength;
        this.bytesProduced = 0L;
        this.endSourceReached = false;
        this.closeSource = closeSource;
    }

    public boolean endSourceReached() {
        return this.endSourceReached;
    }

    public long getBytesProduced() {
        return this.bytesProduced;
    }

    public void readMoreBytes(long byteCount) {
        this.bytesRemaining = byteCount;
        this.bytesProduced = 0L;
    }

    public int read() throws IOException {
        if (this.bytesRemaining == 0L) {
            return -1;
        }
        int data = super.read();
        if (data >= 0) {
            --this.bytesRemaining;
            ++this.bytesProduced;
        } else {
            this.endSourceReached = true;
        }
        return data;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.bytesRemaining == 0L) {
            return -1;
        }
        if (off < 0 || len < 0) {
            throw new IndexOutOfBoundsException();
        }
        int bytesRead = this.bytesRemaining > (long)len ? super.read(b, off, len) : super.read(b, off, (int)this.bytesRemaining);
        if (bytesRead < 0) {
            this.endSourceReached = true;
        } else {
            this.bytesRemaining -= (long)bytesRead;
            this.bytesProduced += (long)bytesRead;
        }
        return bytesRead;
    }

    public long skip(long n) throws IOException {
        if (n <= 0L) {
            return 0L;
        }
        long bytesSkipped = this.bytesRemaining > n ? super.skip(n) : super.skip(this.bytesRemaining);
        if (bytesSkipped > 0L) {
            this.bytesRemaining -= bytesSkipped;
        }
        return bytesSkipped;
    }

    public void close() throws IOException {
        if (this.closeSource || this.endSourceReached) {
            super.close();
        }
        this.bytesRemaining = 0L;
    }
}

