/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.nio;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.Permission;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.nio.LocalAttributesFinderFeature;
import ch.cyberduck.core.nio.LocalExceptionMappingService;
import ch.cyberduck.core.nio.LocalSession;
import ch.cyberduck.core.shared.DefaultUnixPermissionFeature;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermissions;
import java.nio.file.attribute.UserPrincipal;

public class LocalUnixPermissionFeature
extends DefaultUnixPermissionFeature {
    private final LocalSession session;

    public LocalUnixPermissionFeature(LocalSession session) {
        this.session = session;
    }

    public void setUnixOwner(Path file, String owner) throws BackgroundException {
        try {
            UserPrincipal principal = ((FileSystem)this.session.getClient()).getUserPrincipalLookupService().lookupPrincipalByName(owner);
            Files.setOwner(this.session.toPath(file), principal);
        }
        catch (IOException e) {
            throw new LocalExceptionMappingService().map("Failure to write attributes of {0}", e, file);
        }
    }

    public void setUnixGroup(Path file, String group) throws BackgroundException {
        try {
            GroupPrincipal principal = ((FileSystem)this.session.getClient()).getUserPrincipalLookupService().lookupPrincipalByGroupName(group);
            Files.getFileAttributeView(this.session.toPath(file), PosixFileAttributeView.class, LinkOption.NOFOLLOW_LINKS).setGroup(principal);
        }
        catch (IOException e) {
            throw new LocalExceptionMappingService().map("Failure to write attributes of {0}", e, file);
        }
    }

    public Permission getUnixPermission(Path file) throws BackgroundException {
        return new LocalAttributesFinderFeature(this.session).find(file).getPermission();
    }

    public void setUnixPermission(Path file, Permission permission) throws BackgroundException {
        try {
            Files.setPosixFilePermissions(this.session.toPath(file), PosixFilePermissions.fromString(permission.getSymbol()));
        }
        catch (IllegalArgumentException e) {
            throw new LocalExceptionMappingService().map("Failure to write attributes of {0}", new IOException(e), file);
        }
        catch (IOException e) {
            throw new LocalExceptionMappingService().map("Failure to write attributes of {0}", e, file);
        }
    }
}

