/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands;

import com.google.common.base.Preconditions;
import com.spectralogic.ds3client.commands.interfaces.AbstractRequest;
import com.spectralogic.ds3client.models.ChecksumType;
import com.spectralogic.ds3client.networking.HttpVerb;
import com.spectralogic.ds3client.utils.Guard;
import com.spectralogic.ds3client.utils.SeekableByteChannelInputStream;
import java.io.InputStream;
import java.nio.channels.SeekableByteChannel;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PutObjectRequest
extends AbstractRequest {
    private static final Logger LOG = LoggerFactory.getLogger(PutObjectRequest.class);
    public static final String AMZ_META_HEADER = "x-amz-meta-";
    private final InputStream stream;
    private final String bucketName;
    private final String objectName;
    private final long size;
    private String job;
    private long offset;
    private SeekableByteChannel channel;
    private ChecksumType checksum = ChecksumType.none();
    private ChecksumType.Type checksumType = ChecksumType.Type.NONE;

    @Deprecated
    public PutObjectRequest(String bucketName, String objectName, @Nonnull SeekableByteChannel channel, long size) {
        Preconditions.checkNotNull((Object)channel, (Object)"Channel may not be null.");
        this.bucketName = bucketName;
        this.objectName = objectName;
        this.size = size;
        this.channel = channel;
        this.stream = new SeekableByteChannelInputStream(channel);
    }

    public PutObjectRequest(String bucketName, String objectName, @Nonnull SeekableByteChannel channel, UUID job, long offset, long size) {
        Preconditions.checkNotNull((Object)channel, (Object)"Channel may not be null.");
        this.bucketName = bucketName;
        this.objectName = objectName;
        this.size = size;
        this.job = job.toString();
        this.offset = offset;
        this.channel = channel;
        this.stream = new SeekableByteChannelInputStream(channel);
        this.updateQueryParam("job", job);
        this.updateQueryParam("offset", offset);
    }

    public PutObjectRequest(String bucketName, String objectName, @Nonnull SeekableByteChannel channel, String job, long offset, long size) {
        Preconditions.checkNotNull((Object)channel, (Object)"Channel may not be null.");
        this.bucketName = bucketName;
        this.objectName = objectName;
        this.size = size;
        this.job = job;
        this.offset = offset;
        this.channel = channel;
        this.stream = new SeekableByteChannelInputStream(channel);
        this.updateQueryParam("job", job);
        this.updateQueryParam("offset", offset);
    }

    public PutObjectRequest(String bucketName, String objectName, UUID job, long offset, long size, @Nonnull InputStream stream) {
        Preconditions.checkNotNull((Object)stream, (Object)"Stream may not be null.");
        this.bucketName = bucketName;
        this.objectName = objectName;
        this.size = size;
        this.job = job.toString();
        this.offset = offset;
        this.stream = stream;
        this.updateQueryParam("job", job);
        this.updateQueryParam("offset", offset);
    }

    public PutObjectRequest(String bucketName, String objectName, String job, long offset, long size, @Nonnull InputStream stream) {
        Preconditions.checkNotNull((Object)stream, (Object)"Stream may not be null.");
        this.bucketName = bucketName;
        this.objectName = objectName;
        this.size = size;
        this.job = job;
        this.offset = offset;
        this.stream = stream;
        this.updateQueryParam("job", job);
        this.updateQueryParam("offset", offset);
    }

    public PutObjectRequest withJob(UUID job) {
        this.job = job.toString();
        this.updateQueryParam("job", job);
        return this;
    }

    public PutObjectRequest withJob(String job) {
        this.job = job;
        this.updateQueryParam("job", job);
        return this;
    }

    public PutObjectRequest withOffset(long offset) {
        this.offset = offset;
        this.updateQueryParam("offset", offset);
        return this;
    }

    public PutObjectRequest withChecksum(ChecksumType checksum) {
        return this.withChecksum(checksum, ChecksumType.Type.MD5);
    }

    public PutObjectRequest withChecksum(ChecksumType checksum, ChecksumType.Type checksumType) {
        this.checksum = checksum;
        this.checksumType = checksumType;
        return this;
    }

    @Override
    public ChecksumType getChecksum() {
        return this.checksum;
    }

    @Override
    public ChecksumType.Type getChecksumType() {
        return this.checksumType;
    }

    public PutObjectRequest withMetaData(String key, String value) {
        if (Guard.isStringNullOrEmpty((String)value)) {
            LOG.warn("Key has not been added to metadata because value was null or empty: {}", (Object)key);
            return this;
        }
        String modifiedKey = !key.toLowerCase().startsWith(AMZ_META_HEADER) ? AMZ_META_HEADER + key.toLowerCase() : key;
        this.getHeaders().put(modifiedKey, value);
        return this;
    }

    @Override
    public HttpVerb getVerb() {
        return HttpVerb.PUT;
    }

    @Override
    public String getPath() {
        return "/" + this.bucketName + "/" + this.objectName;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public InputStream getStream() {
        return this.stream;
    }

    public SeekableByteChannel getChannel() {
        return this.channel;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public String getJob() {
        return this.job;
    }

    public long getOffset() {
        return this.offset;
    }
}

