/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.parsers;

import com.spectralogic.ds3client.commands.parsers.interfaces.AbstractResponseParser;
import com.spectralogic.ds3client.commands.parsers.utils.ResponseParserUtils;
import com.spectralogic.ds3client.commands.spectrads3.GetCompletedJobsSpectraS3Response;
import com.spectralogic.ds3client.models.CompletedJobList;
import com.spectralogic.ds3client.networking.WebResponse;
import com.spectralogic.ds3client.serializer.XmlOutput;
import java.io.IOException;
import java.io.InputStream;

public class GetCompletedJobsSpectraS3ResponseParser
extends AbstractResponseParser<GetCompletedJobsSpectraS3Response> {
    private final int[] expectedStatusCodes = new int[]{200};

    @Override
    public GetCompletedJobsSpectraS3Response parseXmlResponse(WebResponse response) throws IOException {
        int statusCode = response.getStatusCode();
        Integer pagingTruncated = this.parseIntHeader("page-truncated");
        Integer pagingTotalResultCount = this.parseIntHeader("total-result-count");
        if (ResponseParserUtils.validateStatusCode(statusCode, this.expectedStatusCodes)) {
            switch (statusCode) {
                case 200: {
                    try (InputStream inputStream = response.getResponseStream();){
                        CompletedJobList result = XmlOutput.fromXml(inputStream, CompletedJobList.class);
                        GetCompletedJobsSpectraS3Response getCompletedJobsSpectraS3Response = new GetCompletedJobsSpectraS3Response(result, pagingTotalResultCount, pagingTruncated, this.getChecksum(), this.getChecksumType());
                        return getCompletedJobsSpectraS3Response;
                    }
                }
            }
            assert (false) : "validateStatusCode should have made it impossible to reach this line";
        }
        throw ResponseParserUtils.createFailedRequest(response, this.expectedStatusCodes);
    }
}

