/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.spectrads3;

import com.spectralogic.ds3client.commands.interfaces.AbstractRequest;
import com.spectralogic.ds3client.models.DataReplicationRuleType;
import com.spectralogic.ds3client.networking.HttpVerb;

public class ModifyDs3DataReplicationRuleSpectraS3Request
extends AbstractRequest {
    private final String ds3DataReplicationRule;
    private boolean replicateDeletes;
    private String targetDataPolicy;
    private DataReplicationRuleType type;

    public ModifyDs3DataReplicationRuleSpectraS3Request(String ds3DataReplicationRule) {
        this.ds3DataReplicationRule = ds3DataReplicationRule;
    }

    public ModifyDs3DataReplicationRuleSpectraS3Request withReplicateDeletes(boolean replicateDeletes) {
        this.replicateDeletes = replicateDeletes;
        this.updateQueryParam("replicate_deletes", replicateDeletes);
        return this;
    }

    public ModifyDs3DataReplicationRuleSpectraS3Request withTargetDataPolicy(String targetDataPolicy) {
        this.targetDataPolicy = targetDataPolicy;
        this.updateQueryParam("target_data_policy", targetDataPolicy);
        return this;
    }

    public ModifyDs3DataReplicationRuleSpectraS3Request withType(DataReplicationRuleType type) {
        this.type = type;
        this.updateQueryParam("type", type);
        return this;
    }

    @Override
    public HttpVerb getVerb() {
        return HttpVerb.PUT;
    }

    @Override
    public String getPath() {
        return "/_rest_/ds3_data_replication_rule/" + this.ds3DataReplicationRule;
    }

    public String getDs3DataReplicationRule() {
        return this.ds3DataReplicationRule;
    }

    public boolean getReplicateDeletes() {
        return this.replicateDeletes;
    }

    public String getTargetDataPolicy() {
        return this.targetDataPolicy;
    }

    public DataReplicationRuleType getType() {
        return this.type;
    }
}

