/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.spectrads3;

import com.spectralogic.ds3client.commands.interfaces.AbstractRequest;
import com.spectralogic.ds3client.models.BucketAclPermission;
import com.spectralogic.ds3client.networking.HttpVerb;
import java.util.UUID;

public class PutBucketAclForUserSpectraS3Request
extends AbstractRequest {
    private final String bucketId;
    private final BucketAclPermission permission;
    private final String userId;

    public PutBucketAclForUserSpectraS3Request(String bucketId, BucketAclPermission permission, UUID userId) {
        this.bucketId = bucketId;
        this.permission = permission;
        this.userId = userId.toString();
        this.updateQueryParam("bucket_id", bucketId);
        this.updateQueryParam("permission", permission);
        this.updateQueryParam("user_id", userId);
    }

    public PutBucketAclForUserSpectraS3Request(String bucketId, BucketAclPermission permission, String userId) {
        this.bucketId = bucketId;
        this.permission = permission;
        this.userId = userId;
        this.updateQueryParam("bucket_id", bucketId);
        this.updateQueryParam("permission", permission);
        this.updateQueryParam("user_id", userId);
    }

    @Override
    public HttpVerb getVerb() {
        return HttpVerb.POST;
    }

    @Override
    public String getPath() {
        return "/_rest_/bucket_acl";
    }

    public String getBucketId() {
        return this.bucketId;
    }

    public BucketAclPermission getPermission() {
        return this.permission;
    }

    public String getUserId() {
        return this.userId;
    }
}

