/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.spectrads3;

import com.spectralogic.ds3client.commands.interfaces.AbstractRequest;
import com.spectralogic.ds3client.models.DataReplicationRuleType;
import com.spectralogic.ds3client.models.S3InitialDataPlacementPolicy;
import com.spectralogic.ds3client.networking.HttpVerb;
import java.util.UUID;

public class PutS3DataReplicationRuleSpectraS3Request
extends AbstractRequest {
    private final String dataPolicyId;
    private final String targetId;
    private final DataReplicationRuleType type;
    private S3InitialDataPlacementPolicy initialDataPlacement;
    private long maxBlobPartSizeInBytes;
    private boolean replicateDeletes;

    public PutS3DataReplicationRuleSpectraS3Request(UUID dataPolicyId, UUID targetId, DataReplicationRuleType type) {
        this.dataPolicyId = dataPolicyId.toString();
        this.targetId = targetId.toString();
        this.type = type;
        this.updateQueryParam("data_policy_id", dataPolicyId);
        this.updateQueryParam("target_id", targetId);
        this.updateQueryParam("type", type);
    }

    public PutS3DataReplicationRuleSpectraS3Request(String dataPolicyId, String targetId, DataReplicationRuleType type) {
        this.dataPolicyId = dataPolicyId;
        this.targetId = targetId;
        this.type = type;
        this.updateQueryParam("data_policy_id", dataPolicyId);
        this.updateQueryParam("target_id", targetId);
        this.updateQueryParam("type", type);
    }

    public PutS3DataReplicationRuleSpectraS3Request withInitialDataPlacement(S3InitialDataPlacementPolicy initialDataPlacement) {
        this.initialDataPlacement = initialDataPlacement;
        this.updateQueryParam("initial_data_placement", initialDataPlacement);
        return this;
    }

    public PutS3DataReplicationRuleSpectraS3Request withMaxBlobPartSizeInBytes(long maxBlobPartSizeInBytes) {
        this.maxBlobPartSizeInBytes = maxBlobPartSizeInBytes;
        this.updateQueryParam("max_blob_part_size_in_bytes", maxBlobPartSizeInBytes);
        return this;
    }

    public PutS3DataReplicationRuleSpectraS3Request withReplicateDeletes(boolean replicateDeletes) {
        this.replicateDeletes = replicateDeletes;
        this.updateQueryParam("replicate_deletes", replicateDeletes);
        return this;
    }

    @Override
    public HttpVerb getVerb() {
        return HttpVerb.POST;
    }

    @Override
    public String getPath() {
        return "/_rest_/s3_data_replication_rule";
    }

    public String getDataPolicyId() {
        return this.dataPolicyId;
    }

    public String getTargetId() {
        return this.targetId;
    }

    public DataReplicationRuleType getType() {
        return this.type;
    }

    public S3InitialDataPlacementPolicy getInitialDataPlacement() {
        return this.initialDataPlacement;
    }

    public long getMaxBlobPartSizeInBytes() {
        return this.maxBlobPartSizeInBytes;
    }

    public boolean getReplicateDeletes() {
        return this.replicateDeletes;
    }
}

