/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.helpers.pagination.commands;

import com.spectralogic.ds3client.Ds3Client;
import com.spectralogic.ds3client.commands.spectrads3.GetObjectsWithFullDetailsSpectraS3Request;
import com.spectralogic.ds3client.commands.spectrads3.GetObjectsWithFullDetailsSpectraS3Response;
import com.spectralogic.ds3client.helpers.pagination.PaginatingCommand;
import com.spectralogic.ds3client.models.DetailedS3Object;
import java.io.IOException;
import java.util.List;

public class GetObjectsFullDetailsPaginatingCommand
implements PaginatingCommand<DetailedS3Object, GetObjectsWithFullDetailsSpectraS3Request, GetObjectsWithFullDetailsSpectraS3Response> {
    private final Ds3Client client;
    private final String bucket;
    private final boolean includePhysicalDetails;

    public GetObjectsFullDetailsPaginatingCommand(Ds3Client client, String bucket, boolean includePhysicalDetails) {
        this.client = client;
        this.bucket = bucket;
        this.includePhysicalDetails = includePhysicalDetails;
    }

    @Override
    public GetObjectsWithFullDetailsSpectraS3Request createRequest() {
        return new GetObjectsWithFullDetailsSpectraS3Request().withBucketId(this.bucket).withIncludePhysicalPlacement(this.includePhysicalDetails);
    }

    @Override
    public GetObjectsWithFullDetailsSpectraS3Response invokeCommand(GetObjectsWithFullDetailsSpectraS3Request paginationRequest) throws IOException {
        return this.client.getObjectsWithFullDetailsSpectraS3(paginationRequest);
    }

    @Override
    public List<DetailedS3Object> getResponseContents(GetObjectsWithFullDetailsSpectraS3Response response) {
        return response.getDetailedS3ObjectListResult().getDetailedS3Objects();
    }
}

