/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.networking;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import com.spectralogic.ds3client.models.Error;
import com.spectralogic.ds3client.utils.Guard;
import java.io.IOException;
import java.util.List;

public class FailedRequestException
extends IOException {
    private static final long serialVersionUID = -2070737734216316074L;
    private final int statusCode;
    private final ImmutableList<Integer> expectedStatusCodes;
    private final Error error;
    private final String responseString;
    private final String requestId;

    public FailedRequestException(int[] expectedStatusCodes, int statusCode, Error error, String responseString, String requestId) {
        this(FailedRequestException.toList(expectedStatusCodes), statusCode, error, responseString, requestId);
    }

    private static ImmutableList<Integer> toList(int[] expectedStatusCodes) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int expectedStatusCode : expectedStatusCodes) {
            builder.add((Object)expectedStatusCode);
        }
        return builder.build();
    }

    public FailedRequestException(ImmutableList<Integer> expectedStatusCodes, int statusCode, Error error, String responseString, String requestId) {
        super(FailedRequestException.buildExceptionMessage(error, expectedStatusCodes, statusCode, requestId));
        this.statusCode = statusCode;
        this.expectedStatusCodes = expectedStatusCodes;
        this.error = error;
        this.responseString = responseString;
        this.requestId = requestId;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public List<Integer> getExpectedStatusCodes() {
        ImmutableList.Builder builder = ImmutableList.builder();
        UnmodifiableIterator unmodifiableIterator = this.expectedStatusCodes.iterator();
        while (unmodifiableIterator.hasNext()) {
            int status = (Integer)unmodifiableIterator.next();
            builder.add((Object)status);
        }
        return builder.build();
    }

    public Error getError() {
        return this.error;
    }

    public String getResponseString() {
        return this.responseString;
    }

    public String getRequestId() {
        return this.requestId;
    }

    protected static String buildExceptionMessage(Error error, ImmutableList<Integer> expectedStatusCodes, int statusCode, String requestId) {
        Joiner joiner = Joiner.on((String)", ");
        return error == null ? String.format("Expected a status code of %s but got %d %s. Could not parse the response for additional information.", joiner.join(expectedStatusCodes), statusCode, FailedRequestException.buildRequestIdMessage(requestId)) : String.format("Expected a status code of %s but got %d %s. Error message: \"%s\"", joiner.join(expectedStatusCodes), statusCode, FailedRequestException.buildRequestIdMessage(requestId), error.getMessage());
    }

    protected static String buildRequestIdMessage(String requestId) {
        if (Guard.isStringNullOrEmpty((String)requestId)) {
            return "for unknown request";
        }
        return "for request #" + requestId;
    }

    @Override
    public String toString() {
        if (this.error == null) {
            return this.responseString;
        }
        return this.error.toString();
    }
}

