/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sftp;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Read;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.sftp.SFTPExceptionMappingService;
import ch.cyberduck.core.sftp.SFTPSession;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.IOException;
import java.io.InputStream;
import java.util.EnumSet;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import net.schmizz.sshj.sftp.OpenMode;
import net.schmizz.sshj.sftp.RemoteFile;
import org.apache.log4j.Logger;

public class SFTPReadFeature
implements Read {
    private static final Logger log = Logger.getLogger(SFTPReadFeature.class);
    private final SFTPSession session;
    private final Preferences preferences = PreferencesFactory.get();

    public SFTPReadFeature(SFTPSession session) {
        this.session = session;
    }

    public InputStream read(Path file, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        try {
            final RemoteFile handle = this.session.sftp().open(file.getAbsolute(), EnumSet.of(OpenMode.READ));
            int maxUnconfirmedReads = this.getMaxUnconfirmedReads(status);
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Skipping %d bytes", status.getOffset()));
            }
            RemoteFile remoteFile = handle;
            Objects.requireNonNull(remoteFile);
            return new RemoteFile.ReadAheadRemoteFileInputStream(remoteFile, maxUnconfirmedReads, status.getOffset(), status.getLength()){
                private final AtomicBoolean close;
                {
                    RemoteFile remoteFile2 = x0;
                    Objects.requireNonNull(remoteFile2);
                    super(remoteFile2, arg0, arg1, arg2);
                    this.close = new AtomicBoolean();
                }

                public void close() throws IOException {
                    if (this.close.get()) {
                        log.warn((Object)String.format("Skip double close of stream %s", new Object[]{this}));
                        return;
                    }
                    try {
                        super.close();
                    }
                    finally {
                        handle.close();
                        this.close.set(true);
                    }
                }
            };
        }
        catch (IOException e) {
            throw new SFTPExceptionMappingService().map("Download {0} failed", e, file);
        }
    }

    protected int getMaxUnconfirmedReads(TransferStatus status) {
        if (-1L == status.getLength()) {
            return this.preferences.getInteger("sftp.read.maxunconfirmed");
        }
        return Integer.min((int)(status.getLength() / (long)this.preferences.getInteger("connection.chunksize")) + 1, this.preferences.getInteger("sftp.read.maxunconfirmed"));
    }

    public boolean offset(Path file) {
        return true;
    }
}

