/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.CertificateIdentityCallback;
import ch.cyberduck.core.Controller;
import ch.cyberduck.core.DisabledCertificateIdentityCallback;
import ch.cyberduck.core.Factory;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.apache.log4j.Logger;

public class CertificateIdentityCallbackFactory
extends Factory<CertificateIdentityCallback> {
    private static final Logger log = Logger.getLogger(CertificateIdentityCallbackFactory.class);
    private Constructor<CertificateIdentityCallback> constructor;

    protected CertificateIdentityCallbackFactory() {
        super("factory.certificateidentitycallback.class");
    }

    public CertificateIdentityCallback create(Controller controller) {
        try {
            if (null == this.constructor) {
                this.constructor = ConstructorUtils.getMatchingAccessibleConstructor((Class)this.clazz, (Class[])new Class[]{controller.getClass()});
            }
            if (null == this.constructor) {
                log.warn((Object)String.format("No matching constructor for parameter %s", controller.getClass()));
                return (CertificateIdentityCallback)this.clazz.newInstance();
            }
            return this.constructor.newInstance(controller);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            log.error((Object)String.format("Failure loading callback class %s. %s", this.clazz, e.getMessage()));
            return new DisabledCertificateIdentityCallback();
        }
    }

    public static CertificateIdentityCallback get(Controller c) {
        return new CertificateIdentityCallbackFactory().create(c);
    }
}

