/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.CertificateIdentityCallbackFactory;
import ch.cyberduck.core.CertificateStore;
import ch.cyberduck.core.CertificateStoreFactory;
import ch.cyberduck.core.CertificateTrustCallbackFactory;
import ch.cyberduck.core.ConnectionService;
import ch.cyberduck.core.Controller;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostKeyCallback;
import ch.cyberduck.core.HostKeyCallbackFactory;
import ch.cyberduck.core.HostPasswordStore;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.LoginCallbackFactory;
import ch.cyberduck.core.LoginConnectionService;
import ch.cyberduck.core.PasswordStoreFactory;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.SessionFactory;
import ch.cyberduck.core.TranscriptListener;
import ch.cyberduck.core.pool.DefaultSessionPool;
import ch.cyberduck.core.pool.SessionPool;
import ch.cyberduck.core.pool.StatefulSessionPool;
import ch.cyberduck.core.pool.StatelessSessionPool;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.ssl.DefaultTrustManagerHostnameCallback;
import ch.cyberduck.core.ssl.KeychainX509KeyManager;
import ch.cyberduck.core.ssl.KeychainX509TrustManager;
import ch.cyberduck.core.ssl.X509KeyManager;
import ch.cyberduck.core.ssl.X509TrustManager;
import ch.cyberduck.core.vault.VaultRegistry;
import ch.cyberduck.core.vault.VaultRegistryFactory;
import java.util.Arrays;
import org.apache.log4j.Logger;

public class SessionPoolFactory {
    private static final Logger log = Logger.getLogger(SessionPoolFactory.class);

    private SessionPoolFactory() {
    }

    public static SessionPool create(Controller controller, Host bookmark) {
        return SessionPoolFactory.create(controller, bookmark, controller);
    }

    public static SessionPool create(Controller controller, Host bookmark, ProgressListener listener) {
        return SessionPoolFactory.create(controller, bookmark, listener, Usage.transfer);
    }

    public static SessionPool create(Controller controller, Host bookmark, Usage ... usage) {
        return SessionPoolFactory.create(controller, bookmark, (ProgressListener)controller, usage);
    }

    public static SessionPool create(Controller controller, Host bookmark, ProgressListener listener, TranscriptListener transcript, Usage ... usage) {
        return SessionPoolFactory.create(controller, bookmark, PasswordStoreFactory.get(), LoginCallbackFactory.get(controller), HostKeyCallbackFactory.get(controller, bookmark.getProtocol()), listener, transcript, usage);
    }

    public static SessionPool create(Controller controller, Host bookmark, ProgressListener listener, Usage ... usage) {
        return SessionPoolFactory.create(controller, bookmark, PasswordStoreFactory.get(), LoginCallbackFactory.get(controller), HostKeyCallbackFactory.get(controller, bookmark.getProtocol()), listener, controller, usage);
    }

    public static SessionPool create(Controller controller, Host bookmark, HostPasswordStore keychain, LoginCallback login, HostKeyCallback key, ProgressListener listener, TranscriptListener transcript, Usage ... usage) {
        LoginConnectionService connect = new LoginConnectionService(login, key, keychain, listener);
        CertificateStore certificates = CertificateStoreFactory.get();
        return SessionPoolFactory.create(connect, transcript, bookmark, new KeychainX509TrustManager(CertificateTrustCallbackFactory.get(controller), new DefaultTrustManagerHostnameCallback(bookmark), certificates), new KeychainX509KeyManager(CertificateIdentityCallbackFactory.get(controller), bookmark, certificates), VaultRegistryFactory.create(keychain, login), usage);
    }

    public static SessionPool create(ConnectionService connect, TranscriptListener transcript, Host bookmark, X509TrustManager x509TrustManager, X509KeyManager x509KeyManager, VaultRegistry registry, Usage ... usage) {
        switch (bookmark.getProtocol().getStatefulness()) {
            case stateful: {
                if (Arrays.asList(usage).contains((Object)Usage.browser)) {
                    return SessionPoolFactory.stateful(connect, transcript, bookmark, x509TrustManager, x509KeyManager, registry);
                }
                if (log.isInfoEnabled()) {
                    log.info((Object)String.format("Create new pooled connection pool for %s", bookmark));
                }
                return new DefaultSessionPool(connect, x509TrustManager, x509KeyManager, registry, transcript, bookmark).withMinIdle(PreferencesFactory.get().getInteger("connection.pool.minidle")).withMaxIdle(PreferencesFactory.get().getInteger("connection.pool.maxidle")).withMaxTotal(PreferencesFactory.get().getInteger("connection.pool.maxtotal"));
            }
        }
        return SessionPoolFactory.stateless(connect, transcript, bookmark, x509TrustManager, x509KeyManager, registry);
    }

    protected static SessionPool stateless(ConnectionService connect, TranscriptListener transcript, Host bookmark, X509TrustManager trust, X509KeyManager key, VaultRegistry vault) {
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Create new stateless connection pool for %s", bookmark));
        }
        Session<?> session = SessionFactory.create(bookmark, trust, key);
        return new StatelessSessionPool(connect, session, transcript, vault);
    }

    protected static SessionPool stateful(ConnectionService connect, TranscriptListener transcript, Host bookmark, X509TrustManager trust, X509KeyManager key, VaultRegistry vault) {
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Create new stateful connection pool for %s", bookmark));
        }
        Session<?> session = SessionFactory.create(bookmark, trust, key);
        return new StatefulSessionPool(connect, session, transcript, vault);
    }

    public static enum Usage {
        transfer,
        browser;

    }
}

