/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.threading;

import ch.cyberduck.core.threading.ThreadPool;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public abstract class ExecutorServiceThreadPool
implements ThreadPool {
    private static final Logger log = Logger.getLogger(ExecutorServiceThreadPool.class);
    private final AbstractExecutorService pool;

    public ExecutorServiceThreadPool(AbstractExecutorService pool) {
        this.pool = pool;
    }

    @Override
    public void shutdown(boolean gracefully) {
        if (gracefully) {
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Shutdown pool %s gracefully", this.pool));
            }
            this.pool.shutdown();
            try {
                while (!this.pool.awaitTermination(1L, TimeUnit.SECONDS)) {
                    log.warn((Object)String.format("Await termination for pool %s", this.pool));
                }
            }
            catch (InterruptedException e) {
                log.error((Object)String.format("Failure awaiting pool termination. %s", e.getMessage()));
            }
        } else {
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Shutdown pool %s now", this.pool));
            }
            this.pool.shutdownNow();
        }
    }

    @Override
    public <T> Future<T> execute(Callable<T> command) {
        return this.pool.submit(command);
    }

    @Override
    public AbstractExecutorService executor() {
        return this.pool;
    }
}

